/*
 * Decompiled with CFR 0.152.
 */
package MSBE;

import MSBE.BiclusterInfo;
import MSBE.DoubleMatrix;
import MSBE.LongMatrix;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.Random;

public class ConstantBicluster {
    public static int[] getListFile(String string) {
        int n = 0;
        BufferedReader bufferedReader = null;
        String string2 = null;
        int[] nArray = new int[1];
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            n = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                ++n;
            }
            bufferedReader.close();
            nArray = new int[n];
            bufferedReader = new BufferedReader(new FileReader(string));
            for (int i = 0; i < n; ++i) {
                string2 = bufferedReader.readLine();
                nArray[i] = Integer.parseInt(string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        return nArray;
    }

    static String getStr(int n, int n2, int n3) {
        int n4;
        String string = new String();
        string = string + n + " Ref Gene: ";
        String string2 = Integer.toString(n2);
        for (n4 = 5; n4 >= string2.length(); --n4) {
            string2 = " " + string2;
        }
        string = string + string2;
        string2 = Integer.toString(n3);
        for (n4 = 3; n4 >= string2.length(); --n4) {
            string2 = " " + string2;
        }
        string = string + "     " + string2 + "% Finished \r";
        return string;
    }

    public static void main(String[] stringArray) {
        int n;
        int[] nArray = null;
        int n2 = 0;
        if (stringArray.length != 7) {
            System.out.println("PARAMETERS ERROR!");
            System.out.println();
            System.out.println("Please use \nconstantBi  <input file name> <alpha> <beta> <gamma> <ref gene mode> <ref gene> <result file name>");
            return;
        }
        System.out.println("---------------------------------");
        System.out.println("MSBE ver 1.0.5 Constant Bicluster");
        System.out.println("---------------------------------");
        String string = new String(stringArray[0]);
        String string2 = new String(stringArray[6]);
        double d = Double.parseDouble(stringArray[1]);
        double d2 = Double.parseDouble(stringArray[2]);
        double d3 = Double.parseDouble(stringArray[3]);
        System.out.println("Input file name: " + string);
        System.out.println("Output file name: " + string2);
        System.out.println("Parameters: alpha " + d + " beta " + d2 + " gamma " + d3);
        DoubleMatrix doubleMatrix = new DoubleMatrix();
        doubleMatrix.readData(string, 1, 1, -1, -1, 0, 0, '\t');
        LongMatrix longMatrix = new LongMatrix(doubleMatrix);
        LongMatrix longMatrix2 = new LongMatrix(longMatrix.row, longMatrix.col, longMatrix.info);
        LongMatrix longMatrix3 = new LongMatrix(longMatrix.row, longMatrix.col, longMatrix.info);
        System.out.println("Expression Matrix is loaded: " + longMatrix.row + " genes " + longMatrix.col + " conditions.");
        Random random = new Random(new Date().getTime());
        String string3 = stringArray[4];
        if (string3.equals("single")) {
            nArray = new int[1];
            n2 = 1;
            nArray[0] = Integer.parseInt(stringArray[5]);
        } else if (string3.equals("random")) {
            n2 = Integer.parseInt(stringArray[5]);
            nArray = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray[n] = random.nextInt(longMatrix.row) + 1;
            }
        } else if (string3.equals("list")) {
            nArray = ConstantBicluster.getListFile(stringArray[5]);
            System.out.println("Reference gene list file " + stringArray[5] + " is loaded.");
            n2 = nArray.length;
        } else {
            System.err.println("Reference gene mode " + string3 + " is not correct!");
            System.err.println("Please use single, random or list the reference gene mode ");
            return;
        }
        System.out.println("Reference gene number: " + n2);
        Object[] objectArray = new BiclusterInfo[n2];
        for (n = 0; n < n2; ++n) {
            int n3 = nArray[n] - 1;
            longMatrix.getRefRowDistance(longMatrix2, n3);
            int n4 = n * 100 / n2;
            System.out.print("                                                                      \r");
            String string4 = ConstantBicluster.getStr(n + 1, n3 + 1, n4);
            System.out.print(string4);
            longMatrix2.getSimilarity(longMatrix3, d, d2);
            objectArray[n] = longMatrix3.MSB(d3);
            ((BiclusterInfo)objectArray[n]).ref_gene = n3 + 1;
            ((BiclusterInfo)objectArray[n]).extend(longMatrix3, d3);
            ((BiclusterInfo)objectArray[n]).convertExp();
        }
        Arrays.sort(objectArray);
        Object cfr_ignored_0 = objectArray[0];
        BiclusterInfo.filter((BiclusterInfo[])objectArray, 0.25);
        int n5 = 0;
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(string2));
            for (int i = 0; i < n2; ++i) {
                if (((BiclusterInfo)objectArray[i]).is_filtered) continue;
                printWriter.print("No. " + ++n5);
                printWriter.print(" Gene num: " + ((BiclusterInfo)objectArray[i]).bi_row);
                printWriter.print(" Cond num: " + ((BiclusterInfo)objectArray[i]).bi_col);
                printWriter.print(" Ref Gene: " + ((BiclusterInfo)objectArray[i]).ref_gene);
                ((BiclusterInfo)objectArray[i]).avg_sim = (double)Math.round(((BiclusterInfo)objectArray[i]).avg_sim * 1000.0) / 1000.0;
                printWriter.println(" Avg Sim: " + ((BiclusterInfo)objectArray[i]).avg_sim);
                for (n = 0; n < ((BiclusterInfo)objectArray[i]).bi_row; ++n) {
                    printWriter.print(" " + (((BiclusterInfo)objectArray[i]).row_list[n] + 1));
                }
                printWriter.println();
                for (int j = 0; j < ((BiclusterInfo)objectArray[i]).bi_col; ++j) {
                    printWriter.print(" " + (((BiclusterInfo)objectArray[i]).col_list[j] + 1));
                }
                printWriter.println();
            }
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        System.out.print("                                                             \r");
        System.out.println("100% finished");
        System.out.println("Biclustering results are saved in file: " + string2);
    }
}

