/*
 * Decompiled with CFR 0.152.
 */
package MSBE;

import MSBE.LongMatrix;

public class BiclusterInfo
implements Comparable {
    int bi_row;
    int bi_col;
    int size;
    boolean[] select_row;
    boolean[] select_col;
    int[] row_list;
    int[] col_list;
    int ref_gene;
    int ref_col;
    double min_sim;
    double sum_sim;
    double avg_sim;
    boolean is_filtered;

    public BiclusterInfo() {
    }

    public BiclusterInfo(int n, int n2, boolean bl) {
        this.select_row = new boolean[n];
        this.select_col = new boolean[n2];
        this.is_filtered = false;
        if (bl) {
            for (int i = 0; i < n; ++i) {
                this.select_row[i] = true;
            }
            for (int i = 0; i < n2; ++i) {
                this.select_col[i] = true;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                this.select_row[i] = true;
            }
            for (int i = 0; i < n2; ++i) {
                this.select_col[i] = true;
            }
            this.bi_row = 0;
            this.bi_col = 0;
            this.size = 0;
            this.min_sim = 0.0;
            this.sum_sim = 0.0;
            this.avg_sim = 0.0;
        }
    }

    public int compareTo(Object object) {
        BiclusterInfo biclusterInfo = (BiclusterInfo)object;
        if (this.size > biclusterInfo.size) {
            return -1;
        }
        if (this.size < biclusterInfo.size) {
            return 1;
        }
        return 0;
    }

    public void extend(LongMatrix longMatrix, double d) {
        int n;
        long l = Math.round(d * (double)longMatrix.thresh_dist);
        long[] lArray = new long[longMatrix.row];
        for (n = 0; n < longMatrix.row; ++n) {
            lArray[n] = 0L;
            for (int i = 0; i < longMatrix.col; ++i) {
                if (!this.select_col[i]) continue;
                int n2 = n;
                lArray[n2] = lArray[n2] + longMatrix.data[n][i];
            }
        }
        long l2 = Math.round(this.sum_sim * (double)longMatrix.thresh_dist);
        long l3 = Math.round(this.min_sim * (double)longMatrix.thresh_dist);
        if (this.bi_col > 0) {
            for (n = 0; n < longMatrix.row; ++n) {
                if (lArray[n] / (long)this.bi_col <= l || this.select_row[n]) continue;
                this.select_row[n] = true;
                ++this.bi_row;
                l2 += lArray[n];
                if (lArray[n] >= l3) continue;
                l3 = lArray[n];
            }
            this.size = this.bi_row * this.bi_col;
            this.sum_sim = (double)l2 / (double)longMatrix.thresh_dist;
            this.min_sim = (double)l3 / (double)longMatrix.thresh_dist;
            this.avg_sim = this.sum_sim / (double)this.size;
        } else {
            this.size = 0;
            this.sum_sim = 0.0;
            this.min_sim = 0.0;
            this.avg_sim = 0.0;
        }
    }

    public void convertExp() {
        int n;
        this.row_list = new int[this.bi_row];
        this.col_list = new int[this.bi_col];
        int n2 = 0;
        for (n = 0; n < this.select_row.length; ++n) {
            if (!this.select_row[n]) continue;
            this.row_list[n2] = n;
            ++n2;
        }
        n2 = 0;
        for (n = 0; n < this.select_col.length; ++n) {
            if (!this.select_col[n]) continue;
            this.col_list[n2] = n;
            ++n2;
        }
        this.select_row = null;
        this.select_col = null;
    }

    public static void filterOneRow(BiclusterInfo[] biclusterInfoArray, double d) {
        int n;
        for (n = 0; n < biclusterInfoArray.length; ++n) {
            biclusterInfoArray[n].is_filtered = false;
        }
        for (n = 0; n < biclusterInfoArray.length; ++n) {
            if (biclusterInfoArray[n].is_filtered) continue;
            for (int i = n + 1; i < biclusterInfoArray.length; ++i) {
                if (biclusterInfoArray[i].is_filtered) continue;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                while (n3 < biclusterInfoArray[n].bi_col && n4 < biclusterInfoArray[i].bi_col) {
                    if (biclusterInfoArray[n].col_list[n3] == biclusterInfoArray[i].col_list[n4]) {
                        ++n2;
                        ++n3;
                        ++n4;
                        continue;
                    }
                    if (biclusterInfoArray[n].col_list[n3] < biclusterInfoArray[i].col_list[n4]) {
                        ++n3;
                        continue;
                    }
                    ++n4;
                }
                if (!((double)((float)n2 / (float)biclusterInfoArray[i].bi_col) >= d)) continue;
                biclusterInfoArray[i].is_filtered = true;
            }
        }
    }

    public static void filter(BiclusterInfo[] biclusterInfoArray, double d) {
        for (int i = 0; i < biclusterInfoArray.length; ++i) {
            if (biclusterInfoArray[i].is_filtered) continue;
            for (int j = i + 1; j < biclusterInfoArray.length; ++j) {
                if (biclusterInfoArray[j].is_filtered) continue;
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                while (n2 < biclusterInfoArray[i].bi_row && n3 < biclusterInfoArray[j].bi_row) {
                    if (biclusterInfoArray[i].row_list[n2] == biclusterInfoArray[j].row_list[n3]) {
                        ++n;
                        ++n2;
                        ++n3;
                        continue;
                    }
                    if (biclusterInfoArray[i].row_list[n2] < biclusterInfoArray[j].row_list[n3]) {
                        ++n2;
                        continue;
                    }
                    ++n3;
                }
                int n4 = 0;
                n2 = 0;
                n3 = 0;
                while (n2 < biclusterInfoArray[i].bi_col && n3 < biclusterInfoArray[j].bi_col) {
                    if (biclusterInfoArray[i].col_list[n2] == biclusterInfoArray[j].col_list[n3]) {
                        ++n4;
                        ++n2;
                        ++n3;
                        continue;
                    }
                    if (biclusterInfoArray[i].col_list[n2] < biclusterInfoArray[j].col_list[n3]) {
                        ++n2;
                        continue;
                    }
                    ++n3;
                }
                if (!((double)((float)(n * n4) / ((float)biclusterInfoArray[j].bi_row * (float)biclusterInfoArray[j].bi_col)) >= d)) continue;
                biclusterInfoArray[j].is_filtered = true;
            }
        }
    }
}

