#!/bin/sh

# Setup additiveBi.sh and constantBi.sh


if test '!' -f `pwd`/MSBE.jar ; then
  echo 'You must run this setup script in the directory containing MSBE.jar'
  exit 1
fi

sed <additiveBi.in >additiveBi -e 's;MSBE_JAR_DIR=.;MSBE_JAR_DIR='`pwd`';'
sed <constantBi.in >constantBi -e 's;MSBE_JAR_DIR=.;MSBE_JAR_DIR='`pwd`';'

chmod +x additiveBi
chmod +x constantBi

echo 'The two shell scripts: additiveBi and constantBi are configured.' 
echo 'Please move the two shell scripts to a /bin directory and leave' 
echo 'all other files in this directory.'
echo
echo 'To find constant biclusters, use'
echo 'constantBi <input file name> <alpha> <beta> <gamma> <ref gene mode> <ref gene> <result file name>'
echo
echo 'To find additive biclusters, use'
echo 'additiveBi <input file name> <alpha> <beta> <gamma> <ref gene mode> <ref gene> <ref condition mode> <ref condition> <result file name>'