/*
 * Decompiled with CFR 0.152.
 */
package MSBE;

import MSBE.BiclusterInfo;
import MSBE.DoubleMatrix;
import MSBE.LinkList;
import MSBE.ListNode;
import MSBE.MatrixInfo;
import java.io.FileOutputStream;
import java.io.PrintWriter;

public class LongMatrix {
    static final long NULL_DATA = 10000000000000L;
    static final long NULL_BOUND = 1000000000000L;
    static final long PRECISION = 10000L;
    int row;
    int col;
    MatrixInfo info;
    long[][] data;
    long avg;
    long thresh_dist;

    public LongMatrix(int n, int n2, MatrixInfo matrixInfo) {
        this.row = n;
        this.col = n2;
        this.info = matrixInfo;
        this.data = new long[this.row][this.col];
    }

    public LongMatrix(DoubleMatrix doubleMatrix) {
        this.row = doubleMatrix.row;
        this.col = doubleMatrix.col;
        this.info = doubleMatrix.info;
        this.data = new long[this.row][this.col];
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                this.data[i][j] = doubleMatrix.isNull(doubleMatrix.data[i][j]) ? 10000000000000L : Math.round(doubleMatrix.data[i][j] * 10000.0);
            }
        }
    }

    public final boolean isNull(long l) {
        return l >= 1000000000000L;
    }

    public void outputData(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        try {
            int n;
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(string));
            if (bl2) {
                printWriter.print("\t");
                for (n = 0; n < this.col; ++n) {
                    printWriter.print("\t" + this.info.col_id[n]);
                }
                printWriter.println();
            }
            if (bl4) {
                printWriter.print("\t");
                for (n = 0; n < this.col; ++n) {
                    printWriter.print("\t" + this.info.col_name[n]);
                }
                printWriter.println();
            }
            for (n = 0; n < this.row; ++n) {
                if (bl) {
                    printWriter.print(this.info.row_id[n]);
                }
                if (bl3) {
                    if (bl) {
                        printWriter.print("\t");
                    }
                    printWriter.print(this.info.row_name[n]);
                }
                for (int i = 0; i < this.col; ++i) {
                    if (i != 0 || bl3 || bl) {
                        printWriter.print("\t");
                    }
                    if (this.isNull(this.data[n][i])) continue;
                    printWriter.print(this.data[n][i]);
                }
                printWriter.println();
            }
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public void getRefRowDistance(LongMatrix longMatrix, int n) {
        if (n >= this.row || n < 0) {
            System.err.println("Wrong parameter ref row:" + n);
            System.exit(1);
        }
        int n2 = 0;
        long l = 0L;
        for (int i = 0; i < this.col; ++i) {
            int n3;
            if (this.data[n][i] < 1000000000000L) {
                for (n3 = 0; n3 < this.row; ++n3) {
                    if (this.data[n3][i] < 1000000000000L) {
                        longMatrix.data[n3][i] = this.data[n3][i] - this.data[n][i];
                        if (longMatrix.data[n3][i] < 0L) {
                            longMatrix.data[n3][i] = -longMatrix.data[n3][i];
                        }
                        ++n2;
                        l += longMatrix.data[n3][i];
                        continue;
                    }
                    longMatrix.data[n3][i] = 10000000000000L;
                }
                continue;
            }
            for (n3 = 0; n3 < this.row; ++n3) {
                longMatrix.data[n3][i] = 10000000000000L;
            }
        }
        longMatrix.avg = n2 == 0 ? 0L : l / (long)n2;
    }

    public void minusRefRow(LongMatrix longMatrix, int n) {
        if (n >= this.row || n < 0) {
            System.err.println("Wrong parameter ref row:" + n);
            System.exit(1);
        }
        for (int i = 0; i < this.col; ++i) {
            int n2;
            if (this.data[n][i] < 1000000000000L) {
                for (n2 = 0; n2 < this.row; ++n2) {
                    longMatrix.data[n2][i] = this.data[n2][i] < 1000000000000L ? this.data[n2][i] - this.data[n][i] : 10000000000000L;
                }
                continue;
            }
            for (n2 = 0; n2 < this.row; ++n2) {
                longMatrix.data[n2][i] = 10000000000000L;
            }
        }
    }

    public void getRefColDistance(LongMatrix longMatrix, int n) {
        if (n >= this.col || n < 0) {
            System.err.println("Wrong parameter ref col:" + n);
            System.exit(1);
        }
        int n2 = 0;
        long l = 0L;
        for (int i = 0; i < this.row; ++i) {
            int n3;
            if (this.data[i][n] < 1000000000000L) {
                for (n3 = 0; n3 < this.col; ++n3) {
                    if (this.data[i][n3] < 1000000000000L) {
                        longMatrix.data[i][n3] = this.data[i][n3] - this.data[i][n];
                        if (longMatrix.data[i][n3] < 0L) {
                            longMatrix.data[i][n3] = -longMatrix.data[i][n3];
                        }
                        ++n2;
                        l += longMatrix.data[i][n3];
                        continue;
                    }
                    longMatrix.data[i][n3] = 10000000000000L;
                }
                continue;
            }
            for (n3 = 0; n3 < this.col; ++n3) {
                longMatrix.data[i][n3] = 10000000000000L;
            }
        }
        longMatrix.avg = n2 == 0 ? 0L : l / (long)n2;
    }

    public void getSimilarity(LongMatrix longMatrix, double d, double d2) {
        longMatrix.thresh_dist = this.thresh_dist = Math.round((double)this.avg * d);
        longMatrix.avg = this.avg;
        long l = Math.round((double)this.thresh_dist * d2);
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                longMatrix.data[i][j] = this.data[i][j] > this.thresh_dist ? 0L : this.thresh_dist - this.data[i][j] + l;
            }
        }
    }

    public BiclusterInfo MSB(double d) {
        int n;
        int n2;
        long l;
        int n3;
        long l2 = Math.round((double)this.thresh_dist * d);
        boolean[] blArray = new boolean[this.row + this.col - 1];
        int[] nArray = new int[this.row + this.col - 1];
        int[] nArray2 = new int[this.row + this.col - 1];
        int[] nArray3 = new int[this.row + this.col - 1];
        long[] lArray = new long[this.row + this.col - 1];
        long[] lArray2 = new long[this.row + this.col - 1];
        long[] lArray3 = new long[this.row + this.col - 1];
        LinkList linkList = new LinkList(this.row, 1000000000000L * (long)this.col);
        LinkList linkList2 = new LinkList(this.col, 1000000000000L * (long)this.row);
        lArray2[0] = 0L;
        for (n3 = 0; n3 < this.row; ++n3) {
            l = 0L;
            for (n2 = 0; n2 < this.col; ++n2) {
                l += this.data[n3][n2];
            }
            linkList.list_node[n3].sim = l;
            lArray2[0] = lArray2[0] + l;
        }
        nArray2[0] = this.row;
        nArray3[0] = this.col;
        lArray3[0] = lArray2[0] / (long)(nArray2[0] * nArray3[0]);
        if (lArray2[0] == 0L) {
            return new BiclusterInfo(this.row, this.col, false);
        }
        for (n2 = 0; n2 < this.col; ++n2) {
            l = 0L;
            for (n3 = 0; n3 < this.row; ++n3) {
                l += this.data[n3][n2];
            }
            linkList2.list_node[n2].sim = l;
        }
        linkList.find_min_node();
        linkList2.find_min_node();
        for (n = 1; n < this.row + this.col - 1; ++n) {
            if (linkList.min_node.sim < linkList2.min_node.sim) {
                blArray[n - 1] = true;
                nArray[n - 1] = linkList.min_node.index;
                lArray[n - 1] = linkList.min_node.sim;
                linkList.delete_min_node();
                lArray2[n] = lArray2[n - 1] - linkList.min_node.sim;
                nArray2[n] = nArray2[n - 1] - 1;
                nArray3[n] = nArray3[n - 1];
                lArray3[n] = lArray2[n] / (long)(nArray2[n] * nArray3[n]);
                ListNode listNode = linkList2.head;
                while (listNode != null) {
                    listNode.sim -= this.data[nArray[n - 1]][listNode.index];
                    listNode = listNode.next;
                }
            } else {
                blArray[n - 1] = false;
                nArray[n - 1] = linkList2.min_node.index;
                lArray[n - 1] = linkList2.min_node.sim;
                linkList2.delete_min_node();
                lArray2[n] = lArray2[n - 1] - linkList2.min_node.sim;
                nArray2[n] = nArray2[n - 1];
                nArray3[n] = nArray3[n - 1] - 1;
                lArray3[n] = lArray2[n] / (long)(nArray2[n] * nArray3[n]);
                ListNode listNode = linkList.head;
                while (listNode != null) {
                    listNode.sim -= this.data[listNode.index][linkList2.min_node.index];
                    listNode = listNode.next;
                }
            }
            linkList.find_min_node();
            linkList2.find_min_node();
        }
        int n4 = -1;
        long l3 = 0L;
        for (n = 0; n < this.row + this.col - 1; ++n) {
            if (lArray3[n] <= l2 || lArray[n] <= l3) continue;
            l3 = lArray[n];
            n4 = n;
        }
        if (n4 < 0) {
            return new BiclusterInfo(this.row, this.col, false);
        }
        BiclusterInfo biclusterInfo = new BiclusterInfo(this.row, this.col, true);
        biclusterInfo.bi_row = nArray2[n4];
        biclusterInfo.bi_col = nArray3[n4];
        biclusterInfo.size = biclusterInfo.bi_row * biclusterInfo.bi_col;
        biclusterInfo.min_sim = (double)lArray[n4] / (double)this.thresh_dist;
        biclusterInfo.sum_sim = (double)lArray2[n4] / (double)this.thresh_dist;
        biclusterInfo.avg_sim = (double)lArray3[n4] / (double)this.thresh_dist;
        for (n = 0; n < n4; ++n) {
            if (blArray[n]) {
                biclusterInfo.select_row[nArray[n]] = false;
                continue;
            }
            biclusterInfo.select_col[nArray[n]] = false;
        }
        return biclusterInfo;
    }

    public static void main(String[] stringArray) {
    }
}

