/*
 * Decompiled with CFR 0.152.
 */
package MSBE;

import MSBE.MatrixInfo;
import MSBE.Util;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;

public class DoubleMatrix {
    static final double NULL_DATA = 1.0E9;
    static final double NULL_BOUND = 1.0E8;
    int row;
    int col;
    MatrixInfo info;
    double[][] data;

    public DoubleMatrix() {
        this.info = null;
        this.data = null;
    }

    public DoubleMatrix(int n, int n2, MatrixInfo matrixInfo) {
        this.row = n;
        this.col = n2;
        this.info = matrixInfo;
        this.data = new double[this.row][this.col];
    }

    public boolean isNull(double d) {
        return d >= 1.0E8;
    }

    public void readData(String string, int n, int n2, int n3, int n4, int n5, int n6, char c) {
        BufferedReader bufferedReader = null;
        String string2 = null;
        String[] stringArray = null;
        int n7 = 0;
        int n8 = -1;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                ++n7;
                int n9 = Util.countColumn(string2, c);
                if (n8 < 0) {
                    n8 = n9;
                }
                if (n8 == n9) continue;
                System.err.println("Invalid data!\n The number of columns are different at row " + n7);
                System.exit(1);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        this.row = n7 - n;
        this.col = n8 - n2;
        this.data = new double[this.row][this.col];
        this.info = new MatrixInfo(this.row, this.col);
        try {
            int n10;
            int n11;
            bufferedReader = new BufferedReader(new FileReader(string));
            for (n11 = 0; n11 < n; ++n11) {
                string2 = bufferedReader.readLine();
                if (n11 == n5) {
                    stringArray = Util.splitLine(string2, c);
                    for (n10 = 0; n10 < this.col; ++n10) {
                        this.info.col_name[n10] = stringArray[n10 + n2];
                    }
                }
                if (n11 != n3) continue;
                stringArray = Util.splitLine(string2, c);
                for (n10 = 0; n10 < this.col; ++n10) {
                    this.info.col_id[n10] = stringArray[n10 + n2];
                }
            }
            if (n3 < 0 || n3 >= n) {
                for (n11 = 0; n11 < this.col; ++n11) {
                    this.info.col_id[n11] = String.valueOf(n11 + 1);
                }
            }
            if (n5 < 0 || n5 >= n) {
                for (n11 = 0; n11 < this.col; ++n11) {
                    this.info.col_name[n11] = String.valueOf(n11 + 1);
                }
            }
            for (n11 = 0; n11 < this.row; ++n11) {
                string2 = bufferedReader.readLine();
                stringArray = Util.splitLine(string2, c);
                this.info.row_name[n11] = n6 >= 0 && n6 < n2 ? stringArray[n6] : String.valueOf(n11 + 1);
                this.info.row_id[n11] = n4 >= 0 && n4 < n2 ? stringArray[n4] : String.valueOf(n11 + 1);
                for (n10 = 0; n10 < this.col; ++n10) {
                    try {
                        this.data[n11][n10] = Double.parseDouble(stringArray[n10 + n2].trim());
                        continue;
                    }
                    catch (Exception exception) {
                        this.data[n11][n10] = 1.0E9;
                    }
                }
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public void outputData(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        try {
            int n;
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(string));
            if (bl2) {
                printWriter.print("\t");
                for (n = 0; n < this.col; ++n) {
                    printWriter.print("\t" + this.info.col_id[n]);
                }
                printWriter.println();
            }
            if (bl4) {
                printWriter.print("\t");
                for (n = 0; n < this.col; ++n) {
                    printWriter.print("\t" + this.info.col_name[n]);
                }
                printWriter.println();
            }
            for (n = 0; n < this.row; ++n) {
                if (bl) {
                    printWriter.print(this.info.row_id[n]);
                }
                if (bl3) {
                    if (bl) {
                        printWriter.print("\t");
                    }
                    printWriter.print(this.info.row_name[n]);
                }
                for (int i = 0; i < this.col; ++i) {
                    if (i != 0 || bl3 || bl) {
                        printWriter.print("\t");
                    }
                    if (this.isNull(this.data[n][i])) continue;
                    printWriter.print(this.data[n][i]);
                }
                printWriter.println();
            }
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) {
        DoubleMatrix doubleMatrix = new DoubleMatrix();
        char c = stringArray[1].equals("tab") ? (char)'\t' : (stringArray[1].equals("space") ? (char)' ' : (char)stringArray[1].charAt(0));
        doubleMatrix.readData(stringArray[0], 1, 1, 0, 0, -1, -1, c);
        System.out.println("Test A row " + doubleMatrix.row + " col " + doubleMatrix.col);
        doubleMatrix.outputData(stringArray[0] + "A1", true, true, true, true);
        doubleMatrix.outputData(stringArray[0] + "A2", true, true, false, false);
        doubleMatrix.outputData(stringArray[0] + "A3", false, false, true, true);
        doubleMatrix.outputData(stringArray[0] + "A4", false, false, false, false);
        doubleMatrix.readData(stringArray[0], 1, 1, -1, -1, 0, 0, c);
        System.out.println("Test B row " + doubleMatrix.row + " col " + doubleMatrix.col);
        doubleMatrix.outputData(stringArray[0] + "B1", true, true, true, true);
        doubleMatrix.outputData(stringArray[0] + "B2", true, true, false, false);
        doubleMatrix.outputData(stringArray[0] + "B3", false, false, true, true);
        doubleMatrix.outputData(stringArray[0] + "B4", false, false, false, false);
        doubleMatrix.readData(stringArray[0], 2, 2, 0, 0, 1, 1, c);
        System.out.println("Test C row " + doubleMatrix.row + " col " + doubleMatrix.col);
        doubleMatrix.outputData(stringArray[0] + "C1", true, true, true, true);
        doubleMatrix.outputData(stringArray[0] + "C2", true, true, false, false);
        doubleMatrix.outputData(stringArray[0] + "C3", false, false, true, true);
        doubleMatrix.outputData(stringArray[0] + "C4", false, false, false, false);
        doubleMatrix.readData(stringArray[0], 0, 0, -1, -1, -1, -1, c);
        System.out.println("Test D row " + doubleMatrix.row + " col " + doubleMatrix.col);
        doubleMatrix.outputData(stringArray[0] + "D1", true, true, true, true);
        doubleMatrix.outputData(stringArray[0] + "D2", true, true, false, false);
        doubleMatrix.outputData(stringArray[0] + "D3", false, false, true, true);
        doubleMatrix.outputData(stringArray[0] + "D4", false, false, false, false);
    }
}

