/*
 * Decompiled with CFR 0.152.
 */
package MSBE;

import MSBE.BiclusterInfo;
import MSBE.DoubleMatrix;
import MSBE.LongMatrix;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.Random;

public class AdditiveBicluster {
    public static int[] getListFile(String string) {
        int n = 0;
        BufferedReader bufferedReader = null;
        String string2 = null;
        int[] nArray = new int[1];
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            n = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                ++n;
            }
            bufferedReader.close();
            nArray = new int[n];
            bufferedReader = new BufferedReader(new FileReader(string));
            for (int i = 0; i < n; ++i) {
                string2 = bufferedReader.readLine();
                nArray[i] = Integer.parseInt(string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        return nArray;
    }

    static String getStr(int n, int n2, int n3) {
        int n4;
        String string = new String();
        string = string + n + " Ref Gene: ";
        String string2 = Integer.toString(n2);
        for (n4 = 5; n4 >= string2.length(); --n4) {
            string2 = " " + string2;
        }
        string = string + string2;
        string2 = Integer.toString(n3);
        for (n4 = 3; n4 >= string2.length(); --n4) {
            string2 = " " + string2;
        }
        string = string + "     " + string2 + "% Finished \r";
        return string;
    }

    public static void main(String[] stringArray) {
        int n;
        int n2;
        int n3;
        int[] nArray = null;
        int[] nArray2 = null;
        int n4 = 0;
        int n5 = 0;
        int n6 = 40;
        if (stringArray.length != 9) {
            System.out.println("PARAMETERS ERROR!");
            System.out.println();
            System.out.println("Please use \nadditiveBi  <input file name> <alpha> <beta> <gamma> <ref gene mode> <ref gene> <ref condition mode> <ref condition> <result file name>");
            return;
        }
        System.out.println("---------------------------------");
        System.out.println("MSBE ver 1.0.5 Additive Bicluster");
        System.out.println("---------------------------------");
        String string = new String(stringArray[0]);
        String string2 = new String(stringArray[8]);
        double d = Double.parseDouble(stringArray[1]);
        double d2 = Double.parseDouble(stringArray[2]);
        double d3 = Double.parseDouble(stringArray[3]);
        System.out.println("Input file name: " + string);
        System.out.println("Output file name: " + string2);
        System.out.println("Parameters: alpha " + d + " beta " + d2 + " gamma " + d3);
        DoubleMatrix doubleMatrix = new DoubleMatrix();
        doubleMatrix.readData(string, 1, 1, -1, -1, 0, 0, '\t');
        LongMatrix longMatrix = new LongMatrix(doubleMatrix);
        LongMatrix longMatrix2 = new LongMatrix(longMatrix.row, longMatrix.col, longMatrix.info);
        LongMatrix longMatrix3 = new LongMatrix(longMatrix.row, longMatrix.col, longMatrix.info);
        LongMatrix longMatrix4 = new LongMatrix(longMatrix.row, longMatrix.col, longMatrix.info);
        System.out.println("Expression Matrix is loaded: " + longMatrix.row + " genes " + longMatrix.col + " conditions.");
        Random random = new Random(new Date().getTime());
        String string3 = stringArray[4];
        if (string3.equals("single")) {
            nArray = new int[1];
            n4 = 1;
            nArray[0] = Integer.parseInt(stringArray[5]);
        } else if (string3.equals("random")) {
            n4 = Integer.parseInt(stringArray[5]);
            nArray = new int[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                nArray[n3] = random.nextInt(longMatrix.row) + 1;
            }
        } else if (string3.equals("list")) {
            nArray = AdditiveBicluster.getListFile(stringArray[5]);
            System.out.println("Reference gene list file " + stringArray[5] + " is loaded.");
            n4 = nArray.length;
        } else {
            System.err.println("Reference gene mode " + string3 + " is not correct!");
            System.err.println("Please use single, random or list the reference gene mode ");
            return;
        }
        System.out.println("Reference gene number: " + n4);
        String string4 = stringArray[6];
        if (string4.equals("single")) {
            nArray2 = new int[1];
            n5 = 1;
            nArray2[0] = Integer.parseInt(stringArray[7]);
        } else if (string4.equals("random")) {
            n5 = Integer.parseInt(stringArray[7]);
            nArray2 = new int[n5];
            for (n3 = 0; n3 < n5; ++n3) {
                nArray2[n3] = random.nextInt(longMatrix.col) + 1;
            }
        } else if (string4.equals("list")) {
            nArray2 = AdditiveBicluster.getListFile(stringArray[7]);
            System.out.println("Reference condition list file " + stringArray[7] + " is loaded.");
            n5 = nArray2.length;
        } else {
            System.err.println("Reference condition mode " + string4 + " is not correct!");
            System.err.println("Please use single, random or list the reference condition mode ");
            return;
        }
        System.out.println("Reference condition number: " + n5);
        Object[] objectArray = new BiclusterInfo[n4 * n6];
        Object[] objectArray2 = new BiclusterInfo[n5];
        for (n3 = 0; n3 < n4; ++n3) {
            int n7 = nArray[n3] - 1;
            longMatrix.minusRefRow(longMatrix2, n7);
            int n8 = n3 * 100 / n4;
            System.out.print("                                                                      \r");
            String string5 = AdditiveBicluster.getStr(n3 + 1, n7 + 1, n8);
            System.out.print(string5);
            for (n2 = 0; n2 < n5; ++n2) {
                int n9 = nArray2[n2] - 1;
                longMatrix2.getRefColDistance(longMatrix3, n9);
                longMatrix3.getSimilarity(longMatrix4, d, d2);
                objectArray2[n2] = longMatrix4.MSB(d3);
                ((BiclusterInfo)objectArray2[n2]).ref_gene = n7 + 1;
                ((BiclusterInfo)objectArray2[n2]).ref_col = n9 + 1;
                ((BiclusterInfo)objectArray2[n2]).extend(longMatrix4, d3);
                ((BiclusterInfo)objectArray2[n2]).convertExp();
            }
            Arrays.sort(objectArray2);
            BiclusterInfo.filter((BiclusterInfo[])objectArray2, 0.25);
            n2 = 0;
            for (n = 0; n2 < n6 && n < n5; ++n) {
                if (((BiclusterInfo)objectArray2[n]).is_filtered) continue;
                objectArray[n3 * n6 + n2] = objectArray2[n];
                ++n2;
            }
            while (n2 < n6) {
                objectArray[n3 * n6 + n2] = new BiclusterInfo();
                ((BiclusterInfo)objectArray[n3 * n6 + n2]).is_filtered = true;
                ++n2;
            }
        }
        Arrays.sort(objectArray);
        BiclusterInfo.filter((BiclusterInfo[])objectArray, 0.25);
        int n10 = 0;
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(string2));
            for (n = 0; n < n4 * n6; ++n) {
                if (((BiclusterInfo)objectArray[n]).is_filtered) continue;
                printWriter.print("No." + ++n10);
                printWriter.print(" Gene num: " + ((BiclusterInfo)objectArray[n]).bi_row + " Cond num: " + ((BiclusterInfo)objectArray[n]).bi_col);
                printWriter.print(" Ref Gene: " + ((BiclusterInfo)objectArray[n]).ref_gene + " Ref Cond: " + ((BiclusterInfo)objectArray[n]).ref_col);
                ((BiclusterInfo)objectArray[n]).avg_sim = (double)Math.round(((BiclusterInfo)objectArray[n]).avg_sim * 1000.0) / 1000.0;
                printWriter.println(" Avg Sim: " + ((BiclusterInfo)objectArray[n]).avg_sim);
                for (n3 = 0; n3 < ((BiclusterInfo)objectArray[n]).bi_row; ++n3) {
                    printWriter.print(" " + (((BiclusterInfo)objectArray[n]).row_list[n3] + 1));
                }
                printWriter.println();
                for (n2 = 0; n2 < ((BiclusterInfo)objectArray[n]).bi_col; ++n2) {
                    printWriter.print(" " + (((BiclusterInfo)objectArray[n]).col_list[n2] + 1));
                }
                printWriter.println();
            }
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        System.out.print("                                                             \r");
        System.out.println("100% finished");
        System.out.println("Biclustering results are saved in file: " + string2);
    }
}

