/**
 * An interface for a map which binds a key uniquely to a value.
 * @author Michael Goodrich
 */
//begin#fragment Map
// A simple Map interface
public interface Map {
//end#fragment Map
  /** Returns the number of items in the map. */
//begin#fragment Map
  public int size();
//end#fragment Map
  /** Returns whether the map is empty. */
//begin#fragment Map
  public boolean isEmpty();
//end#fragment Map
  /** Put a key-value pair in the map, replacing previous one if it exists. */
//begin#fragment Map
  public Object put(Object key, Object value) // assign this value to this key
    throws InvalidKeyException;
//end#fragment Map
  /** Returns the value associated with a key. */
//begin#fragment Map
  public Object get(Object key) 	      // get the value for this key
    throws InvalidKeyException;
//end#fragment Map
  /** Removes the key-value pair with a specified key. */
//begin#fragment Map
  public Object remove(Object key)	      // remove this key and its value
    throws InvalidKeyException;
//end#fragment Map
  /** Returns an iterator of all keys in the map. */
//begin#fragment Map
  //public java.util.Iterator keys();	      // an iterator of all the keys
//end#fragment Map
  /** Returns an iterator of all values in the map. */
//begin#fragment Map
  //public java.util.Iterator values();	      // an iterator of all the values
}
//end#fragment Map
