
public class HashTableExample2 {

	static int CAPACITY = 10;
	static EqualityTester tester = new HashTable.DefaultEqualityTester();
	static HashTable table = new HashTable(CAPACITY, tester);
    
	public static void showTable(){
		for(int i=0; i<CAPACITY; i++){
			Entry t = table.A[i];
			String s;
			if(t == null)
				s = "_";
			else if(t.key() == null)
				s = "available";
			else
				s = "("+t.key()+","+t.value()+")";
			System.out.print(i+":"+s+" ");
		}
		System.out.println("");
	}

	   public static void main(String[] args) {
		   /*
		    * Please modify the `hashValue()` function in `HashTable.java` to see the result.
		    */
	       
	       table.put(0,0);
	       table.put(1,1);
	       table.put(2,2);
	       showTable();
	       table.put(1+CAPACITY,11); // collide
	       table.remove(1);
	       showTable();
	       table.put(1+CAPACITY,111); // search after remove, skip available positions
	       showTable();
	       
	       table.put(1, 1); // first available
	       showTable();
	   }
}
