#!/usr/bin/env python

"""
setuprcpc.py file for pycodec
"""

from distutils.core import setup, Extension


pyrcpc_module = Extension('_pyrcpc',
                           sources=['pyrcpc_wrap.cxx', 'pyrcpc.cxx',
                                    'bitbuffer.C', 'bsc_error_stream.C',
                                    'fec.C', 'general.C', 'rcpc_code_lib.C',
                                    'rcpc.C', 'rcpc_crc.C', 'RndGen.C'],
                           )

setup (name = 'pyrcpc',
       version = '0.1',
       author      = "Tao Han",
       description = """RCPC codec code for MCN wireless testbed""",
       ext_modules = [pyrcpc_module],
       py_modules = ["pyrcpc"],
       )
