// -*- c++ -*-
// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =

//       R C P C  / C R C   C L A S S E S

// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
//
// P. Greg Sherwood            sherwood@code.ucsd.edu
// Kenneth Zeger	       zeger@code.ucsd.edu
//
// 9500 Gilman Dr MC 0407
// La Jolla, CA 92093
//
//
// Copyright (c) 1997 P. Greg Sherwood and Kenneth Zeger
//
// This program is Copyright (c) by P. Greg Sherwood and Kenneth Zeger
// It may not be redistributed without written permission of its 
// copyright holders. It may not be sold for profit or
// incorporated in commercial programs without the written permission
// of the copyright holders. This program is provided as is, without any
// express or implied warranty, without even the warranty of fitness
// for a particular purpose.
//


#ifndef __RCPC_CRC_H
#define __RCPC_CRC_H

//#include <iostream.h>
#include <iostream>
#include "rcpc.h"
#include "bitbuffer.h"

enum RcpcCRCEncodeStatus { 
  RcpcCRCEncodeSuccess = 0,
  RcpcCRCEncodeInsufficientInfoBits,
  RcpcCRCEncodeInvalidParameter
};

const int CRC_ONLY = -1;
const int NO_CODE = CRC_ONLY - 1;


// bit sizes of structure fields 
// Position 0 holds the total bits
// and the other positions follow the 
// structure below.  Be sure to keep 
// these two synchronized if any changes
// are made.
const int RcpcCRCHdrSizes[] = {32 , 16, 8, 8};

struct RcpcCRCHeader {
  int info_bits;
  int rcpc_code_spec_num;
  int rcpc_code_num;

  void dump(BitBuffer& out_buf);
  int fill(BitBuffer& out_buf);
  int get_size() {return RcpcCRCHdrSizes[0];};
};

ostream& operator << (ostream& s, const RcpcCRCHeader&);

class RcpcCRCEncoder {
public:
  RcpcCRCEncoder(int in_info_bits, int in_code_spec_num, 
		 int in_code_num);

  RcpcCRCEncoder(const RcpcCRCEncoder& );

  ~RcpcCRCEncoder();

  RcpcCRCEncodeStatus encode(BitBuffer& in_buffer, 
			     BitBuffer& out_buffer);
  void get_header(RcpcCRCHeader& hdr);
  void dump_header(BitBuffer& outbuffer);
  RcpcCRCEncoder& operator =(const RcpcCRCEncoder& src);
  int get_chan_bits();

  friend RcpcCRCEncoder* new_RcpcCRCEncoder_array(int num_elements,
						  int in_info_bits, 
						  int in_code_spec_num, 
						  int in_code_num);
  friend RcpcCRCEncoder* new_RcpcCRCEncoder_array(int num_elements,
						  const RcpcCRCEncoder&); 

protected:
  int info_bits;
  int reduced_table[8];
  int rcpc_code_spec_num;
  int rcpc_code_num;

  RCPCEncoder* rcpc_encoder;

  RcpcCRCEncoder() {}; // This is only used by the new array routines below
              // which immediately call init_values to initialize everything

  void copy_values(const RcpcCRCEncoder& src);
  void free_memory();

  void init_values(int in_info_bits, int in_code_spec_num, 
		   int in_code_num);
};

// -------------------------------------------------------------------
// *******************************************************************
// *
// *                  RcpcCRC Decoder Class
// *
// *******************************************************************


enum RcpcCRCDecodeStatus { 
  RcpcCRCDecodeSuccess = 0, 
  RcpcCRCDecodeNoCRCMatch,
  RcpcCRCDecodeInsufficientChanBits,
  RcpcCRCDecodeInsufficientInfoBits,
  RcpcCRCDecodeInvalidParameter
};

const int DefaultTrellisSearchDepth = 100;

class RcpcCRCDecoder {
public:
  RcpcCRCDecoder(int in_info_bits, int in_code_spec_num, 
		 int in_code_num);
  RcpcCRCDecoder(RcpcCRCHeader& header);
  RcpcCRCDecoder(const RcpcCRCDecoder& );

  ~RcpcCRCDecoder();

  RcpcCRCDecoder& operator =(const RcpcCRCDecoder& src);
  RcpcCRCDecodeStatus decode(BitBuffer& in_buffer, BitBuffer& out_buffer, 
			     int srch_depth = DefaultTrellisSearchDepth);

  void get_header(RcpcCRCHeader& hdr);
  int get_chan_bits() {return chan_bits;};

protected:
  int info_bits;
  int chan_bits;
  int reduced_table[8];
  int rcpc_code_spec_num;
  int rcpc_code_num;

  RCPCDecoder* rcpc_decoder;

  void free_memory();
  void copy_values(const RcpcCRCDecoder& src);
  void setup(RcpcCRCHeader& hdr);
};

inline RcpcCRCEncoder* new_RcpcCRCEncoder_array(int num_elements,
					int in_info_bits, 
					int in_code_spec_num, 
					int in_code_num)
{
  RcpcCRCEncoder* array;
  array = new RcpcCRCEncoder[num_elements];
  for (int ii=0;ii<num_elements;++ii)
    array[ii].init_values(in_info_bits, in_code_spec_num, 
			  in_code_num);
  return array;
}

inline RcpcCRCEncoder* new_RcpcCRCEncoder_array(int num_elements,
					const RcpcCRCEncoder& src)
{
  RcpcCRCEncoder* array;
  array = new RcpcCRCEncoder[num_elements];
  for (int ii=0;ii<num_elements;++ii)
    array[ii].copy_values(src);
  return array;
}


#endif
