/* File : pyrcpc.cxx */

#include <cstring>

//#include <unistd.h>
//#include <string.h>
//#include <stdlib.h>
//#include "general.h"
#include "bitbuffer.h"
#include "rcpc_crc.h"


void encode( char **s, int *slen, char *str, int len )
{
    int buflen;
    char *p;
    int n;
    
    BitBuffer chan_encoded_buf(1);
    BitBuffer EncodeBuf(1);

    RcpcCRCEncoder* rcpc_crc_encoder = new RcpcCRCEncoder( len * 8,
							4,
							0);

    int packet_size = rcpc_crc_encoder->get_chan_bits();
    
    for( n = 0; n < len; n++ )
        EncodeBuf.buffer_bits( 8, str[ n ] );

    while (rcpc_crc_encoder->encode(EncodeBuf, chan_encoded_buf ) == 
	 RcpcCRCEncodeSuccess);

    delete rcpc_crc_encoder;

    buflen = packet_size / 8;
    if( ( packet_size % 8 ) != 0 )
    {
        chan_encoded_buf.buffer_bits( 8 - ( packet_size % 8 ), 0 );
	buflen++;
    }
    p = new char[ buflen + sizeof( short ) + sizeof( int ) ];

    *( ( short * )p ) = ( short )len;
    *( ( int * )( p + sizeof( short) ) ) = packet_size;
    chan_encoded_buf.position_read_ptr( 0 );
    for( n = 0; n < buflen; n++ )
        p[ n + sizeof( short ) + sizeof( int ) ] = chan_encoded_buf.read_bits( 8 );

    *s = p;
    *slen = buflen + sizeof( short ) + sizeof( int );
}

void decode( char **s, int *slen, char *str, int len )
{
    int buflen;
    char *p;
    int n;
    int status;
    int infolen;
    int packet_size;

    BitBuffer chan_buf(1);
    BitBuffer DecodeBuf(1);
    BitBuffer AllDecodeBuf(1);

    infolen = *( ( short * )str );
    RcpcCRCDecoder* rcpc_crc_decoder = new RcpcCRCDecoder(infolen * 8,
							4, 
							0);

    //for( n = 0; n < len - sizeof( short ); n++ )
    //    chan_buf.buffer_bits( 8, str[ n + sizeof( short ) ] );
    //for( n = 0; n < len - sizeof( short ) - sizeof( int ); n++ )
    //    chan_buf.buffer_bits( 8, str[ n + sizeof( short ) + sizeof( int ) ] );
    packet_size = *( ( int * )( str + sizeof( short ) ) );
    for( n = 0; n < packet_size / 8; n++ )
        chan_buf.buffer_bits( 8, str[ n + sizeof( short ) + sizeof( int ) ] );
    if( ( packet_size % 8 ) != 0 )
    {
        chan_buf.buffer_bits( ( packet_size % 8 ), str[ n + sizeof( short ) +
            + sizeof( int ) ] >> ( 8 - ( packet_size % 8 ) ) );
    }

    while ((status = rcpc_crc_decoder->decode(chan_buf,
						DecodeBuf,
						100)) !=
	     RcpcCRCDecodeInsufficientChanBits)
    {
	AllDecodeBuf.concat(DecodeBuf);
	DecodeBuf.empty_buffer();
    }

    delete rcpc_crc_decoder;

    
    buflen = AllDecodeBuf.bytes_in_buffer();
    p = new char[ buflen ];

    AllDecodeBuf.position_read_ptr( 0 );
    for( n = 0; n < buflen; n++ )
        p[ n ] = AllDecodeBuf.read_bits( 8 );

    *s = p;
    *slen = buflen;
}
