// -*- c++ -*-
// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =

//         G E N E R A L   D E F I N I T I O N S / F U N C T I O N S

// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =

// P. Greg Sherwood            sherwood@code.ucsd.edu
// Kenneth Zeger	       zeger@code.ucsd.edu
//
// 9500 Gilman Dr MC 0407
// La Jolla, CA 92093
//
// Copyright (c) 1997 P. Greg Sherwood and Kenneth Zeger
//
// This program is Copyright (c) by P. Greg Sherwood and Kenneth Zeger
// It may not be redistributed without written permission of its 
// copyright holders. It may not be sold for profit or
// incorporated in commercial programs without the written permission
// of the copyright holders. This program is provided as is, without any
// express or implied warranty, without even the warranty of fitness
// for a particular purpose.
//



#ifndef __general_h
#define __general_h

// - - Include files - - - - - - - - - - - - - - - - - - - - - - - - - - -
#include <stdio.h>
#include <stdlib.h>


// - - Type definitions  - - - - - - - - - - - - - - - - - - - - - - - -

#define boolean int
#define true    1
#define false   0

typedef char Char_Line[80];
typedef unsigned char byte;
typedef unsigned long word;


// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =

//  Macros

// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =

#define NEW_ARRAY(ptr, no_elements, type) ptr = new type[no_elements]

#define NEW_OBJECT(ptr, type) ptr = new type

#define DELETE_ARRAY(ptr) delete [] ptr;  ptr = NULL

#define DELETE_OBJECT(ptr) delete ptr;  ptr = NULL

// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =

//  Inline functions

// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =

inline int Min(int a, int b)
  { return (a < b ? a : b); }

inline int Max(int a, int b)
  { return (a > b ? a : b); }


// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =

//  Function prototypes

// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =

char *stripdir(char *pathname);

void ErrorMsg(char *procname, char *msg, FILE *fp);

void ErrorMsg(char *progname, char *procname, char *fmt,...);

void ErrorMsgAndExit(char *progname, char *procname, char *fmt,...);

int GetVerboseLevel();

void SetVerboseLevel(int level);

void VerboseMsg(char *progname, char *procname, int verbose_flag, char *fmt, ...);


// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =

#endif

