// -*- c++ -*-
// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =

//         G E N E R A L   D E F I N I T I O N S / F U N C T I O N S

// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =

// P. Greg Sherwood            sherwood@code.ucsd.edu
// Kenneth Zeger	       zeger@code.ucsd.edu
//
// 9500 Gilman Dr MC 0407
// La Jolla, CA 92093
//
// Copyright (c) 1997 P. Greg Sherwood and Kenneth Zeger
//
// This program is Copyright (c) by P. Greg Sherwood and Kenneth Zeger
// It may not be redistributed without written permission of its 
// copyright holders. It may not be sold for profit or
// incorporated in commercial programs without the written permission
// of the copyright holders. This program is provided as is, without any
// express or implied warranty, without even the warranty of fitness
// for a particular purpose.
//

// - - Include files - - - - - - - - - - - - - - - - - - - - - - - - - - - -

#include "general.h"
#include <time.h>
#include <string.h>
#include <stdarg.h>

// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =


char *stripdir(char *pathname)
{
  char *ptr;
  
  if ((ptr = (char*)strrchr(pathname, '/')) == NULL) return pathname;
  
  return ++ptr;
  
}


// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =

//  Error-handling functions

// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =


void ErrorMsg(char *procname, char *msg, FILE *fp)
{
  fprintf(fp, "Error <%s>: %s\n", procname, msg);
  fflush(fp);
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

void ErrorMsg(char *progname, char *procname, char *fmt, ...)
{

  va_list ap;
  va_start(ap, fmt);
  fprintf(stderr, "<%s> (%s): ", progname, procname);
  vfprintf(stderr, fmt, ap);
  va_end(ap);
  fflush(stderr);

}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

void ErrorMsgAndExit(char *progname, char *procname, char *fmt, ...)
{
  va_list ap;
  va_start(ap, fmt);
  fprintf(stderr, "<%s> (%s): ", progname, procname);
  vfprintf(stderr, fmt, ap);
  va_end(ap);
  fflush(stderr);
  exit(1);
}


// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

static int verbose_level = 0;

int GetVerboseLevel()
{
  return verbose_level;
}

void SetVerboseLevel(int level)
{
  if (level >= 0)
    verbose_level = level;
}

void VerboseMsg(char *progname, char *procname, int verbose_flag, char *fmt, ...)
{

  va_list ap;
  va_start(ap, fmt);

  if (verbose_level && verbose_flag <= verbose_level)
    {
      if (progname)
	fprintf(stdout, "<%s> ", progname);
      if (procname)
	fprintf(stdout, "(%s): ", procname);
      vfprintf(stdout, fmt, ap);
    }
  va_end(ap);
  fflush(stdout);
}


// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =


