// -*- c++ -*-
// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =

//             F E C   R O U T I N E S

// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
//
// P. Greg Sherwood            sherwood@code.ucsd.edu
// Kenneth Zeger	       zeger@code.ucsd.edu
//
// 9500 Gilman Dr MC 0407
// La Jolla, CA 92093
//
//
// Copyright (c) 1997 P. Greg Sherwood and Kenneth Zeger
//
// This program is Copyright (c) by P. Greg Sherwood and Kenneth Zeger
// It may not be redistributed without written permission of its 
// copyright holders. It may not be sold for profit or
// incorporated in commercial programs without the written permission
// of the copyright holders. This program is provided as is, without any
// express or implied warranty, without even the warranty of fitness
// for a particular purpose.
//

#ifndef __FEC_H
#define __FEC_H

#include "general.h"
#include "bitbuffer.h"



int weight(unsigned int word);
int compute_crc_16(BitBuffer *input,int num_bits);
int compute_crc_12(BitBuffer *input, int num_bits);
int compute_crc_8(BitBuffer *input, int num_bits);
int compute_reduced_table(unsigned long crc_generator, int *reduced_table);
int compute_crc_16(BitBuffer *input, int num_bits, int *reduced_table);

inline int weight(unsigned int word)
{ /* return the Hamming weight of word */
  int wt;
  for (wt = 0; word; word >>= 1)
    if (word & 1) ++wt;
  return wt;
}

#endif // __FEC_H
