// -*- c++ -*-
// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =

//              B S C  E R R O R  S T R E A M

// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
//
// P. Greg Sherwood            sherwood@code.ucsd.edu
// Kenneth Zeger	       zeger@code.ucsd.edu
//
// 9500 Gilman Dr MC 0407
// La Jolla, CA 92093
//
//
// Copyright (c) 1997 P. Greg Sherwood and Kenneth Zeger
//
// This program is Copyright (c) by P. Greg Sherwood and Kenneth Zeger
// It may not be redistributed without written permission of its 
// copyright holders. It may not be sold for profit or
// incorporated in commercial programs without the written permission
// of the copyright holders. This program is provided as is, without any
// express or implied warranty, without even the warranty of fitness
// for a particular purpose.
//

#include "bsc_error_stream.h"

int bsc_error_stream(int npoints, float BER, 
		     BitBuffer& chanbuf, RndGen& rndgen)
{
  int ii;
  for (ii = 0; ii < npoints; ++ii)
    {
      // test for bit error
      if (rndgen.randnum() > BER)
	{
	  chanbuf.buffer_bit(0);
	}
      else
	{
	  chanbuf.buffer_bit(1);
	}
    }

  return ii;
}

