// -*- C++ -*-
// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =

//			 R N D G E N   C L A S S

// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =

// P. Greg Sherwood            sherwood@code.ucsd.edu
// Kenneth Zeger	       zeger@code.ucsd.edu
//
// 9500 Gilman Dr MC 0407
// La Jolla, CA 92093
//
//
// Copyright (c) 1997 P. Greg Sherwood and Kenneth Zeger
//
// This program is Copyright (c) by P. Greg Sherwood and Kenneth Zeger
// It may not be redistributed without written permission of its 
// copyright holders. It may not be sold for profit or
// incorporated in commercial programs without the written permission
// of the copyright holders. This program is provided as is, without any
// express or implied warranty, without even the warranty of fitness
// for a particular purpose.
//

#ifndef _RndGen_h
#define _RndGen_h

#include "bitbuffer.h"

struct SeedType {
  unsigned short values[3];

  friend ostream&    operator << (ostream& s,const SeedType&);
  friend void buffer_seed(SeedType& seed, BitBuffer& buffer);
  friend int read_seed(SeedType& seed, BitBuffer& buffer);
};

class RndGen {
protected:
  SeedType seed;
  SeedType init_seed;
  void initialize_seed(SeedType& seed);


public:
  RndGen();
  RndGen(SeedType& in_seed);
  void set_seed(SeedType& in_seed);
  SeedType get_init_seed() { return init_seed;};
  double randnum();

};
#endif
