// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =

//			 R N D G E N   C L A S S

// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =

// P. Greg Sherwood            sherwood@code.ucsd.edu
// Kenneth Zeger	       zeger@code.ucsd.edu
//
// 9500 Gilman Dr MC 0407
// La Jolla, CA 92093
//
//
// Copyright (c) 1997 P. Greg Sherwood and Kenneth Zeger
//
// This program is Copyright (c) by P. Greg Sherwood and Kenneth Zeger
// It may not be redistributed without written permission of its 
// copyright holders. It may not be sold for profit or
// incorporated in commercial programs without the written permission
// of the copyright holders. This program is provided as is, without any
// express or implied warranty, without even the warranty of fitness
// for a particular purpose.
//

#include <sys/time.h>
#include <unistd.h>
#include <stdlib.h>
#include "RndGen.h"

// Constructor
RndGen::RndGen()
{
  initialize_seed(seed);
  init_seed = seed;
}

// Constructor
RndGen::RndGen(SeedType& in_seed)
{
  init_seed = seed = in_seed;
}


void RndGen::initialize_seed(SeedType& seed)
{
  struct timeval tv;

  gettimeofday(&tv, NULL);
  

  /* copy info from time struct */
  seed.values[0] = (tv.tv_sec & 0xFFFF);
  seed.values[1] = (tv.tv_usec >> 16) & 0xFFFF;
  seed.values[2] = (tv.tv_usec) & 0xFFFF;

}

void RndGen::set_seed(SeedType& in_seed)
{
  init_seed = seed = in_seed;
}

double RndGen::randnum()
{
  return erand48(seed.values);
}

ostream&    operator << (ostream& s, const SeedType& seed)
{
  s.setf(ios::showbase);
  s << hex;
  for (int ii = 0; ii < 2; ++ii)
    s << seed.values[ii] << ", ";
  s << seed.values[2] << endl;
  s << dec;
  return s;
}
      
void buffer_seed(SeedType& seed, BitBuffer& buffer)
{
  int elem_size = (sizeof(seed.values[0]) << 3); // size in bits
  int num_elems = sizeof(seed.values)/sizeof(seed.values[0]);

  for (int ii = 0; ii < num_elems; ++ii)
    {
      buffer.buffer_bits(elem_size, seed.values[ii]);
    }

}

int read_seed(SeedType& seed, BitBuffer& buffer)
{
  int elem_size = (sizeof(seed.values[0]) << 3); // size in bits
  int num_elems = sizeof(seed.values)/sizeof(seed.values[0]);
  int tmp;

  for (int ii = 0; ii < num_elems; ++ii)
    {
      if (buffer.read_bits(elem_size, tmp, false) != elem_size)
	return -1;
      else
	seed.values[ii] = tmp;
    }

  return (num_elems*elem_size);
}



