#!/usr/bin/env python
#
# Copyright 2005, 2006, 2007 Free Software Foundation, Inc.
# 
# This file is part of GNU Radio
# 
# GNU Radio is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3, or (at your option)
# any later version.
# 
# GNU Radio is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with GNU Radio; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 51 Franklin Street,
# Boston, MA 02110-1301, USA.
#

# Ver 1.0, Feb 6, 2009, Qin Chen
# UDP socket server receives packets from FFmpeg
# Packets are then transmitted via GNU Radio

# Ver 1.1, Feb 9, 2009, Qin Chen
# Add command line option to specify socket port and
# socket receiver buffer size

# Ver 1.2, Feb 16, 2009, Qin Chen
# Add no packet handing in loop
# Remove the discontinous option
# Add packet split scheme when packet is too big 

from gnuradio import gr, gru, modulation_utils
from gnuradio import usrp
from gnuradio import eng_notation
from gnuradio.eng_option import eng_option
from optparse import OptionParser

import random, time, struct, sys

# from current dir
from transmit_path import transmit_path
import fusb_options

# Qin 020609
import socket
#i mport pdb

#import os 
#print os.getpid()
#raw_input('Attach and press enter')

class my_top_block(gr.top_block):
    def __init__(self, modulator, options):
        gr.top_block.__init__(self)
        self.txpath = transmit_path(modulator, options)
        self.connect(self.txpath)

# /////////////////////////////////////////////////////////////////////////////
#                                   main
# /////////////////////////////////////////////////////////////////////////////

def main():

    def send_pkt(payload='', eof=False):
        return tb.txpath.send_pkt(payload, eof)

    def rx_callback(ok, payload):
        print "ok = %r, payload = '%s'" % (ok, payload)

    mods = modulation_utils.type_1_mods()

    parser = OptionParser(option_class=eng_option, conflict_handler="resolve")
    expert_grp = parser.add_option_group("Expert")

    parser.add_option("-m", "--modulation", type="choice", choices=mods.keys(),
                      default='gmsk',
                      help="Select modulation from: %s [default=%%default]"
                            % (', '.join(mods.keys()),))

    parser.add_option("-s", "--size", type="eng_float", default=1500,
                      help="set packet size [default=%default]")
    parser.add_option("-M", "--megabytes", type="eng_float", default=1.0,
                      help="set megabytes to transmit [default=%default]")
    # Qin 021609
    # parser.add_option("","--discontinuous", action="store_true", default=False,
    #                  help="enable discontinous transmission (bursts of 5 packets)")
    parser.add_option("","--from-file", default=None,
                      help="use file for packet contents")

    # Qin 020909
    parser.add_option("-p", "--port", type="intx", default=12345,
                      help="set UDP socket port number [default=%default]")
    parser.add_option("-b", "--bufferbytes", type="intx", default=20480,
                      help="set UDP socket receiver buffer size [default=%default]")     

    transmit_path.add_options(parser, expert_grp)

    for mod in mods.values():
        mod.add_options(expert_grp)

    fusb_options.add_options(expert_grp)
    (options, args) = parser.parse_args ()

    if len(args) != 0:
        parser.print_help()
        sys.exit(1)

    if options.tx_freq is None:
        sys.stderr.write("You must specify -f FREQ or --freq FREQ\n")
        parser.print_help(sys.stderr)
        sys.exit(1)

    if options.from_file is not None:
        source_file = open(options.from_file, 'r')

    # build the graph
    tb = my_top_block(mods[options.modulation], options)

    r = gr.enable_realtime_scheduling()
    if r != gr.RT_OK:
        print "Warning: failed to enable realtime scheduling"

    tb.start()                       # start flow graph
        
    # generate and send packets
    nbytes = int(1e6 * options.megabytes)
    n = 0
    pktno = 0
    pkt_size = int(options.size)
    max_pkt_size = 3072

    # Qin 020609
    # create a socket
    s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    host = '' # can leave this blank on the server side
    # print options.port
    # print options.bufferbytes
    try:
        s.bind((host, options.port))
    except socket.error, err:
        print "Could not set up a UDP server on port %d: %s" % (options.port, err)
        raise SystemExit

    while True:
        # pdb.set_trace()
        # try:
        data = s.recv(options.bufferbytes)
        # add error handling here 021609
        # except (KeyboardInterrupt, SystemExit):
        #    raise
        if not data:
            break

        # Qin 021609
        while (len(data) > max_pkt_size): # (maximum allower packet size: 4096)
            partial_pl = data[0:max_pkt_size]   # extract 3072 bytes
            # print "partial_pl 1 length = %4d" % (len(partial_pl))
            partial_pl = struct.pack('!H', 0x5555) + partial_pl
            # print "partial_pl 2 length = %4d" % (len(partial_pl))
            payload = struct.pack('!H', pktno & 0xffff) + partial_pl
            # print "partial_pl 3 length = %4d" % (len(payload))
            send_pkt(payload)
            n += len(payload)
            pktno += 1
            sys.stderr.write('*')   # "*" to denote split packet

            data = data[max_pkt_size:]  # update "data"

        data = struct.pack('!H', 0xaaaa) + data    
        payload = struct.pack('!H', pktno & 0xffff) + data
        send_pkt(payload)
        n += len(payload)
        sys.stderr.write('.')
        # if options.discontinuous and pktno % 5 == 4:
        # time.sleep(0.001) # Qin 021609
        pktno += 1
        
    send_pkt(eof=True)

    # close the socket
    s.close()

    tb.wait()                       # wait for it to finish

if __name__ == '__main__':
    try:
        main()
    except KeyboardInterrupt:
        pass
