#!/usr/bin/env python
#
# Copyright 2005, 2006 Free Software Foundation, Inc.
# 
# This file is part of GNU Radio
# 
# GNU Radio is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# GNU Radio is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with GNU Radio; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 51 Franklin Street,
# Boston, MA 02110-1301, USA.
# 

from gnuradio import gr, gru, modulation_utils
from gnuradio import usrp
from gnuradio import eng_notation
from gnuradio.eng_option import eng_option
from optparse import OptionParser

import random, time, struct, sys

sys.path.append('../python/digital')

from transmit_path import transmit_path
import fusb_options

#import os 
#print os.getpid()
#raw_input('Attach and press enter')


class my_graph(gr.flow_graph):
    def __init__(self, modulator_class, options):
        gr.flow_graph.__init__(self)
        self.txpath = transmit_path(self, modulator_class, options)


# /////////////////////////////////////////////////////////////////////////////
#                                   main
# /////////////////////////////////////////////////////////////////////////////

def main():

    def send_pkt(payload='', eof=False):
        return fg.txpath.send_pkt(payload, eof)

    def rx_callback(ok, payload):
        print "ok = %r, payload = '%s'" % (ok, payload)

    mods = modulation_utils.type_1_mods()

    parser = OptionParser(option_class=eng_option, conflict_handler="resolve")
    expert_grp = parser.add_option_group("Expert")

    parser.add_option("-m", "--modulation", type="choice", choices=mods.keys(),
                      default='gmsk',
                      help="Select modulation from: %s [default=%%default]"
                            % (', '.join(mods.keys()),))

    parser.add_option("-s", "--size", type="eng_float", default=1500,
                      help="set packet size [default=%default]")
    parser.add_option("-M", "--megabytes", type="eng_float", default=1.0,
                      help="set megabytes to transmit [default=%default]")
    parser.add_option("","--discontinuous", action="store_true", default=False,
                      help="enable discontinous transmission (bursts of 5 packets)")
    parser.add_option("","--from-file", default=None,
                      help="use file for packet contents")

    transmit_path.add_options(parser, expert_grp)

    for mod in mods.values():
        mod.add_options(expert_grp)

    fusb_options.add_options(expert_grp)
    (options, args) = parser.parse_args ()

    if len(args) != 0:
        parser.print_help()
        sys.exit(1)

    if options.tx_freq is None:
        sys.stderr.write("You must specify -f FREQ or --freq FREQ\n")
        parser.print_help(sys.stderr)
        sys.exit(1)

    #if options.from_file is not None:
    if True:
        source_file = open('./test.264', 'r')
        #print 'zhifeng: from file'
        #print 'source_file = ', source_file
        file_data = source_file.read()
        file_length = len(file_data)
        #print "file length is", file_length
        #print file_data
        #raw_input('zhifeng on 070928: press any key to continue') 
        source_file.close()
        
        source_file = open('./test.264', 'r')
        #file_data = source_file.read(100)
        #print file_data
        #raw_input('zhifeng on 070928: press any key to continue') 

    # build the graph
    fg = my_graph(mods[options.modulation], options)

    r = gr.enable_realtime_scheduling()
    if r != gr.RT_OK:
        print "Warning: failed to enable realtime scheduling"
    #print dir(object)
    #print dir(fg)
    #raw_input('zhifeng')
    
    fg.start()                       # start flow graph

    # generate and send packets
    #if options.from_file is None:
    #	nbytes = int(1e6 * options.megabytes)
    #else:
    #	nbytes = file_length
    nbytes = file_length
    	
    n = 0
    pktno = 0
    pkt_size = [22, 2089, 254, 329, 367, 446, 409, 446, 418, 449, 423, 439, 432, 459, 432, 442, 501, 465, 495, 506, 456, 496, 503, 547, 521, 476, 440, 462, 559, 503, 482, 2424, 367, 540, 476, 517, 501, 561, 542, 588, 537, 675, 592, 577, 617, 586, 508, 699, 751, 550, 544, 563, 570, 678, 704, 636, 500, 619, 749, 667, 644, 2609, 439, 667, 724, 739, 711, 614, 602, 571, 557, 518, 598, 560, 909, 1156, 566, 801, 669, 699, 728, 577, 658, 564, 684, 753, 551, 718, 792, 538, 698, 2957, 511, 687, 714, 717, 603, 736, 720, 608, 624]
    
    #add by Zhifeng on 070928 for send the file length
    """
    if options.from_file is not None:
    	reserved1 = (8 - len(repr(nbytes)))*'0'  #max file is 10^8 bytes
    	reserved2 = (pkt_size - 2 - 8)*'0'
    	#print reserved
    	data = reserved1 + repr(nbytes) + reserved2
    	print 'data, len(data)= ', data, len(data)
    	payload = struct.pack('!H', pktno) + data
    	send_pkt(payload)
    	pktno += 1
    """
    while True:
        #if options.from_file is None:
        #    data = (pkt_size - 2) * chr(pktno & 0xff)

            #print 'zhifeng: ', 'data = ',data
            #raw_input('press any key to continue')

 
        #else:
            
        data = source_file.read(pkt_size[pktno])
        if data == '':
            break;

        payload = struct.pack('!H', pktno) + data
        
        #print 'zhifeng: ', 'struct.pack(\'!H\', pktno) = ',help(struct.pack)
        #raw_input('press any key to continue')
        
        send_pkt(payload)
        n += len(payload)
        
        #print 'zhifeng: ', n
        
        sys.stderr.write('.')

        if options.discontinuous and pktno % 5 == 4:
            time.sleep(1)
        pktno += 1

        if pktno == len(pkt_size): 
            #break;
        #if data == '':
            print 'sent one file'
            source_file.close()
            source_file = open('./test.264', 'r')
            pktno = 0
            #pktno = 30
            print 'begin retransmission'
            #data = source_file.read(pkt_size[pktno])
            #break;
            raw_input('zhifeng on 070705: press any key to continue')
    print 'zhifeng: pktno = ', pktno, 'n = ', n
    #zhifeng on 070705: must add below 'raw_input' to delay eof!!! otherwise, Thread fg may have not take out all the messages in the quequ!
    raw_input('zhifeng on 070705: press any key to continue')       
    send_pkt(eof=True)
    fg.wait()                       # wait for it to finish

if __name__ == '__main__':
    try:
        main()
    except KeyboardInterrupt:
        pass
