#!/usr/bin/env python
#
# Copyright 2005,2006 Free Software Foundation, Inc.
# 
# This file is part of GNU Radio
# 
# GNU Radio is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# GNU Radio is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with GNU Radio; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 51 Franklin Street,
# Boston, MA 02110-1301, USA.
# 

from gnuradio import gr, gru, modulation_utils
from gnuradio import usrp
from gnuradio import eng_notation
from gnuradio.eng_option import eng_option
from optparse import OptionParser

import random
import struct
import sys

sys.path.append('../python/digital')

from receive_path import receive_path
import fusb_options

#import os
#print os.getpid()
#raw_input('Attach and press enter: ')


class my_graph(gr.flow_graph):

    def __init__(self, demod_class, rx_callback, options):
        gr.flow_graph.__init__(self)
        self.rxpath = receive_path(self, demod_class, rx_callback, options)

def display(ok, pktno, n_rcvd, n_right):
    print "ok = %5s  pktno = %4d  n_rcvd = %4d  n_right = %4d" % (
        ok, pktno, n_rcvd, n_right)
    
def save_file(pktno, payload):
    global n, file_length, received_file
    if pktno == 0:
        file_length = payload[2:10]
        print "file length is", file_length
        received_file = open ('/home/james/Desktop/output', 'w')

        #print n, int(file_length)
        #raw_input('zhifeng')
    else:
        if n < int(file_length):
            print 'receiving file'
            data = payload[2:]
            n += len(data)
            #print data, n
            if data == '':
                print "stop receiving file"
                #break
            else:
                #print data
                received_file.write(data)
               
            if n == int(file_length):
                received_file.close()
                print 'finish receiving file'

# /////////////////////////////////////////////////////////////////////////////
#                                   main
# /////////////////////////////////////////////////////////////////////////////

global n_rcvd, n_right

def main():
    global n_rcvd, n_right

    n_rcvd = 0
    n_right = 0
    
    global receive_mode
    #receive_mode = raw_input('please choose receive mode: 0 = display, 1 = save file, 2 = UDP transmission ') 
    receive_mode = '2'
    if receive_mode == '0':
        print 'receive_mode is display'
    elif receive_mode == '1':
        print 'receive_mode is save file'
        global n, file_length, received_file
        n = 0
        file_length = 0

    elif receive_mode == '2':
        print 'receive_mode is UDP transmission'
        import socket
	HostIP = raw_input('please input server IP address: ')
	HOST = HostIP    # The remote host
	HostPort = raw_input('please input server port (default is 50007): ')
    	if HostPort == '':
    	    PORT = 50007
        else:
    	    PORT = int(HostPort)
	#HOST = '10.227.80.224'
	#PORT = 50007              # The same port as used by the server
	s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
	s.connect((HOST, PORT))
	print 'Connected to', s.getpeername()
        
    else:
        print('please choose the right mode')
    
    def rx_callback(ok, payload):

        global n_rcvd, n_right
        global receive_mode
        (pktno,) = struct.unpack('!H', payload[0:2])
        #print payload[2:]
        #raw_input('wait')
        n_rcvd += 1
        if ok:
            n_right += 1

        if receive_mode == '0':
            display(ok, pktno, n_rcvd, n_right)
        
        elif receive_mode == '1':
            display(ok, pktno, n_rcvd, n_right)
            save_file(pktno, payload)

        elif receive_mode == '2':
       	    display(ok, pktno, n_rcvd, n_right)
            #add by Zhifeng on 080319
            if ok:
            	sent=s.send(payload[2:])
            	print 'transmitted', sent, 'bytes'
            #if pktno == 0:
            #	print repr(payload[2:])
           
        
        #add by Zhifeng on 070928
        #print payload[2:]


    demods = modulation_utils.type_1_demods()

    # Create Options Parser:
    parser = OptionParser (option_class=eng_option, conflict_handler="resolve")
    expert_grp = parser.add_option_group("Expert")

    parser.add_option("-m", "--modulation", type="choice", choices=demods.keys(), 
                      default='gmsk',
                      help="Select modulation from: %s [default=%%default]"
                            % (', '.join(demods.keys()),))

    receive_path.add_options(parser, expert_grp)

    for mod in demods.values():
        mod.add_options(expert_grp)

    fusb_options.add_options(expert_grp)
    (options, args) = parser.parse_args ()
    
    if len(args) != 0:
        parser.print_help(sys.stderr)
        sys.exit(1)

    if options.rx_freq is None:
        sys.stderr.write("You must specify -f FREQ or --freq FREQ\n")
        parser.print_help(sys.stderr)
        sys.exit(1)

    #raw_input('zhifeng')

    # build the graph
    fg = my_graph(demods[options.modulation], rx_callback, options)

    r = gr.enable_realtime_scheduling()
    if r != gr.RT_OK:
        print "Warning: Failed to enable realtime scheduling."
    	#raw_input('zhifeng')

    #raw_input('zhifeng')

    fg.start()        # start flow graph
    #raw_input('zhifeng: benchmark_rx.py')
    fg.wait()         # wait for it to finish
    #raw_input('zhifeng')

if __name__ == '__main__':
    try:
        main()
    except KeyboardInterrupt:
        pass
