function output = playdemo()
disp('you need to specify the modulation type, channel type, estimation mode, and training mode');
disp('for fequency selective fading channel, you also need to specify the equalization algorithm');
disp('If you like to see the constellation, you need to specify which SNR for drawing');
input('press enter to play it :-)')

VarChan = 'AWGN';
eq_alg = 'LMS';
ResetBeforeFiltering = 0;
training_mode = 'training_only';        %decision_directed or training_only
plot_const = 1;
ebn0_for_plot = 5;      %default use 6th dB in the [0:Max_dB]
Test_image = 1;
Image_name = 'photo.bmp';
velocity = 20;
gray_encode = 1;

disp('at present, modulation type only support psk modulation');
gray_encode = input('would you like to use gray encode? 0: No; 1: Yes (default is Yes) : ')
if isequal(gray_encode,[])
    gray_encode = 1;
end

VarChan = input('please choose channel type, 0: AWGN; 1: flat; 2: FSF  ');
switch VarChan
    case 0,
        VarChan = 'AWGN'
    case 1,
        VarChan = 'flat'
        disp('you are now in a train with 20km/hr-120km/hr in Suburban environement :-|');
        velocity = input('please set the velocity, range(20~120km/hr), (default is: 20km/hr) : ');
        if isequal(velocity,[])
            velocity = 20;
        end
    case 2,
        VarChan = 'FSF'
        disp('you are now walking with 5km/hr in urban environement :-)');
        eq_alg = input('please choose equalization algorithm, 0: LMS; 1: RLS  ');
        switch eq_alg
            case 0,
                eq_alg = 'LMS'
            case 1,
                eq_alg = 'RLS'
            otherwise,
        end
        
        disp('please choose channel estimation mode:');
        ResetBeforeFiltering = input('0: without reset result from last coherent time; 1: reset result from last coherent time  ')
        training_mode = input('please choose training mode, 0: training only mode; 1: decision directed mode    ');
        switch training_mode
            case 0,
                training_mode = 'training_only'
            case 1,
                training_mode = 'decision_directed'
            otherwise,
        end

    otherwise,
end
%if isequal(VarChan, 'AWGN')==0
%plot_const = 1;
disp('please specify which dB for plot');
disp('[0:3:3*10] for flat fading');
disp('[0:5:5*10] for frequency selective fading');

ebn0_for_plot = input('range from 0 to 10, (default is 5) :  ')
if isequal(ebn0_for_plot,[])
    ebn0_for_plot = 5;
end
%end


Test_image = input('would you like to transmit a image file over this channel? 1: yes, 0: no ')
if Test_image
    disp('please specify a image file name here including path, the file size should not exceed 400KB');
    disp('if it is in the same directory, just input filename, (default is: photo.bmp) : ');
    Image_name = input('filename: ','s')
    if isequal(Image_name,[])
        Image_name = 'photo.bmp';
    end
end

output.gray_encode = gray_encode;
output.VarChan = VarChan;
output.eq_alg = eq_alg;
output.ResetBeforeFiltering = ResetBeforeFiltering;
output.training_mode = training_mode;
output.plot_const = plot_const;
output.ebn0_for_plot = ebn0_for_plot;
output.Test_image = Test_image;
output.Image_name = Image_name;
output.velocity = velocity;


