%current only support YUV 4:2:0
function [countY, count_U, count_V] = color_to_gray(Filename_in, row, col, frame_number, format)
%we may use format to instead of bytes_per_pixel

Filename_Y = [Filename_in(1:length(Filename_in)-4), '_Y.dat'];
Filename_U = [Filename_in(1:length(Filename_in)-4), '_U.dat'];
Filename_V = [Filename_in(1:length(Filename_in)-4), '_V.dat'];

count_Y = 0;
count_U = 0;
count_V = 0;

switch format
    case '4:2:0'
        bytes_per_pixel = 1.5;
        bytes_per_frame_U = 0.25 * row * col;
        bytes_per_frame_V = 0.25 * row * col;
        
    otherwise
        disp('unknown format');
end

f_in = fopen(Filename_in, 'r');
f_Y = fopen(Filename_Y, 'w');
f_U = fopen(Filename_U, 'w');
f_V = fopen(Filename_V, 'w');

total_bytes = bytes_per_pixel * row * col * frame_number;
if (round(total_bytes)~=total_bytes)
    disp('total bytes are not integer');
end


for frame_no = 0 : frame_number - 1
    fseek(f_in, bytes_per_pixel * row * col * frame_no, 'bof');
    buf_in = fread(f_in, bytes_per_pixel * row * col, 'uint8');

    buf_Y = buf_in(1 : row * col);
    buf_U = buf_in(row*col+1 : row*col + bytes_per_frame_U);
    buf_V = buf_in(row*col + bytes_per_frame_U + 1 : row*col + bytes_per_frame_U + bytes_per_frame_V);
    count_Y = count_Y + fwrite(f_Y, buf_Y, 'uint8');
    count_U = count_U + fwrite(f_U, buf_U, 'uint8');
    count_V = count_V + fwrite(f_V, buf_V, 'uint8');
end

fclose(f_in);
fclose(f_Y);
fclose(f_U);
fclose(f_V);