%--------------------------------------------------------------------------
%this function is used to writeY, U, V components into a YUV file
%
%Chen Zhifeng
%UFID 12181197
%2008-07-17
%zhifeng@ecel.ufl.edu
%--------------------------------------------------------------------------
function write_one_frame(img_reconstructed, f_ID, para_image)

global block_size; %the minimum block for one motion vector

image_width = para_image.width;
image_height = para_image.height;
subsampling = para_image.subsampling;

switch subsampling
    case '4:2:0'
        step_UV = 2;
        image_widthUV = image_width / step_UV;
        image_heightUV = image_height / step_UV;
    otherwise
        output_message('Warning: unknown subsampling format');
end

buf_Y = reshape(img_reconstructed(:,:,1), image_width * image_height, 1);
buf_Y = check_pixel_value(buf_Y);
count_Y = fwrite(f_ID, buf_Y, 'uint8');

buf_U = reshape(img_reconstructed(1:step_UV:image_width, 1:step_UV:image_height, 2), image_widthUV * image_heightUV, 1);
buf_U = check_pixel_value(buf_U);
count_U = fwrite(f_ID, buf_U, 'uint8');

buf_V = reshape(img_reconstructed(1:step_UV:image_width, 1:step_UV:image_height, 3), image_widthUV * image_heightUV, 1);
buf_V = check_pixel_value(buf_V);
count_V = fwrite(f_ID, buf_V, 'uint8');

function ret = check_pixel_value( pixel )
if (min(pixel)<0 | max(pixel)>255)
   output_message('Warning: some pixel values are smaller than 0 or larger than 255!');
   pixel = min(max(pixel, 0), 255);
end
ret = uint8(pixel);