%--------------------------------------------------------------------------
%this function is to get all image related parameters
%We can deal with many interest things in this function. There are three
%kinds of error: residue error, concealment error, and both error, and each
%of them have three components: Y, U, V. So, there are 9 items. Each of
%those 9 items have many parameters could be evaluated, include: mean, MSE,
%pdf / hist. There are also correlation coeffienct between each of two parameters. 
%So, there are many parameters for each frame. We may plot each
%of these parameters under one video sequence. Then we can test several video
%sequences to get many very interesting results!
%For a statistical viewpoint, we need to test all of them about 1000 times.
%
%Chen Zhifeng
%UFID 12181197
%2008-07-17
%zhifeng@ecel.ufl.edu
%--------------------------------------------------------------------------
function statistic = statistic_P(data, para_image, statistic_last)
%use structure to represent all the parameters since there are many
%parameters and more parameters may be added later

%Note that it is important to keep the memory as small as possible since
%all frames information are kept here

global block_size; %the minimum block for one motion vector

MV = data.MV;
residue = data.residue;
residue_clip = data.residue_clip;
img_predicted = data.img_predicted;
img_reconstructed = data.img_reconstructed;
concealment_error = data.concealment_error;
concealment_error_clip = data.concealment_error_clip;
both_error = data.both_error;

image_width = para_image.width;
image_height = para_image.height;

pixel_per_frame = image_width * image_height;
block_per_frame = image_width / block_size * image_height / block_size;
up_sampling = ones(block_size, block_size);

%motion vector
statistic.MV.whole_frame.x = reshape(MV(1, :, :), block_per_frame, 1);
statistic.MV.whole_frame.x_mean = mean(statistic.MV.whole_frame.x);
statistic.MV.whole_frame.x_var = var(statistic.MV.whole_frame.x);
statistic.MV.whole_frame.y = reshape(MV(2, :, :), block_per_frame, 1);
statistic.MV.whole_frame.y_mean = mean(statistic.MV.whole_frame.y);
statistic.MV.whole_frame.y_var = var(statistic.MV.whole_frame.y);

statistic.MV.whole_frame.length = (statistic.MV.whole_frame.x.^2 + statistic.MV.whole_frame.y.^2).^0.5;
statistic.MV.whole_frame.rho_x_y  = get_two_whole_frame_rho(statistic.MV.whole_frame.x, statistic.MV.whole_frame.y);
%need to plot the correlation coefficient for residue data and motion
%vector
MV_length_per_pixel = reshape(kron(statistic.MV.whole_frame.length, up_sampling), pixel_per_frame, 1);

statistic.Y.whole_frame.residue = reshape(residue(:,:,1), pixel_per_frame, 1);
statistic.Y.whole_frame.residue_mean = mean(statistic.Y.whole_frame.residue);
statistic.Y.whole_frame.residue_MSE = sum(statistic.Y.whole_frame.residue.^2)/pixel_per_frame;
statistic.Y.whole_frame.rho_MV_resi = get_two_whole_frame_rho(MV_length_per_pixel, abs(statistic.Y.whole_frame.residue));
statistic.Y.whole_frame.residue_clip = reshape(residue_clip(:,:,1), pixel_per_frame, 1);
statistic.Y.whole_frame.residue_clip_mean = mean(statistic.Y.whole_frame.residue_clip);
statistic.Y.whole_frame.residue_clip_MSE = sum(statistic.Y.whole_frame.residue_clip.^2)/pixel_per_frame;

statistic.Y.whole_frame.concealment_error = reshape(concealment_error(:,:,1), pixel_per_frame, 1);
statistic.Y.whole_frame.concealment_error_mean = mean(statistic.Y.whole_frame.concealment_error);
statistic.Y.whole_frame.concealment_error_MSE = sum(statistic.Y.whole_frame.concealment_error.^2)/pixel_per_frame;
statistic.Y.whole_frame.rho_MV_conc = get_two_whole_frame_rho(MV_length_per_pixel, abs(statistic.Y.whole_frame.concealment_error));
statistic.Y.whole_frame.concealment_error_clip = reshape(concealment_error_clip(:,:,1), pixel_per_frame, 1);
statistic.Y.whole_frame.concealment_error_clip_mean = mean(statistic.Y.whole_frame.concealment_error_clip);
statistic.Y.whole_frame.concealment_error_clip_MSE = sum(statistic.Y.whole_frame.concealment_error_clip.^2)/pixel_per_frame;

statistic.Y.whole_frame.predicted = reshape(img_predicted(:,:,1), pixel_per_frame, 1);
statistic.Y.whole_frame.predicted_mean = mean(statistic.Y.whole_frame.predicted);
statistic.Y.whole_frame.predicted_var = var(statistic.Y.whole_frame.predicted);

statistic.Y.whole_frame.reconstructed = reshape(img_reconstructed(:,:,1), pixel_per_frame, 1);
statistic.Y.whole_frame.reconstructed_mean = mean(statistic.Y.whole_frame.reconstructed);
statistic.Y.whole_frame.reconstructed_var = var(statistic.Y.whole_frame.reconstructed);

statistic.Y.whole_frame.both_error = reshape(both_error(:,:,1), pixel_per_frame, 1);
statistic.Y.whole_frame.both_error_mean = mean(statistic.Y.whole_frame.both_error);
statistic.Y.whole_frame.both_error_MSE = sum(statistic.Y.whole_frame.both_error.^2)/pixel_per_frame;

if statistic_last.Y.whole_frame.residue_clip_MSE == 0
    statistic.Y.whole_frame.prop_clip_resi = zeros(image_width * image_height, 1);
    statistic.Y.whole_frame.prop_clip_resi_mean = 0;
    statistic.Y.whole_frame.prop_clip_resi_MSE = 0;
    statistic.Y.whole_frame.prop_clip_resi_factor = 0;
else
    statistic.Y.whole_frame.prop_clip_resi = statistic.Y.whole_frame.reconstructed - clip_vector(reference_align(statistic_last.Y.whole_frame.predicted, MV, image_width, image_height) + statistic.Y.whole_frame.residue, 'prop_clip_resi');
    statistic.Y.whole_frame.prop_clip_resi_mean = mean(statistic.Y.whole_frame.prop_clip_resi);
    statistic.Y.whole_frame.prop_clip_resi_MSE = sum(statistic.Y.whole_frame.prop_clip_resi.^2)/pixel_per_frame;
    statistic.Y.whole_frame.prop_clip_resi_factor = statistic.Y.whole_frame.prop_clip_resi_MSE / statistic_last.Y.whole_frame.residue_clip_MSE;
end


if statistic_last.Y.whole_frame.concealment_error_clip_MSE == 0
    statistic.Y.whole_frame.prop_clip_conc = zeros(image_width * image_height, 1);
    statistic.Y.whole_frame.prop_clip_conc_mean = 0;
    statistic.Y.whole_frame.prop_clip_conc_MSE = 0;
    statistic.Y.whole_frame.prop_clip_conc_factor = 0;
else
    statistic.Y.whole_frame.prop_clip_conc = statistic.Y.whole_frame.reconstructed - clip_vector(reference_align(statistic_last.Y.whole_frame.reconstructed - statistic_last.Y.whole_frame.concealment_error_clip, MV, image_width, image_height) + statistic.Y.whole_frame.residue, 'prop_clip_conc');
    statistic.Y.whole_frame.prop_clip_conc_mean = mean(statistic.Y.whole_frame.prop_clip_conc);
    statistic.Y.whole_frame.prop_clip_conc_MSE = sum(statistic.Y.whole_frame.prop_clip_conc.^2)/pixel_per_frame;
    statistic.Y.whole_frame.prop_clip_conc_factor = statistic.Y.whole_frame.prop_clip_conc_MSE / statistic_last.Y.whole_frame.concealment_error_clip_MSE;
end


if statistic_last.Y.whole_frame.both_error_MSE == 0
    statistic.Y.whole_frame.prop_clip_both = zeros(image_width * image_height, 1);
    statistic.Y.whole_frame.prop_clip_both_mean = 0;
    statistic.Y.whole_frame.prop_clip_both_MSE = 0;
    statistic.Y.whole_frame.prop_clip_both_factor = 0;
else
    statistic.Y.whole_frame.prop_clip_both = statistic.Y.whole_frame.reconstructed - clip_vector(reference_align(statistic_last.Y.whole_frame.reconstructed - statistic_last.Y.whole_frame.both_error, MV, image_width, image_height) + statistic.Y.whole_frame.residue, 'prop_clip_both');
    statistic.Y.whole_frame.prop_clip_both_mean = mean(statistic.Y.whole_frame.prop_clip_both);
    statistic.Y.whole_frame.prop_clip_both_MSE = sum(statistic.Y.whole_frame.prop_clip_both.^2)/pixel_per_frame;
    statistic.Y.whole_frame.prop_clip_both_factor = statistic.Y.whole_frame.prop_clip_both_MSE / statistic_last.Y.whole_frame.both_error_MSE;
end

% statistic.Y.whole_frame.delta_Nr_Nm_Nq = statistic.Y.whole_frame.residue - statistic.Y.whole_frame.residue_clip;  %$\hat{\Delta}^{k}_{\mathbf{u}}$
% statistic.Y.whole_frame.delta_Nr_m_Nq = statistic.Y.whole_frame.concealment_error_clip - statistic.Y.whole_frame.concealment_error;  %$\tilde{\Delta}^{k}_{\mathbf{u}}\{\bar{r},m,\bar{p}\}$
% statistic.Y.whole_frame.delta_Nr_Nm_qResi = statistic.Y.whole_frame.prop_clip_resi - reference_align(statistic_last.Y.whole_frame.residue_clip, MV, image_width, image_height);  %$\tilde{\Delta}^{k}_{\mathbf{u}}\{\bar{r},\bar{m},p\}$ where p means only last frame have residual error
% statistic.Y.whole_frame.delta_Nr_m_qResi = (statistic_last.Y.whole_frame.predicted + statistic.Y.whole_frame.residue) - clip_vector(statistic_last.Y.whole_frame.predicted + statistic.Y.whole_frame.residue, 'resi_delta_tt');   %$\tilde{\Delta}^{k}_{\mathbf{u}}\{\bar{r},m,p\}$ where p means only last frame have residual error
% statistic.Y.whole_frame.delta_Nr_Nm_qConc = statistic.Y.whole_frame.prop_clip_conc - reference_align(statistic_last.Y.whole_frame.concealment_error_clip, MV, image_width, image_height);    %$\tilde{\Delta}^{k}_{\mathbf{u}}\{\bar{r},\bar{m},p\}$ where p means only last frame have motion vector error
% statistic.Y.whole_frame.delta_Nr_m_qConc = (statistic_last.Y.whole_frame.reconstructed - statistic_last.Y.whole_frame.concealment_error_clip + statistic.Y.whole_frame.residue) - clip_vector(statistic_last.Y.whole_frame.reconstructed - statistic_last.Y.whole_frame.concealment_error_clip + statistic.Y.whole_frame.residue, 'conc_delta_tt');   %$\tilde{\Delta}^{k}_{\mathbf{u}}\{\bar{r},m,p\}$ where p means only last frame have motion vector error
% statistic.Y.whole_frame.delta_Nr_Nm_pBoth = statistic.Y.whole_frame.prop_clip_both - reference_align(statistic_last.Y.whole_frame.both_error, MV, image_width, image_height);  %$\tilde{\Delta}^{k}_{\mathbf{u}}\{\bar{r},\bar{m},p\}$ where p means only last frame have residual and motion vector error
% statistic.Y.whole_frame.delta_Nr_m_pBoth = (statistic_last.Y.whole_frame.reconstructed - statistic.Y.whole_frame.residue_clip - statistic_last.Y.whole_frame.concealment_error + statistic.Y.whole_frame.residue) - clip_vector(statistic_last.Y.whole_frame.reconstructed - statistic.Y.whole_frame.residue_clip - statistic_last.Y.whole_frame.concealment_error + statistic.Y.whole_frame.residue, 'both_delta_tt');   %$\tilde{\Delta}^{k}_{\mathbf{u}}\{\bar{r},m,p\}$ where p means only last frame have residual and motion vector error



%plot the correlation coefficient between residue data and predicted pixel
%value and between residue data and reconstructed pixel value
statistic.Y.whole_frame.rho_resi_pred = get_two_whole_frame_rho(statistic.Y.whole_frame.residue, statistic.Y.whole_frame.predicted);
statistic.Y.whole_frame.rho_resi_recon = get_two_whole_frame_rho(statistic.Y.whole_frame.residue, statistic.Y.whole_frame.reconstructed);
%plot the correlatio coefficient between concealment error and
%last reconstructed pixel value
statistic.Y.whole_frame.rho_curr_conc_pred = get_two_whole_frame_rho(statistic.Y.whole_frame.concealment_error, statistic.Y.whole_frame.predicted);
statistic.Y.whole_frame.rho_curr_conc_last_recon = get_two_whole_frame_rho(statistic.Y.whole_frame.concealment_error, statistic_last.Y.whole_frame.reconstructed);


%calculate correlation coeffiencts, should be attention while any input is
%0, some rho will be NaN
%%R_whole_frame_4x4 = corrcoef([statistic.Y.whole_frame.residue, statistic.Y.whole_frame.concealment_error, statistic_last.Y.whole_frame.residue, statistic_last.Y.whole_frame.concealment_error]);
statistic.Y.whole_frame.rho_curr_resi_curr_conc = get_two_whole_frame_rho(statistic.Y.whole_frame.residue, statistic.Y.whole_frame.concealment_error);
statistic.Y.whole_frame.rho_curr_resi_last_resi = get_two_whole_frame_rho(statistic.Y.whole_frame.residue, statistic_last.Y.whole_frame.residue);
statistic.Y.whole_frame.rho_curr_resi_last_conc = get_two_whole_frame_rho(statistic.Y.whole_frame.residue, statistic_last.Y.whole_frame.concealment_error);
statistic.Y.whole_frame.rho_curr_conc_last_resi = get_two_whole_frame_rho(statistic.Y.whole_frame.concealment_error, statistic_last.Y.whole_frame.residue);
statistic.Y.whole_frame.rho_curr_conc_last_conc = get_two_whole_frame_rho(statistic.Y.whole_frame.concealment_error, statistic_last.Y.whole_frame.concealment_error);

residue_last_Y_align = reference_align(statistic_last.Y.whole_frame.residue, MV, image_width, image_height);
concealment_error_last_Y_align = reference_align(statistic_last.Y.whole_frame.concealment_error, MV, image_width, image_height);

%R_whole_frame_align_4x4 = corrcoef([statistic.Y.whole_frame.residue, statistic.Y.whole_frame.concealment_error, residue_align, concealment_error_align]);
%statistic.Y.whole_frame.rho_crcc_align = get_two_whole_frame_rho(statistic.Y.whole_frame.residue, statistic.Y.whole_frame.concealment_error);
statistic.Y.whole_frame.rho_crlr_align = get_two_whole_frame_rho(statistic.Y.whole_frame.residue, residue_last_Y_align);
statistic.Y.whole_frame.rho_crlc_align = get_two_whole_frame_rho(statistic.Y.whole_frame.residue, concealment_error_last_Y_align);
statistic.Y.whole_frame.rho_cclr_align = get_two_whole_frame_rho(statistic.Y.whole_frame.concealment_error, residue_last_Y_align);
statistic.Y.whole_frame.rho_cclc_align = get_two_whole_frame_rho(statistic.Y.whole_frame.concealment_error, concealment_error_last_Y_align);

function rho = get_two_whole_frame_rho(frame_1, frame_2)
if(var(frame_1)==0 | var(frame_2)==0)
    rho = 0;
else
    R_whole_frame_2x2 = corrcoef([frame_1, frame_2]);
    rho = R_whole_frame_2x2(1, 2);
end
