%--------------------------------------------------------------------------
%this function is the motion compensation function
%
%Chen Zhifeng
%UFID 12181197
%2008-07-17
%zhifeng@ecel.ufl.edu
%--------------------------------------------------------------------------
function img_align = reference_align(img, MV_one_frame, image_width, image_height)
%subsampling, block_size, block_number_row, block_number_col, image_width,
%image_height are global variables
%The reason to use all same size for YUV matrix due to the motion vectors
%are pixel-wised

global block_size; %the minimum block for one motion vector

block_number_row = image_width/block_size;
block_number_col = image_height/block_size;

img = reshape(img, image_width, image_height);

for block_no_col = 1: 1 : block_number_col
    for block_no_row = 1: 1: block_number_row
        MV_x = MV_one_frame(1, block_no_row, block_no_col);
        MV_y = MV_one_frame(2, block_no_row, block_no_col);
        
        pos_row = (block_no_row-1) * block_size + 1;
        pos_col = (block_no_col-1) * block_size + 1;
        pos_row_last = pos_row + MV_x;
        pos_col_last = pos_col + MV_y;
        if(pos_row_last<1 | pos_row_last+block_size-1>image_width |pos_col_last<1 | pos_col_last+block_size-1>image_height)
            img_align(pos_row : pos_row+block_size-1, pos_col : pos_col+block_size-1) = 0;
            output_message(sprintf('Warning: out of bound: block at x=%dth, y=%dth; MV is x=%d, y=%d',pos_row, pos_col, MV_x, MV_y));
        else
            img_align(pos_row : pos_row+block_size-1, pos_col : pos_col+block_size-1) = img(pos_row_last : pos_row_last+block_size-1, pos_col_last : pos_col_last+block_size-1);
        end
    end
end

img_align = reshape(img_align, image_width * image_height, 1);
