%--------------------------------------------------------------------------
%this function is used to plot all the results used in the paper
%
%Chen Zhifeng
%UFID 12181197
%2008-07-17
%zhifeng@ecel.ufl.edu
%--------------------------------------------------------------------------
function result_loop = plot_result(statistic, distortion, para_image, para_chan, para_advan)

plot_for_patent(statistic, distortion, para_chan);
result_loop = plot_distortion(distortion, para_chan, para_advan);



function plot_for_patent(statistic, distortion, para_chan)

global video_name   %initialized in the main function
global channel_index    %initialized in the main function
global loop_counter %initialized in the main function

global folder_MATLAB;

frame_number = length(statistic);

h = figure; hold on;
for frame_no = 1: frame_number
    rec_Y(frame_no) = distortion(frame_no).rec.Y;
end
plot(rec_Y, 'b');

for frame_no = 1: frame_number
    rec_Y_H264(frame_no) = distortion(frame_no).rec_H264.Y;
end
plot(rec_Y_H264, 'b--');

%legend('Our reconstruction method', 'JM''s reconstruction method', 'predicted with feedback', 'predicted without feedback', 'Location', 'North');
legend('Our reconstruction method', 'JM''s reconstruction method', 'Location', 'North');
xlabel('frame index', 'fontsize',12, 'fontweight','b');
ylabel('SSE distortion', 'fontsize',12, 'fontweight','b');
display_title(para_chan);
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_SSE_patent', folder_MATLAB, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_SSE_patent', folder_MATLAB, video_name, channel_index, loop_counter ), 'fig');
close(h)   %To protect GUI by not using close all


%plot_PSNR
peak_pixel_value = 255;

psnr_rec_Y = 10*log10(peak_pixel_value^2./rec_Y);
psnr_rec_Y_H264 = 10*log10(peak_pixel_value^2./rec_Y_H264);


h = figure; hold on;
plot(psnr_rec_Y, 'b');
plot(psnr_rec_Y_H264, 'b--');

legend('Our reconstruction method', 'JM''s reconstruction method', 'Location', 'North');
xlabel('frame index', 'fontsize',12, 'fontweight','b');
ylabel('PSNR', 'fontsize',12, 'fontweight','b');
display_title(para_chan);
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_PSNR_patent', folder_MATLAB, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_PSNR_patent', folder_MATLAB, video_name, channel_index, loop_counter ), 'fig');
close(h)   %To protect GUI by not using close all

%plot gain
ratio = rec_Y_H264./rec_Y;

for frame_no = 1: frame_number
    Y_whole_resi_MSE(frame_no) = statistic(frame_no).Y.whole_frame.residue_MSE;
    Y_whole_conc_MSE(frame_no) = statistic(frame_no).Y.whole_frame.concealment_error_MSE;
    switch para_chan.channel_type
        case 'R'
            PER_A = para_chan.input_DPA;
            PER_B = para_chan.input_DPB;
            PER_C = para_chan.input_DPC;
            ratio_pred(frame_no) = 1 + sum(Y_whole_resi_MSE(1:frame_no))/(PER_C / PER_A * sum(Y_whole_resi_MSE(1:frame_no)) + sum(Y_whole_conc_MSE(1:frame_no)));
        case 'D'
            PER_A = 0;
            PER_B = 0;
            PER_C = 0;
            ratio_pred(frame_no) = 1;
        otherwise
            output_message('Warning: unknown channel type');
    end

end

h = figure; hold on;
plot(ratio, 'b');
plot(ratio_pred, 'b--');

legend('ratio', 'ratio_pred', 'Location', 'North');
xlabel('frame index', 'fontsize',12, 'fontweight','b');
ylabel('reconstructed gain', 'fontsize',12, 'fontweight','b');
display_title(para_chan);
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_gain_patent', folder_MATLAB, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_gain_patent', folder_MATLAB, video_name, channel_index, loop_counter ), 'fig');
close(h)   %To protect GUI by not using close all








function result_loop = plot_distortion(distortion, para_chan, para_advan)
%plot result, base on b: blue, g: green, r: red, c: cyan, m: magenta, y:
%yellow, k: black
global video_name;
global channel_index    %initialized in the main function
global loop_counter;

global folder_MATLAB;

frame_number = length(distortion);

h = figure; hold on;
for frame_no = 1: frame_number
    rec_Y(frame_no) = distortion(frame_no).rec.Y;
end
plot(rec_Y, 'b');

for frame_no = 1: frame_number
    rec_Y_H264(frame_no) = distortion(frame_no).rec_H264.Y;
end
plot(rec_Y_H264, 'b--');

for frame_no = 1: frame_number
    rec_Y_JM_trial(frame_no) = distortion(frame_no).rec_JM_trial.Y;
end
plot(rec_Y_JM_trial, 'b-.');

if(para_advan.alg1.flag)
    for frame_no = 1: frame_number
        alg1_Y_resi(frame_no) = distortion(frame_no).alg1.Y.residue;
        alg1_Y_conc(frame_no) = distortion(frame_no).alg1.Y.concealment_error;
        alg1_Y_prop(frame_no) = distortion(frame_no).alg1.Y.prop;
        alg1_Y_adju(frame_no) = distortion(frame_no).alg1.Y.adjusted;
        alg1_Y_pred(frame_no) = distortion(frame_no).alg1.Y.estimated;
    end
    plot(alg1_Y_resi, 'c:');
    plot(alg1_Y_conc, 'c--');
    plot(alg1_Y_prop, 'c.');
    plot(alg1_Y_adju, 'c*');
    plot(alg1_Y_pred, 'c');
end

%use the same color for algorithm 1 and algorithm 2 since they should have
%the exactly same result!
if(para_advan.alg2.flag)
    for frame_no = 1: frame_number
        alg2_Y_resi(frame_no) = distortion(frame_no).alg2.Y.residue;
        alg2_Y_conc(frame_no) = distortion(frame_no).alg2.Y.concealment_error;
        alg2_Y_prop(frame_no) = distortion(frame_no).alg2.Y.prop;
        alg2_Y_adju(frame_no) = distortion(frame_no).alg2.Y.adjusted;
        alg2_Y_pred(frame_no) = distortion(frame_no).alg2.Y.estimated;
    end
    plot(alg2_Y_resi, 'm:');
    plot(alg2_Y_conc, 'm--');
    plot(alg2_Y_prop, 'm.');
    plot(alg2_Y_adju, 'm*');
    plot(alg2_Y_pred, 'm');
end

if(para_advan.alg3.flag)
    for frame_no = 1: frame_number
        alg3_Y_resi(frame_no) = distortion(frame_no).alg3.Y.residue;
        alg3_Y_conc(frame_no) = distortion(frame_no).alg3.Y.concealment_error;
        alg3_Y_prop(frame_no) = distortion(frame_no).alg3.Y.prop;
        alg3_Y_adju(frame_no) = distortion(frame_no).alg3.Y.adjusted;
        alg3_Y_pred(frame_no) = distortion(frame_no).alg3.Y.estimated;
    end
    plot(alg3_Y_resi, 'y:');
    plot(alg3_Y_conc, 'y--');
    plot(alg3_Y_prop, 'y.');
    plot(alg3_Y_adju, 'y*');
    plot(alg3_Y_pred, 'y');
end

if(para_advan.alg4.flag)
    for frame_no = 1: frame_number
        alg4_Y_resi(frame_no) = distortion(frame_no).alg4.Y.residue;
        alg4_Y_conc(frame_no) = distortion(frame_no).alg4.Y.concealment_error;
        alg4_Y_prop(frame_no) = distortion(frame_no).alg4.Y.prop;
        alg4_Y_adju(frame_no) = distortion(frame_no).alg4.Y.adjusted;
        alg4_Y_pred(frame_no) = distortion(frame_no).alg4.Y.estimated;
    end
    plot(alg4_Y_resi, 'k:');
    plot(alg4_Y_conc, 'k--');
    plot(alg4_Y_prop, 'k.');
    plot(alg4_Y_adju, 'k*');
    plot(alg4_Y_pred, 'k');
end

if(para_advan.alg5.flag)
    for frame_no = 1: frame_number
        alg5_Y_resi(frame_no) = distortion(frame_no).alg5.Y.residue;
        alg5_Y_conc(frame_no) = distortion(frame_no).alg5.Y.concealment_error;
        alg5_Y_prop(frame_no) = distortion(frame_no).alg5.Y.prop;
        alg5_Y_adju(frame_no) = distortion(frame_no).alg5.Y.adjusted;
        alg5_Y_pred(frame_no) = distortion(frame_no).alg5.Y.estimated;
    end
    plot(alg5_Y_resi, 'g:');
    plot(alg5_Y_conc, 'g--');
    plot(alg5_Y_prop, 'g.');
    plot(alg5_Y_adju, 'g*');
    plot(alg5_Y_pred, 'g');
end

if(para_advan.alg6.flag)
    for frame_no = 1: frame_number
        alg6_Y_resi(frame_no) = distortion(frame_no).alg6.Y.residue;
        alg6_Y_conc(frame_no) = distortion(frame_no).alg6.Y.concealment_error;
        alg6_Y_prop(frame_no) = distortion(frame_no).alg6.Y.prop;
        alg6_Y_adju(frame_no) = distortion(frame_no).alg6.Y.adjusted;
        alg6_Y_pred(frame_no) = distortion(frame_no).alg6.Y.estimated;
    end
    plot(alg6_Y_resi, 'r:');
    plot(alg6_Y_conc, 'r--');
    plot(alg6_Y_prop, 'r.');
    plot(alg6_Y_adju, 'r*');
    plot(alg6_Y_pred, 'r');
end

legend('b: paper, c: alg1, m: alg2, y: alg3, k: alg4, g: alg5, r: alg6', 'Location', 'North');
xlabel('frame index');
ylabel('SSE distortion');
display_title(para_chan);
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_SSE', folder_MATLAB, video_name, channel_index, loop_counter));
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_plot_result', folder_MATLAB, video_name, channel_index, loop_counter));
close(h)   %To protect GUI by not using close all


%return the results for statistical average over all loops
result_loop.rec_Y = rec_Y;
result_loop.rec_Y_H264 = rec_Y_H264;
result_loop.rec_Y_JM_trial = rec_Y_JM_trial;
result_loop.alg1_Y_pred = alg1_Y_pred;
result_loop.alg2_Y_pred = alg2_Y_pred;
result_loop.alg3_Y_pred = alg3_Y_pred;
result_loop.alg4_Y_pred = alg4_Y_pred;
result_loop.alg5_Y_pred = alg5_Y_pred;
result_loop.alg6_Y_pred = alg6_Y_pred;



%plot_PSNR
peak_pixel_value = 255;

psnr_rec_Y = 10*log10(peak_pixel_value^2./rec_Y);
psnr_rec_Y_H264 = 10*log10(peak_pixel_value^2./rec_Y_H264);
psnr_rec_Y_JM_trial = 10*log10(peak_pixel_value^2./rec_Y_JM_trial);
psnr_alg1_Y_pred = 10*log10(peak_pixel_value^2./alg1_Y_pred);
psnr_alg2_Y_pred = 10*log10(peak_pixel_value^2./alg2_Y_pred);
psnr_alg3_Y_pred = 10*log10(peak_pixel_value^2./alg3_Y_pred);
psnr_alg4_Y_pred = 10*log10(peak_pixel_value^2./alg4_Y_pred);
psnr_alg5_Y_pred = 10*log10(peak_pixel_value^2./alg5_Y_pred);
psnr_alg6_Y_pred = 10*log10(peak_pixel_value^2./alg6_Y_pred);

h = figure; hold on;
plot(psnr_rec_Y, 'b');
plot(psnr_rec_Y_H264, 'b--');
plot(psnr_rec_Y_JM_trial, 'b-.');
plot(psnr_alg1_Y_pred, 'c');
plot(psnr_alg2_Y_pred, 'm');
plot(psnr_alg3_Y_pred, 'y');
plot(psnr_alg4_Y_pred, 'k');
plot(psnr_alg5_Y_pred, 'g');
plot(psnr_alg6_Y_pred, 'r');

legend('b: real, c: alg1, m: alg2, y: alg3, k: alg4, g: alg5, r: alg6', 'Location', 'North');
xlabel('frame index');
ylabel('PSNR');
display_title(para_chan);
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_PSNR', folder_MATLAB, video_name, channel_index, loop_counter));
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_plot_result', folder_MATLAB, video_name, channel_index, loop_counter));
close(h)   %To protect GUI by not using close all



function display_title(para_chan)
switch para_chan.channel_type
    case 'R'
        title(['residue data PER: ', num2str(para_chan.input_DPC*100), '%, motion vector PER: ', num2str(para_chan.input_DPA*100), '%']);
    case 'D'
        title([sprintf('%dth ', para_chan.input_DPC), 'slice of residue data is lost, ', sprintf('%dth ', para_chan.input_DPA), 'slice of motion vector is lost']);
    otherwise
        output_message('Warning: unknown channel type');
end


