%--------------------------------------------------------------------------
%this function is to display the message in the GUI listbox
%
%Chen Zhifeng
%UFID 12181197
%2008-10-15
%zhifeng@ecel.ufl.edu
%--------------------------------------------------------------------------
function output_message(string)

global display_message  %initialized in the VDAT_OpeningFcn function

%To protect MATLAB error in case the GUI is closed by close command!
h = get(0,'CurrentFigure'); 

string = [datestr(clock, 13), '  ', string];

if (isempty(h))
    disp([string, ' !!!The GUI is mistakenly closed!!!']);
else
    contents = get(display_message,'String');

    % %set the new line highlight to the end of listbox
    % set(handle, 'Value', length(contents) + 1);

    %set the new line highlight next to the current line
    index = get(display_message, 'Value');
    if length(contents) == 0
        set(display_message,'String', {string});
        set(display_message, 'Value', 1);
    elseif index == length(contents)
        set(display_message,'String', [contents; {string}]);
        set(display_message, 'Value', index + 1);
    else
        set(display_message,'String', [contents(1:index); {string}; contents(index+1:end)] );
        set(display_message, 'Value', index + 1);
    end
    drawnow
end


