%--------------------------------------------------------------------------
%this function is the motion compensation function
%
%Chen Zhifeng
%UFID 12181197
%2008-07-17
%zhifeng@ecel.ufl.edu
%--------------------------------------------------------------------------
function img_predicted = motion_compensation(img_last, MV_one_frame, para_image)
%subsampling, block_size, block_number_row, block_number_col, image_width,
%image_height are global variables
%The reason to use all same size for YUV matrix due to the motion vectors
%are pixel-wised
MC_method = 'block';    %block method is 9 times faster than pixel!

global block_size; %the minimum block for one motion vector

image_width = para_image.width;
image_height = para_image.height;
subsampling = para_image.subsampling;

block_number_row = image_width/block_size;
block_number_col = image_height/block_size;

% output_message('Begin motion compensation');
for block_no_col = 1: 1 : block_number_col
    for block_no_row = 1: 1: block_number_row
        MV_x = MV_one_frame(1, block_no_row, block_no_col);
        MV_y = MV_one_frame(2, block_no_row, block_no_col);
        switch MC_method
            case 'block'
                pos_row = (block_no_row-1) * block_size + 1;
                pos_col = (block_no_col-1) * block_size + 1;
                pos_row_last = pos_row + MV_x;
                pos_col_last = pos_col + MV_y;
                if(pos_row_last<1 | pos_row_last+block_size-1>image_width |pos_col_last<1 | pos_col_last+block_size-1>image_height)
                    imgY(pos_row : pos_row+block_size-1, pos_col : pos_col+block_size-1) = 0;
                    imgU_up(pos_row : pos_row+block_size-1, pos_col : pos_col+block_size-1) = 0;
                    imgV_up(pos_row : pos_row+block_size-1, pos_col : pos_col+block_size-1) = 0;
                    output_message(sprintf('Warning: out of bound: block at x=%dth, y=%dth; MV is x=%d, y=%d',pos_row, pos_col, MV_x, MV_y));
                else
                    imgY(pos_row : pos_row+block_size-1, pos_col : pos_col+block_size-1) = img_last(pos_row_last : pos_row_last+block_size-1, pos_col_last : pos_col_last+block_size-1, 1);
                    imgU_up(pos_row : pos_row+block_size-1, pos_col : pos_col+block_size-1) = img_last(pos_row_last : pos_row_last+block_size-1, pos_col_last : pos_col_last+block_size-1, 2);
                    imgV_up(pos_row : pos_row+block_size-1, pos_col : pos_col+block_size-1) = img_last(pos_row_last : pos_row_last+block_size-1, pos_col_last : pos_col_last+block_size-1, 3);
                end
            case 'pixel'
                for j = 1:1:block_size
                    for i = 1:1:block_size
                        pos_row = (block_no_row-1)*block_size + i;
                        pos_col = (block_no_col-1)*block_size + j;
                        pos_row_last = pos_row + MV_x;
                        pos_col_last = pos_col + MV_y;

                        %note that matlab subscript begin from 1, while c language
                        %begin from 0
                        if (pos_row_last<1 | pos_row_last>image_width |pos_col_last<1 | pos_col_last>image_height)
                            imgY(pos_row, pos_col) = 0;
                            imgU_up(pos_row, pos_col) = 0;
                            imgV_up(pos_row, pos_col) = 0;
                            ouput_message(sprintf('out of bound: pixel at x=%dth, y=%dth; MV is x=%d, y=%d',pos_row, pos_col, MV_x, MV_y));
                        else
                            imgY(pos_row, pos_col) = img_last(pos_row_last, pos_col_last, 1);
                            imgU_up(pos_row, pos_col) = img_last(pos_row_last, pos_col_last, 2);
                            imgV_up(pos_row, pos_col) = img_last(pos_row_last, pos_col_last, 3);
                        end
                    end
                end
            otherwise
                output_message('Warning: unknown motion compensation format');
        end

    end
end

% output_message('Finish motion compensation');

%get chroma value for different subsampling
switch subsampling
    case '4:2:0'
        image_widthUV = image_width / 2;
        image_heightUV = image_height / 2;
        up_sampling = [1,1;1,1];
        
        for j = 1 : image_heightUV
            for i = 1 : image_widthUV
                pixel_U_1 = imgU_up(2*(i-1)+1,2*(j-1)+1);
                pixel_U_2 = imgU_up(2*i,2*(j-1)+1);
                pixel_U_3 = imgU_up(2*(i-1)+1,2*j);
                pixel_U_4 = imgU_up(2*i,2*j);
                imgU(i,j) = floor((pixel_U_1 + pixel_U_2 + pixel_U_3 + pixel_U_4 + 2)/4);

                pixel_V_1 = imgV_up(2*(i-1)+1,2*(j-1)+1);
                pixel_V_2 = imgV_up(2*i,2*(j-1)+1);
                pixel_V_3 = imgV_up(2*(i-1)+1,2*j);
                pixel_V_4 = imgV_up(2*i,2*j);
                imgV(i,j) = floor((pixel_V_1 + pixel_V_2 + pixel_V_3 + pixel_V_4 + 2)/4);
            end
        end
        img_predicted(:, :, 1) = imgY;
        img_predicted(:, :, 2) = kron(imgU, up_sampling);
        img_predicted(:, :, 3) = kron(imgV, up_sampling);
    otherwise
        output_message('Warning: unknown subsampling format');
end

