%--------------------------------------------------------------------------
%this function is main loop function, which is the main frame for the whole
%program
%Since matlab read buffer from the first dimension defined in the first
%parameter when using reshape function, we define all matrix in such form:
%M(row, col, time)
%
%Chen Zhifeng
%UFID 12181197
%2008-07-17
%zhifeng@ecel.ufl.edu
%--------------------------------------------------------------------------
function [statistic, distortion] = main_loop(para_conf, para_image, para_chan, para_advan)

global f_debug
global folder_encoder
global folder_loop
global folder_MATLAB
global folder_decoder
global filename_residue %initialized in the encoder_JM function
global filename_MV
global filename_JM_rec_enc;     %initialized in the encoder_JM function


%below should be macro definition in C
global MB_size
global block_size

save_temp = para_conf.save_temp;
image_width = para_image.width;
image_height = para_image.height;
MB_per_slice = para_image.MB_per_slice;
frame_number = para_image.frame_number;
frame_offset = para_image.frame_offset;
subsampling = para_image.subsampling;
subpel_ME = para_image.subpel_ME;
FMO_type = para_image.FMO_type;

MB_size = 16;
block_size = 4; %the minimum block for one motion vector


%local variables
pixel_per_frame = image_width * image_height;
MB_per_frame = image_width * image_height / (MB_size * MB_size);
slice_per_frame = MB_per_frame / MB_per_slice;

%make a new folder to save the results come from main_loop
folder_MATLAB = [folder_loop, '\MATLAB'];
mkdir(folder_MATLAB);

%below parameters should be changed for different input!
f_residue = fopen([folder_encoder, '\', filename_residue], 'r');
f_MV = fopen([folder_encoder, '\', filename_MV], 'r');

filename_reconstructed = 'reconstructed.yuv';
f_reconstructed = fopen([folder_MATLAB, '\', filename_reconstructed], 'w');
filename_receiver = 'rec_receiver.yuv';
f_receiver = fopen([folder_MATLAB, '\', filename_receiver], 'w');
filename_receiver_H264 = 'rec_receiver_H264.yuv';
f_receiver_H264 = fopen([folder_MATLAB, '\', filename_receiver_H264], 'w');
filename_receiver_bw = 'rec_receiver_bw.yuv';
f_receiver_bw = fopen([folder_MATLAB, '\', filename_receiver_bw], 'w');

%begin the main process

[packetA_error_flag, packetC_error_flag] = channel_setting(para_chan, frame_number, slice_per_frame); %count based on frame_number_P
filename_264_lost = channel_for_h264(frame_number, slice_per_frame, packetA_error_flag, packetC_error_flag);

[filename_JM_rec_dec_copy, filename_JM_rec_dec_trial] = decoder_JM(filename_264_lost);
f_dec_trial = fopen([folder_decoder, '\', filename_JM_rec_dec_trial], 'r');

for frame_no = 1 : frame_number
%     residue(image_widthUV+1:image_width, 1:image_heightUV, 3) = 0;
%     residue(1:image_width, image_heightUV+1:image_height, 3) = 0;
    trace_file(sprintf('begin processing %d frame', frame_no));
    if frame_no == 1
        %initial the encoder
        data.residue = get_residue_single(f_residue, frame_no, para_image);    %It is actually not residue, but the reconstructed value
        data.MV = zeros(2, image_width / block_size, image_height / block_size);
        data.img_predicted = zeros(image_width, image_height, 3)+128;    %It is actually not residue, but the reconstructed value
        data.img_reconstructed = data.residue;
        data.concealment_error = zeros(image_width, image_height, 3);
        data.concealment_error_clip = zeros(image_width, image_height, 3);
        data.both_error = zeros(image_width, image_height, 3);

        %initial the decoder
        img_reconstructed_receiver = data.img_reconstructed;
        img_reconstructed_receiver_H264 = data.img_reconstructed;
        img_reconstructed_receiver_bw = data.img_reconstructed;
        
        %initial the variables which introduce distortion initially
        statistic(frame_no)= statistic_IDR(para_image);
        distortion(frame_no) = distortion_IDR();
    else
        frame_no_P = frame_no - 1;
        %encoder processing
        data.residue = get_residue_single(f_residue, frame_no, para_image);
        data.MV = get_MV_single(f_MV, frame_no_P, para_image);    %It is actually not residue, but the reconstructed value
        data.img_predicted = motion_compensation(img_reconstruct_last, data.MV, para_image);    %subsampling, block_size, block_number_row, block_number_col, image_width, image_height are global variables
        data.img_reconstructed = clip_pixel_value( data.img_predicted + data.residue, frame_no, 'encoder' ); %it is same as the iClip1 function in JM
        data.residue_clip = data.img_reconstructed - data.img_predicted;
        data.concealment_error = data.img_predicted - img_reconstruct_last;
        data.concealment_error_clip = data.img_reconstructed - clip_pixel_value((img_reconstruct_last + data.residue), frame_no, 'clip_conc' );
        data.both_error = data.img_reconstructed - img_reconstruct_last;

        %decoder processing
        packetA_error_flag_one_frame = packetA_error_flag((frame_no_P-1)*slice_per_frame+1 : frame_no_P*slice_per_frame);
        packetC_error_flag_one_frame = packetC_error_flag((frame_no_P-1)*slice_per_frame+1 : frame_no_P*slice_per_frame);
        [error_residue_flag, error_MV_flag] = error_map(packetA_error_flag_one_frame, packetC_error_flag_one_frame, para_image); 
        %to simulate the channel
        [residue_one_frame_receiver, MV_one_frame_receiver] = channel_simulation(data.residue, data.MV, error_residue_flag, error_MV_flag, para_image);
        %to decode the received packets
        [img_reconstructed_receiver, img_reconstructed_receiver_H264, img_reconstructed_receiver_bw] = decoder(img_reconstruct_receiver_last, img_reconstruct_receiver_H264_last, residue_one_frame_receiver, MV_one_frame_receiver, error_residue_flag, error_MV_flag, para_image, frame_no);  %should check whether input and output should be different name in MATLAB
    

        %calculate the image parameters which is used to calculate
        %distortion
        statistic(frame_no) = statistic_P(data, para_image, statistic(frame_no-1));

        if (para_advan.alg1.flag)
            distortion(frame_no).alg1 = algorithm_implement(statistic(frame_no), statistic(frame_no-1), frame_no, distortion(frame_no-1).alg1, para_image, para_chan, 5, 0);
        end

        if (para_advan.alg2.flag)
            distortion(frame_no).alg2 = algorithm_implement(statistic(frame_no), statistic(frame_no-1), frame_no, distortion(frame_no-1).alg2, para_image, para_chan, 51, 0);
        end

        if (para_advan.alg3.flag)
            distortion(frame_no).alg3 = algorithm_implement(statistic(frame_no), statistic(frame_no-1), frame_no, distortion(frame_no-1).alg3, para_image, para_chan, 21, 0);
        end

        if (para_advan.alg4.flag)
            distortion(frame_no).alg4 = algorithm_implement(statistic(frame_no), statistic(frame_no-1), frame_no, distortion(frame_no-1).alg4, para_image, para_chan, 20, 0);
        end

        if (para_advan.alg5.flag)
            distortion(frame_no).alg5 = algorithm_implement(statistic(frame_no), statistic(frame_no-1), frame_no, distortion(frame_no-1).alg5, para_image, para_chan, 23, 0);
        end

        if (para_advan.alg6.flag)
            distortion(frame_no).alg6 = algorithm_implement(statistic(frame_no), statistic(frame_no-1), frame_no, distortion(frame_no-1).alg6, para_image, para_chan, 50, 0);
        end
    end
    
    %to calculate the actual distortion in decoder side
    error_in_fact = img_reconstructed_receiver - data.img_reconstructed;
    distortion(frame_no).rec.Y = sum(sum(error_in_fact(:,:,1).^2))/pixel_per_frame;

    error_in_fact_H264 = img_reconstructed_receiver_H264 - data.img_reconstructed;
    distortion(frame_no).rec_H264.Y = sum(sum(error_in_fact_H264(:,:,1).^2))/pixel_per_frame;

    rec_dec_trial = get_reconstruction_single(f_dec_trial, frame_no, para_image);
    error_in_fact_JM_trial = rec_dec_trial - data.img_reconstructed;
    distortion(frame_no).rec_JM_trial.Y = sum(sum(error_in_fact_JM_trial(:,:,1).^2))/pixel_per_frame;

    %to save the files
    write_one_frame(data.img_reconstructed, f_reconstructed, para_image);
    img_reconstruct_last = data.img_reconstructed;

    write_one_frame(img_reconstructed_receiver, f_receiver, para_image);
    img_reconstruct_receiver_last = img_reconstructed_receiver;

    write_one_frame(img_reconstructed_receiver_H264, f_receiver_H264, para_image);
    img_reconstruct_receiver_H264_last = img_reconstructed_receiver_H264;

    write_one_frame(img_reconstructed_receiver_bw, f_receiver_bw, para_image);
  
end
trace_file(sprintf('finish processing total %dth frames', frame_number));
fclose(f_residue);
fclose(f_MV);
fclose(f_dec_trial);

fclose(f_reconstructed);
fclose(f_receiver);
fclose(f_receiver_H264);
fclose(f_receiver_bw);

%compare produced files before plot results
diff_num = compare_file([folder_MATLAB, '\', filename_reconstructed], [folder_encoder, '\', filename_JM_rec_enc], 0);
if(diff_num>0)
    output_message('Warning: !!!the reconstructed results of JM and mine in encoder are different, please check trace file for details!');
    trace_file('Warning: !!!the reconstructed results of JM and mine in encoder are different, please check by using compare_file()!' );
end

diff_num = compare_file([folder_MATLAB, '\', filename_receiver_H264], [folder_decoder, '\', filename_JM_rec_dec_copy], 0);
if(diff_num>0)
    output_message('Warning: !!!the reconstructed results of JM and mine in decoder after lossy channel are different, please check trace file for details!');
    trace_file('Warning: !!!the reconstructed results of JM and mine in decoder after lossy channel are different, please check by using compare_file()!' );
end

if(save_temp == 0)
    dos(['del ', [folder_MATLAB, '\', filename_reconstructed]]);
    dos(['del ', [folder_MATLAB, '\', filename_receiver_H264]]);
    dos(['del ', [folder_MATLAB, '\', filename_receiver_bw]]);
%     dos(['del ', [folder_MATLAB, '\', filename_receiver]]);
%     dos(['del ', [folder_decoder, '\', filename_JM_rec_dec_copy]]);
    dos(['del ', [folder_decoder, '\', filename_JM_rec_dec_trial]]);
end



