%--------------------------------------------------------------------------
%this function is main function, which configurate the setting of video
%sequence, simulation loops for each video sequence and the channel
%parameters for different channel setting
%
%Chen Zhifeng
%UFID 12181197
%2008-07-17
%zhifeng@ecel.ufl.edu
%--------------------------------------------------------------------------
function main(para_setting, hObject)

clc
tic

global f_debug
global folder_encoder
global folder_video
global folder_channel
global folder_loop

global video_name   %just for the assumption_verify function and plot_result
global channel_index    %just for the assumption_verify function and plot_result
global loop_counter %just for the assumption_verify function and plot_result

%para_setting struct should not be pass to encoder and main_loop
para_conf = para_setting.conf;
para_image = para_setting.image;
para_advan = para_setting.advan;
 
%create a new folder
current_time = datestr(clock, 30);
new_folder = [para_setting.conf.folder, '\', current_time];
if(mkdir(new_folder) == 0)
    output_message('Error: failed to make new_folder');
end

filename_debug = 'debug.txt';
f_debug = fopen([new_folder, '\', filename_debug], 'w');

username = getenv('username');
trace_file(sprintf('This file is automatically produced by %s', username));

%loop for all videos
for video_index = 1 : length(para_setting.conf.videos)
    time_one_video_begin = toc;
    output_message(sprintf('Begin processing the %dth video sequence', video_index ));
    trace_file(sprintf('Begin processing the %dth video sequence', video_index ));
    video_name_with_path = para_setting.conf.videos{video_index};
    pos_backslash = findstr(video_name_with_path,'\');
    video_name = video_name_with_path(pos_backslash(end) + 1 : end-4);
    folder_video = [new_folder, '\', video_name];
    mkdir(folder_video);
    
    encoder_JM(video_name_with_path, para_image);
    
    %loop for all channels for each video
    for channel_index = 1 : length(para_setting.chan.channels)
        output_message(sprintf('Begin simulate the %dth channel', channel_index));
        trace_file(sprintf('Begin simulate the %dth channel', channel_index));
        channel_setting = para_setting.chan.channels{channel_index};
        
        pos_semicolon = findstr(channel_setting,';');
        para_chan.channel_type = channel_setting(1 : pos_semicolon(1) - 1);
        para_chan.input_DPA = str2num(channel_setting(pos_semicolon(1) + 1 : pos_semicolon(2) - 1));
        para_chan.input_DPB = str2num(channel_setting(pos_semicolon(2) + 1 : pos_semicolon(3) - 1));
        para_chan.input_DPC = str2num(channel_setting(pos_semicolon(3) + 1 : end));

        folder_channel = [folder_video, '\channel_', num2str(channel_index), '_', para_chan.channel_type];
        mkdir(folder_channel);
        
        %loop for each channel for each video
        for loop_counter = 1 : para_setting.conf.loop_number
            flag_stop = get(hObject, 'UserData');
            while (flag_stop == 1)
                drawnow %drawnow is very important to let GUI button can accept click event
                flag_stop = get(hObject, 'UserData');
                %guidata(hObject, handles);
            end
            output_message(sprintf('Start the %dth loop', loop_counter));
            trace_file(sprintf('Start the %dth loop', loop_counter));
            folder_loop = [folder_channel, '\loop_', num2str(loop_counter)];
            mkdir(folder_loop);

            [statistic, distortion] = main_loop(para_conf, para_image, para_chan, para_advan);

            %It is better to put assumption_verify function here, since
            %both main_loop and assumption_verify are memory consuming
            if(channel_index == 1 & loop_counter == 1)
                assumption_verify(statistic, para_image, para_advan);
            end
            result_loop(loop_counter) = plot_result(statistic, distortion, para_image, para_chan, para_advan);
        end
        plot_result_all(result_loop, statistic, para_chan);
    end
    time_one_video(video_index) = toc - time_one_video_begin;
    trace_file(sprintf('Processing time for the %dth video sequence is: %g seconds', video_index, time_one_video(video_index)));
end
elapse_time = toc;
trace_file(sprintf('Processing time for all video sequences are: %g seconds', elapse_time));
trace_file('Processing time for each video sequence is: ');
trace_file(sprintf('%g seconds, ', time_one_video));
fclose(f_debug);





function plot_result_all(result_loop, statistic, para_chan)

global folder_channel
global video_name
global channel_index

loop_number = length(result_loop);
frame_number = length(statistic);

rec_Y_sum = 0;
rec_Y_H264_sum = 0;
rec_Y_JM_trial_sum = 0;
alg1_Y_pred_sum = 0;
alg2_Y_pred_sum = 0;
alg3_Y_pred_sum = 0;
alg4_Y_pred_sum = 0;
alg5_Y_pred_sum = 0;
alg6_Y_pred_sum = 0;
for loop_counter = 1:loop_number
    rec_Y_sum = rec_Y_sum + result_loop(loop_counter).rec_Y;
    rec_Y_H264_sum = rec_Y_H264_sum + result_loop(loop_counter).rec_Y_H264;
    rec_Y_JM_trial_sum = rec_Y_JM_trial_sum + result_loop(loop_counter).rec_Y_JM_trial;
    alg1_Y_pred_sum = alg1_Y_pred_sum + result_loop(loop_counter).alg1_Y_pred;
    alg2_Y_pred_sum = alg2_Y_pred_sum + result_loop(loop_counter).alg2_Y_pred;
    alg3_Y_pred_sum = alg3_Y_pred_sum + result_loop(loop_counter).alg3_Y_pred;
    alg4_Y_pred_sum = alg4_Y_pred_sum + result_loop(loop_counter).alg4_Y_pred;
    alg5_Y_pred_sum = alg5_Y_pred_sum + result_loop(loop_counter).alg5_Y_pred;
    alg6_Y_pred_sum = alg6_Y_pred_sum + result_loop(loop_counter).alg6_Y_pred;
end
rec_Y_mean = rec_Y_sum ./ loop_number;
rec_Y_H264_mean = rec_Y_H264_sum ./ loop_number;
rec_Y_JM_trial_mean = rec_Y_JM_trial_sum ./ loop_number;
alg1_Y_pred_mean = alg1_Y_pred_sum ./ loop_number;
alg2_Y_pred_mean = alg2_Y_pred_sum ./ loop_number;
alg3_Y_pred_mean = alg3_Y_pred_sum ./ loop_number;
alg4_Y_pred_mean = alg4_Y_pred_sum ./ loop_number;
alg5_Y_pred_mean = alg5_Y_pred_sum ./ loop_number;
alg6_Y_pred_mean = alg6_Y_pred_sum ./ loop_number;

trace_file(sprintf('%d, ', rec_Y_mean) );
trace_file(sprintf('%d, ', rec_Y_H264_mean) );
trace_file(sprintf('%d, ', rec_Y_JM_trial_mean) );
trace_file(sprintf('%d, ', alg1_Y_pred_mean) );
trace_file(sprintf('%d, ', alg2_Y_pred_mean) );
trace_file(sprintf('%d, ', alg3_Y_pred_mean) );
trace_file(sprintf('%d, ', alg4_Y_pred_mean) );
trace_file(sprintf('%d, ', alg5_Y_pred_mean) );
trace_file(sprintf('%d, ', alg6_Y_pred_mean) );



h = figure; hold on;
plot(rec_Y_mean, 'b');
plot(rec_Y_H264_mean, 'b--');
plot(rec_Y_JM_trial_mean, 'b-.');
plot(alg1_Y_pred_mean, 'c');
plot(alg2_Y_pred_mean, 'm');
plot(alg3_Y_pred_mean, 'y');
plot(alg4_Y_pred_mean, 'k');
plot(alg5_Y_pred_mean, 'g');
plot(alg6_Y_pred_mean, 'r');
legend('b: real, c: alg1, m: alg2, y: alg3, k: alg4, g: alg5, r: alg6', 'Location', 'North');
%legend('True', 'Predicted', 'Location', 'North');
xlabel('frame index', 'fontsize',12, 'fontweight','b');
ylabel('SSE distortion', 'fontsize',12, 'fontweight','b');
title('Transmission distortion', 'fontsize',12, 'fontweight','b');
%print(h, '-depsc', sprintf('%s\\%s_all_%d-%d_SSE', folder_video, video_name, index(1), index(end) ));
saveas(h, sprintf('%s\\%s_channel_%d_SSE', folder_channel, video_name, channel_index ), 'fig');
close(h);

%plot_PSNR
peak_pixel_value = 255;

psnr_rec_Y = 10*log10(peak_pixel_value^2./rec_Y_mean);
psnr_rec_Y_H264 = 10*log10(peak_pixel_value^2./rec_Y_H264_mean);

psnr_difference = psnr_rec_Y - psnr_rec_Y_H264;

h = figure; hold on;
plot(psnr_rec_Y, 'b');
plot(psnr_rec_Y_H264, 'b--');
plot(psnr_difference, 'b-.');

legend('Our reconstruction method', 'JM''s reconstruction method', 'PSNR gain', 'Location', 'North');
xlabel('frame index', 'fontsize',12, 'fontweight','b');
ylabel('PSNR', 'fontsize',12, 'fontweight','b');
title('Transmission distortion', 'fontsize',12, 'fontweight','b');
%print(h, '-depsc', sprintf('%s\\%s_all_%d-%d_PSNR', folder_video, video_name, index(1), index(end) ));
saveas(h, sprintf('%s\\%s_channel_%d_PSNR', folder_channel, video_name, channel_index ), 'fig');
close(h);

%plot gain
ratio = rec_Y_H264_mean./rec_Y_mean;

for frame_no = 1: frame_number
    Y_whole_resi_MSE(frame_no) = statistic(frame_no).Y.whole_frame.residue_MSE;
    Y_whole_conc_MSE(frame_no) = statistic(frame_no).Y.whole_frame.concealment_error_MSE;
    switch para_chan.channel_type
        case 'R'
            PER_A = para_chan.input_DPA;
            PER_B = para_chan.input_DPB;
            PER_C = para_chan.input_DPC;
            ratio_pred(frame_no) = 1 + sum(Y_whole_resi_MSE(1:frame_no))/(PER_C / PER_A * sum(Y_whole_resi_MSE(1:frame_no)) + sum(Y_whole_conc_MSE(1:frame_no)));
        case 'D'
            PER_A = 0;
            PER_B = 0;
            PER_C = 0;
            ratio_pred(frame_no) = 1;
        otherwise
            output_message('Warning: unknown channel type');
    end

end


h = figure; hold on;
plot(ratio, 'b');
plot(ratio_pred, 'b--');
% plot(ratio_pred_2, 'b-.');

% legend('ratio', 'ratio_pred_1', 'ratio_pred_2', 'Location', 'North');
legend('true ratio gain', 'analytical ratio gain', 'Location', 'North');
xlabel('frame index', 'fontsize',12, 'fontweight','b');
ylabel('reconstructed gain', 'fontsize',12, 'fontweight','b');
title('Transmission distortion', 'fontsize',12, 'fontweight','b');
%print(h, '-depsc', sprintf('%s\\%s_all_%d-%d_gain', folder_video, video_name, index(1), index(end) ));
saveas(h, sprintf('%s\\%s_channel_%d_gain', folder_channel, video_name, channel_index ), 'fig');
close(h);