%--------------------------------------------------------------------------
%this function is used to get the resolution based on the certain naming
%format in the filename, such as: foreman_cif.yuv
%
%Chen Zhifeng
%UFID 12181197
%2008-07-26
%zhifeng@ecel.ufl.edu
%--------------------------------------------------------------------------
function [image_width, image_height, resolution, format_error] = get_resolution(video_name)

format_error = 0;
image_width = 0;
image_height = 0;
resolution = 'unknown';

pos_underline = findstr(video_name,'_');
if(length(pos_underline) < 1)
    format_error = 1;
    return
end
resolution = video_name(pos_underline(end)+1:end-4); %4 means '.yuv'
% pos_dot = findstr(video_name,'.');
% if(length(pos_dot) ~= 1)
%     error('please input the rigth video name, for example: foreman_cif.yuv');
% end
% resolution = video_name(pos_underline+1:pos_dot-1);

switch resolution
    case 'cif'
        image_width = 352;  
        image_height = 288;    
    case 'qcif'
        image_width = 176;  
        image_height = 144;    
    case 'vga'
        image_width = 640; 
        image_height = 480;
    case 'qvga'
        image_width = 320;
        image_height = 240;
    otherwise
        format_error = 1;
end
