%--------------------------------------------------------------------------
%this function is to get Y, U and V components information for residue data
%
%Chen Zhifeng
%UFID 12181197
%2008-07-17
%zhifeng@ecel.ufl.edu
%--------------------------------------------------------------------------
function residue = get_residue_single(f_handle, frame_no, para_image)
%residue is a four dimension matrix: first dimension is pixel, second
%dimension is line, third dimension is color, fourth dimension is frame no
image_width = para_image.width;
image_height = para_image.height;
subsampling = para_image.subsampling;
dq_bits = 6; %same as the DQ_BITS defined in defines.h

switch subsampling
    case '4:2:0'
        image_widthUV = image_width / 2;  %image_widthUV may be put in the global variable
        image_heightUV = image_height / 2;    %image_heightUV may be put in the global variable
        up_sampling = [1,1;1,1];
    otherwise
        output_message('Warning: unknown subsampling format');
end


%read residue data
file_offset = (frame_no - 1) * (image_width * image_height + 2 * image_widthUV * image_heightUV) * 2;  %2 is for int16
fseek(f_handle, file_offset, 'bof'); % search f_residue position, compatiable for later usage not beginning from first frame


% read Y component
buf_Y = fread(f_handle, image_width * image_height, 'int16');    %residue data is saved in signed short type
% read U component
buf_U = fread(f_handle, image_widthUV * image_heightUV, 'int16');    %residue data is saved in signed short type
% read V component
buf_V = fread(f_handle, image_widthUV * image_heightUV, 'int16');    %residue data is saved in signed short type

if(frame_no ~= 1)   %for non-idr frame
    buf_Y = rshift_rnd_sf(buf_Y, dq_bits);
    buf_U = rshift_rnd_sf(buf_U, dq_bits);
    buf_V = rshift_rnd_sf(buf_V, dq_bits);
end

residue(:, :, 1) = reshape(buf_Y, image_width, image_height); % reshape
residue(:, :, 2) = kron(reshape(buf_U, image_widthUV, image_heightUV), up_sampling); % reshape
residue(:, :, 3) = kron(reshape(buf_V, image_widthUV, image_heightUV), up_sampling); % reshape





function ret = rshift_rnd_sf(data, bit_shifted)
%this functionis same as the rshift_rnd_sf() function in JM
%return ((x + (1 << (a-1) )) >> a);

%ret = round(data ./ (2^bit_shifted) ); 
%do not use round()!!, since round(-0.5)is -1 not 0!!! should use floor(x/64+0.5)

%temp = data + bitshift(1, bit_shifted-1);
%ret = bitshift(temp, -bit_shifted);
%do not use bitshift!!, since bitshift((-80+32), -6)=0!!! should use floor(x/64+0.5)

ret = floor(data/(2^bit_shifted)+0.5);  %spend several hours on JM code and produced file to get this conclusion!