%--------------------------------------------------------------------------
%this function is to get Y, U and V components information in a YUV file 
%
%Chen Zhifeng
%UFID 12181197
%2008-10-03
%zhifeng@ecel.ufl.edu
%--------------------------------------------------------------------------
function reconstruction = get_reconstruction_single(f_handle, frame_no, para_image)

%global frame_number;
image_width = para_image.width;
image_height = para_image.height;
subsampling = para_image.subsampling;

switch subsampling
    case '4:2:0'
        image_widthUV = image_width / 2;  %image_widthUV may be put in the global variable
        image_heightUV = image_height / 2;    %image_heightUV may be put in the global variable
        up_sampling = [1,1;1,1];
    otherwise
        disp('unknown subsampling format');
end


%read reconstruction data
file_offset = (frame_no - 1) * (image_width * image_height + 2 * image_widthUV * image_heightUV);
fseek(f_handle, file_offset, 'bof'); % search f_residue position, compatiable for later usage not beginning from first frame


% read Y component
buf_Y = fread(f_handle, image_width * image_height, 'uint8');    %residue data is saved in signed short type
% read U component
buf_U = fread(f_handle, image_widthUV * image_heightUV, 'uint8');    %residue data is saved in signed short type
% read V component
buf_V = fread(f_handle, image_widthUV * image_heightUV, 'uint8');    %residue data is saved in signed short type

reconstruction(:, :, 1) = reshape(buf_Y, image_width, image_height); % reshape
reconstruction(:, :, 2) = kron(reshape(buf_U, image_widthUV, image_heightUV), up_sampling); % reshape
reconstruction(:, :, 3) = kron(reshape(buf_V, image_widthUV, image_heightUV), up_sampling); % reshape



