%--------------------------------------------------------------------------
%this function is to get the MV information for a video sequence
%note that MV should be divided by 4 to get integer resolution
%
%Chen Zhifeng
%UFID 12181197
%2008-07-17
%zhifeng@ecel.ufl.edu
%--------------------------------------------------------------------------
function MV = get_MV_single(f_MV, frame_no, para_image)

global block_size; %the minimum block for one motion vector

image_width = para_image.width;
image_height = para_image.height;
subpel_ME = para_image.subpel_ME;

block_number_row = image_width/block_size;
block_number_col = image_height/block_size;

%read motion vectors
file_offset = (frame_no - 1) * (block_number_row * block_number_col) * 4;  %4 is for motion vector x and motion vector y
fseek(f_MV, file_offset, 'bof'); % search f_MV position, compatiable for later usage not beginning from first frame

buf_MV = fread(f_MV, 2 * block_number_row * block_number_col, 'int16');
MV = reshape(buf_MV, 2, block_number_row, block_number_col);   %MV is four dimensional

switch subpel_ME
    case 1
        %refer to BlockMotionSearch() in search.c in JM14.0
        MV = floor((MV+2)/4);  %due to the integer pixel search; MV[0] = (pred_MV[0] + 2)>>2;
    otherwise
        output_message('Warning: unknown subpel format for motion estimation');
end
