%--------------------------------------------------------------------------
%this function is to map error flag for each pixel, block, or macroblock
%according to different resolution requirement, and support FMO setting
%
%Chen Zhifeng
%UFID 12181197
%2008-07-17
%zhifeng@ecel.ufl.edu
%--------------------------------------------------------------------------
function [error_residue_flag, error_MV_flag] = error_map(packetA_error_flag_one_frame, packetC_error_flag_one_frame, para_image)

global MB_size;

image_width = para_image.width;
image_height = para_image.height;
MB_per_slice = para_image.MB_per_slice;
FMO_type = para_image.FMO_type;

%we may use different resolution for the error flag: MB based, block based,
%or pixel based
error_resolution = 0;   %0: MB based, 1: block based, 2: pixel based

MB_number_row = image_width/MB_size;
MB_number_col = image_height/MB_size;

%up_sampling_block = ones(block_size);
up_sampling_MB = ones(MB_size);

%slice to macroblock mapping
switch FMO_type
    case 0
        error_MB_residue_flag = kron(packetC_error_flag_one_frame, ones(1, MB_per_slice));
        error_MB_residue_flag = reshape(error_MB_residue_flag, MB_number_row, MB_number_col);
        error_MB_MV_flag = kron(packetA_error_flag_one_frame, ones(1, MB_per_slice));
        error_MB_MV_flag = reshape(error_MB_MV_flag, MB_number_row, MB_number_col);

    otherwise
        disp('FMO_type unknown');
end

switch error_resolution
    case 0
        %macroblock to pixel upsampling
        error_residue_flag = kron(error_MB_residue_flag, up_sampling_MB);
        error_MV_flag = kron(error_MB_MV_flag, up_sampling_MB);

    otherwise
        disp('FMO_type unknown');
end


