%--------------------------------------------------------------------------
%this function is to compress yuv file into 264 stream file by JM encoder
%
%Chen Zhifeng
%UFID 12181197
%2008-07-17
%zhifeng@ecel.ufl.edu
%--------------------------------------------------------------------------
function encoder_JM(video_name, para_image)

global folder_video
global folder_encoder
global filename_residue %just for the main_loop function
global filename_MV
global filename_264   %just for the channel_for_h264 function in main_loop
global filename_packet_length   %just for the channel_for_h264 function in main_loop
global filename_JM_rec_enc;     %just for the decoder_JM function and main_loop function

filename_MV = 'MV.dat';
filename_residue = 'residue.dat';
filename_packet_length = 'packet.txt';
filename_264 = 'test.264';
filename_JM_rec_enc = 'test_rec.yuv';

folder_encoder = [folder_video, '\JM_encoder'];
mkdir(folder_encoder);

trace_file('begin encoding');

current_directory = cd;
cd ..\bin

encoder_para = ['lencod',...
    ' -p InputFile="', video_name, '"',...
    ' -p FramesToBeEncoded=', num2str(para_image.frame_number),...
    ' -p StartFrame=', num2str(para_image.frame_offset),...
    ' -p SourceWidth=', num2str(para_image.width),...
    ' -p SourceHeight=', num2str(para_image.height),...
    ' -p SliceArgument=', num2str(para_image.MB_per_slice)];

dos(encoder_para);

%we may need to change the new_folder relative path if source_code and bin
%is not under the same directory
dos(['move ', filename_MV, ' ', folder_encoder]);
dos(['move ', filename_residue, ' ', folder_encoder]);
dos(['move ', filename_packet_length, ' ', folder_encoder]);
dos(['move ', filename_264, ' ', folder_encoder]);
dos(['move ', filename_JM_rec_enc, ' ', folder_encoder]);   %this file is needed multi times by decoder_JM

cd (current_directory)

trace_file('finish encoding');


