%--------------------------------------------------------------------------
%this function is to reconstruct the image after a lossy channel
%should be careful to the same variable name for input and output,
%so if no value is return, the input will be return
%
%Chen Zhifeng
%UFID 12181197
%2008-07-17
%zhifeng@ecel.ufl.edu
%--------------------------------------------------------------------------
function [img_reconstructed_receiver, img_reconstructed_receiver_H264, img_reconstructed_receiver_bw] = decoder(img_last_receiver, img_last_receiver_H264, residue_one_frame_receiver, MV_one_frame_receiver, error_residue_flag, error_MV_flag, para_image, frame_no)

image_width = para_image.width;
image_height = para_image.height;

%The error concealment algorithm in my paper
img_predicted_receiver = motion_compensation(img_last_receiver, MV_one_frame_receiver, para_image);    %subsampling, block_size, block_number_row, block_number_col, image_width, image_height are global variables
img_reconstructed_receiver = img_predicted_receiver + residue_one_frame_receiver;
img_reconstructed_receiver = clip_pixel_value( img_reconstructed_receiver, frame_no, 'decoder_mine' ); %it is same as the iClip1 function in JM

%To simulate the error concealment algorithm in reconstruction used by
%JM14.0
img_predicted_receiver_H264 = motion_compensation(img_last_receiver_H264, MV_one_frame_receiver, para_image);    %subsampling, block_size, block_number_row, block_number_col, image_width, image_height are global variables
img_reconstructed_receiver_H264(:,:,1) = img_predicted_receiver_H264(:,:,1) + residue_one_frame_receiver(:,:,1).*~error_MV_flag;
img_reconstructed_receiver_H264(:,:,2) = img_predicted_receiver_H264(:,:,2) + residue_one_frame_receiver(:,:,2).*~error_MV_flag;
img_reconstructed_receiver_H264(:,:,3) = img_predicted_receiver_H264(:,:,3) + residue_one_frame_receiver(:,:,3).*~error_MV_flag;
img_reconstructed_receiver_H264 = clip_pixel_value( img_reconstructed_receiver_H264, frame_no, 'decoder_H264' ); %it is same as the iClip1 function in JM

%To give a visual effect about which slice have error in current frame.
WHITE = 255;    %only residue data lost
GRAY = 127;     %only motion vector lost
BLACK = 0;      %both residue data and motion vector lost

error_flag_AND = error_residue_flag & error_MV_flag;
error_flag_OR = error_residue_flag | error_MV_flag;

location_resi_display = zeros(image_width, image_height);
location_resi = find(error_residue_flag-error_flag_AND == 1);
location_resi_display(location_resi) = location_resi_display(location_resi) + WHITE;

location_conc_display = zeros(image_width, image_height);
location_conc = find(error_MV_flag-error_flag_AND == 1);
location_conc_display(location_conc) = location_conc_display(location_conc) + GRAY;

location_both_display = zeros(image_width, image_height);
location_both = find(error_flag_AND == 1);
location_both_display(location_both) = location_both_display(location_both) + BLACK;

location_display = location_resi_display + location_conc_display + location_both_display;

img_reconstructed_receiver_bw(:,:,1) = img_reconstructed_receiver(:,:,1).*~error_flag_OR + location_display;
% img_reconstructed_receiver_bw(:,:,2) = img_reconstructed_receiver(:,:,2);
% img_reconstructed_receiver_bw(:,:,3) = img_reconstructed_receiver(:,:,3);
img_reconstructed_receiver_bw(:,:,2) = img_reconstructed_receiver(:,:,2).*~error_flag_OR + location_display;
img_reconstructed_receiver_bw(:,:,3) = img_reconstructed_receiver(:,:,3).*~error_flag_OR + location_display;

%because the uint8 type can not product with logic type, so put
%clip_pixel_value, which include uint8 function, here
%img_reconstructed_receiver = clip_pixel_value( img_reconstructed_receiver ); %it is same as the iClip1 function in JM
%img_reconstructed_receiver_bw = clip_pixel_value( img_reconstructed_receiver_bw ); %it is same as the iClip1 function in JM

end