%--------------------------------------------------------------------------
%this function is a tool used to compare two files
%if length equal to 0, two files are compare from begin to end
%
%Chen Zhifeng
%UFID 12181197
%2008-07-17
%zhifeng@ecel.ufl.edu
%--------------------------------------------------------------------------
function diff_num = compare_file(filename1, filename2, length)

diff_num = 0;

f1 = fopen(filename1, 'r');
f2 = fopen(filename2, 'r');

[buf1, count1] = fread(f1, 'uchar=>uchar');
[buf2, count2] = fread(f2, 'uchar=>uchar');

if (length>count1 | length>count2)  %length is too large
    output_message(sprintf('Warning: at least one file length is not enough, 1st file length: %d bytes, 2nd file length: %d bytes', count1, count2));
elseif length == 0 %two files are compare from begin to end
    if count1~=count2
        output_message(sprintf('Warning: lengths of two files are different, 1st file length: %d bytes, 2nd file length: %d bytes', count1, count2));
    else
        trace_file(sprintf('Lengths of two files are: %d bytes', count1));
        for i = 1:count1
            if buf1(i)~=buf2(i)
                diff_num = diff_num + 1;
                trace_file(sprintf('The %dth difference located at %dth byte: %X(%d) in file1, %X(%d) in file2', diff_num, i, buf1(i), buf1(i), buf2(i), buf2(i)));
            end
        end
        %output_message(sprintf('Warning: there are %d differences between %s and %s, please check trace file for details', diff_num, filename1, filename2));
    end
else    %compare two files with the specified length
    for i = 1:length
        if buf1(i)~=buf2(i)
            diff_num = diff_num + 1;
            trace_file(sprintf('the %dth difference located at %dth byte: %X(%d) in file1, %X(%d) in file2', diff_num, i, buf1(i), buf1(i), buf2(i), buf2(i)));
        end
    end
    %output_message(sprintf('Warning: there are %d differences between %s and %s, please check trace file for details', diff_num, filename1, filename2));
end
    
fclose(f1);
fclose(f2);

