%--------------------------------------------------------------------------
%this function is to clip the pixel value for display
%
%Chen Zhifeng
%UFID 12181197
%2008-07-17
%zhifeng@ecel.ufl.edu
%--------------------------------------------------------------------------
function ret = clip_pixel_value( pixel, frame_no, string )
%codec = 'encoder' or 'decoder'
show_coordinate = 0;  

[dim_1, dim_2, dim_3] = size(pixel);
for component = 1:dim_3 
    trace_file([string, sprintf(': clipping %dth component in the %dth frame:', component, frame_no)]);
    pixel_component = pixel(:, :, component);
    if show_coordinate
        [row, col] = find(pixel_component<0);
        len_under = length(row);    %row and col are in the same length
        if (len_under>0)
            trace_file([string, sprintf(': there are %d pixel value smaller than 0. To be truncated as 0', len_under)]);
            for index = 1 : len_under
                trace_file(sprintf('(%d, %d) = %d', row(index), col(index), pixel_component(row(index), col(index))));
                pixel_component(row(index), col(index)) = 0;
            end
        end
        [row, col] = find(pixel_component>255);
        len_over = length(row);    %row and col are in the same length
        if (len_over>0)
            trace_file([string, sprintf(': there are %d pixel value larger than 255. To be truncated as 255', len_over)]);
            for index = 1 : len_over
                trace_file(sprintf('(%d, %d) = %d', row(index), col(index), pixel_component(row(index), col(index))));
                pixel_component(row(index), col(index)) = 255;
            end
        end
    else
        pixel_component = reshape(pixel_component, dim_1*dim_2, 1);
        pixel_component = clip_vector(pixel_component, string);
        pixel_component = reshape(pixel_component, dim_1, dim_2);
    end
    ret(:, :, component) = pixel_component;
end

% [A, B, C] = size(pixel);
% buf = reshape(pixel, A*B*C, 1);
% if (min(buf)<0 | max(buf)>255)
%    trace_file('truncate some pixels to 0~255');
%    buf = min(max(buf, 0), 255);
% end
% ret = reshape(buf, A, B, C);