%--------------------------------------------------------------------------
%this function is to get the residue data and motion vector after pass a lossy
%channel, which includes quantization and transform and their inverse
%
%Chen Zhifeng
%UFID 12181197
%2008-07-17
%zhifeng@ecel.ufl.edu
%--------------------------------------------------------------------------
function [residue_one_frame_receiver, MV_one_frame_receiver] = channel_simulation(residue_one_frame, MV_one_frame, error_residue_flag, error_MV_flag, para_image)

global block_size; %the minimum block for one motion vector

image_width = para_image.width;
image_height = para_image.height;

block_number_row = image_width/block_size;
block_number_col = image_height/block_size;

%[error_residue_flag, error_MV_flag] = error_map(packetA_error_flag_one_frame, packetC_error_flag_one_frame);
residue_one_frame_receiver(1:image_width, 1:image_height, 1) = residue_one_frame(1:image_width, 1:image_height, 1).*~error_residue_flag;
residue_one_frame_receiver(1:image_width, 1:image_height, 2) = residue_one_frame(1:image_width, 1:image_height, 2).*~error_residue_flag;
residue_one_frame_receiver(1:image_width, 1:image_height, 3) = residue_one_frame(1:image_width, 1:image_height, 3).*~error_residue_flag;

error_MV_flag_downsampling = error_MV_flag(1:block_size:image_width, 1:block_size:image_height);
MV_one_frame_x = reshape(MV_one_frame(1, 1:block_number_row, 1:block_number_col), block_number_row, block_number_col);
MV_one_frame_receiver(1, 1:block_number_row, 1:block_number_col) = MV_one_frame_x.*~error_MV_flag_downsampling;
MV_one_frame_y = reshape(MV_one_frame(2, 1:block_number_row, 1:block_number_col), block_number_row, block_number_col);
MV_one_frame_receiver(2, 1:block_number_row, 1:block_number_col) = MV_one_frame_y.*~error_MV_flag_downsampling;


