%--------------------------------------------------------------------------
%this function is to set channels including test channel and random channel
%
%Chen Zhifeng
%UFID 12181197
%2008-07-17
%zhifeng@ecel.ufl.edu
%--------------------------------------------------------------------------
function [packetA_error_flag, packetC_error_flag] = channel_setting(para_chan, frame_number, slice_per_frame)

global folder_MATLAB

frame_number_P = frame_number - 1; %the first IDR frame do not need motion vectors and packets lost are counted based on frame_number_P
slice_number_P = frame_number_P * slice_per_frame;

switch para_chan.channel_type
    case 'R'
        %set the packet error flag according to the feed back
        packetA_error_flag = rand(1, slice_number_P) < para_chan.input_DPA;
        packetC_error_flag = rand(1, slice_number_P) < para_chan.input_DPC;
    case 'D'
        packetA_error_flag = test_channel_slice_P(para_chan.input_DPA, slice_number_P);
        packetC_error_flag = test_channel_slice_P(para_chan.input_DPC, slice_number_P);
    otherwise
        output_message('Warning: unknown channel type');
end

filename_error_resi = 'error_resi.txt';
f_error_resi = fopen([folder_MATLAB, '\', filename_error_resi], 'w');
fprintf(f_error_resi, '%d, ', packetC_error_flag );
fclose(f_error_resi);

filename_error_conc = 'error_conc.txt';
f_error_conc = fopen([folder_MATLAB, '\', filename_error_conc], 'w');
fprintf(f_error_conc, '%d, ', packetA_error_flag );
fclose(f_error_conc);


       
function packet_error_flag = test_channel_slice_P(lost_slice_no, slice_number)
%lost_slice_no can be a vector

packet_error_flag = zeros(1, slice_number);

if(lost_slice_no(end) > slice_number)
    index = find(lost_slice_no <= slice_number);
    lost_slice_no = lost_slice_no(index);
    output_message(sprintf('Warning: total P slice number is only %d, the number of lost slice is truncated', slice_number));
end

index = find(lost_slice_no ~= 0);
lost_slice_no = lost_slice_no(index);
packet_error_flag(lost_slice_no) = 1;


