%--------------------------------------------------------------------------
%this function is to get the 264 stream file after pass a lossy channel
%
%Chen Zhifeng
%UFID 12181197
%2008-07-17
%zhifeng@ecel.ufl.edu
%--------------------------------------------------------------------------
function filename_264_lost = channel_for_h264(frame_number, slice_per_frame, packetA_error_flag, packetC_error_flag)

global folder_encoder
global folder_MATLAB
global filename_264   %initialized in the encoder_JM function
global filename_packet_length   %initialized in the encoder_JM function

f_264 = fopen([folder_encoder, '\', filename_264], 'r');
f_packet_length = fopen([folder_encoder, '\', filename_packet_length], 'r');

filename_264_lost = 'test_lost.264';
f_264_lost = fopen([folder_MATLAB, '\', filename_264_lost], 'w');

%frame_IDR = 1;
%packet_number = 1;

for frame_no = 1:frame_number
    if(frame_no == 1)	%1 should be change if frame_IDR is defined
        buf_SPS = read_one_packet(f_264, f_packet_length);
        count = fwrite(f_264_lost, buf_SPS, 'uint8');

        buf_PPS = read_one_packet(f_264, f_packet_length);
        count = fwrite(f_264_lost, buf_PPS, 'uint8');

        for slice_no = 1:slice_per_frame
            buf_IDR = read_one_packet(f_264, f_packet_length);
            count = fwrite(f_264_lost, buf_IDR, 'uint8');
        end
    %begin processing p-frames
    else
        frame_no_P = frame_no - 1;
        for slice_no = 1:slice_per_frame
            buf_A = read_one_packet(f_264, f_packet_length);
            if(packetA_error_flag((frame_no_P-1)*slice_per_frame + slice_no) == 0)
                count = fwrite(f_264_lost, buf_A, 'uint8');
            end
            
            buf_C = read_one_packet(f_264, f_packet_length);
            if(packetC_error_flag((frame_no_P-1)*slice_per_frame + slice_no) == 0)
                count = fwrite(f_264_lost, buf_C, 'uint8');
            end
        end
    end
end


fclose(f_264);
fclose(f_packet_length);
fclose(f_264_lost);



function buf = read_one_packet(f_264, f_packet_length)

packet_length = read_one_packet_length(f_packet_length);
buf = fread(f_264, packet_length, 'uint8');    %h264 data is saved in unsigned byte type


function packet_length = read_one_packet_length(f_packet_length)

[packet_length, count] = fscanf(f_packet_length, '%d', 1);
if (count == 0)
    output_message('Error: the read packet length of file operation is not work');
end
[s, count] = fscanf(f_packet_length, '%s', 1);   %comma and tab
if (count == 0)
    output_message('Error: the read comma and tab of file operation is not work');
end
