%--------------------------------------------------------------------------
%this function is used to verify all my assumptions in the paper. Please
%see the verify_assumption_and_predict_distortion for more information
%about assumptions
%
%Chen Zhifeng
%UFID 12181197
%2008-07-17
%zhifeng@ecel.ufl.edu
%--------------------------------------------------------------------------
function assumption_verify(statistic, para_image, para_advan)

%basic statistics
disp_BS = para_advan.disp_BS;
disp_BS_for_each_frame = para_advan.disp_BS_for_each_frame;

%correlation coefficient
disp_CC = para_advan.disp_CC;
disp_CC_for_each_frame = para_advan.disp_CC_for_each_frame;

%joint pdf
disp_JP = para_advan.disp_JP;
disp_JP_for_each_frame = para_advan.disp_JP_for_each_frame;

%conditional pdf
disp_CP = para_advan.disp_CP;
disp_CP_for_each_frame = para_advan.disp_CP_for_each_frame;

if(disp_BS)
    plot_prop_factor(statistic);
    plot_mean(statistic);
    plot_MSE(statistic);
    plot_MSE_recon(statistic);
    plot_corr_coef(statistic);
    histogram_MV_length(statistic, disp_BS_for_each_frame);
    histogram_resi(statistic, disp_BS_for_each_frame);
    histogram_resi_clip(statistic, disp_BS_for_each_frame);
    histogram_resi_prop_clip(statistic, disp_BS_for_each_frame);

    histogram_conc(statistic, disp_BS_for_each_frame);
    histogram_conc_clip(statistic, disp_BS_for_each_frame);
    histogram_conc_prop_clip(statistic, disp_BS_for_each_frame);

    histogram_both(statistic, disp_BS_for_each_frame);
    histogram_both_prop_clip(statistic, disp_BS_for_each_frame);

    histogram_delta_Nr_Nm_Nq(statistic, disp_BS_for_each_frame);
    histogram_delta_Nr_m_Nq(statistic, disp_BS_for_each_frame);
    histogram_delta_Nr_Nm_qResi(statistic, para_image, disp_BS_for_each_frame);  %MV
    histogram_delta_Nr_m_qResi(statistic, disp_BS_for_each_frame); %E[MV]
    histogram_delta_Nr_Nm_qConc(statistic, para_image, disp_BS_for_each_frame);
    histogram_delta_Nr_m_qConc(statistic, disp_BS_for_each_frame);
    histogram_delta_Nr_Nm_pBoth(statistic, para_image, disp_BS_for_each_frame);
    histogram_delta_Nr_m_pBoth(statistic, disp_BS_for_each_frame); %only the precious frame has error
    histogram_delta_Nr_m_pBoth_lastminusfirst(statistic, disp_BS_for_each_frame);    %all frames have errors, last frame minus first frame

    histogram_recon(statistic, disp_BS_for_each_frame);
end

if(disp_CC)
    CC_temporal_resi_conc(statistic);
    CC_temporal_align_resi_conc(statistic, para_image);
    %CC_temporal_align_test_resi_conc(statistic, para_image);
    CC_spatial_resi_conc(statistic, para_image, disp_CC_for_each_frame);
end

if(disp_JP)
    JP_MV_x_MV_y(statistic, disp_JP_for_each_frame);
    JP_resi_conc(statistic, disp_JP_for_each_frame);
    JP_resi_pred(statistic, disp_JP_for_each_frame);
    JP_resi_recon(statistic, disp_JP_for_each_frame);
end

if(disp_CP)
    CP_resi_conc(statistic, disp_CP_for_each_frame);
    CP_resi_pred(statistic, disp_CP_for_each_frame);
    CP_resi_recon(statistic, disp_CP_for_each_frame);
end




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function plot_prop_factor(statistic)
%plot mean
global folder_video
global video_name;
global channel_index    %initialized in the main function
global loop_counter;

frame_number = length(statistic);

for frame_no = 1: frame_number
    prop_clip_resi_factor(frame_no) = statistic(frame_no).Y.whole_frame.prop_clip_resi_factor;
    prop_clip_conc_factor(frame_no) = statistic(frame_no).Y.whole_frame.prop_clip_conc_factor;
    prop_clip_both_factor(frame_no) = statistic(frame_no).Y.whole_frame.prop_clip_both_factor;
    
    if frame_no <= 2
        prop_clip_resi_factor_theoretical(frame_no) = 0;
        prop_clip_conc_factor_theoretical(frame_no) = 0;
        prop_clip_both_factor_theoretical(frame_no) = 0;
    else
        prop_clip_resi_factor_theoretical(frame_no) = clipping_factor(statistic(frame_no).Y.whole_frame.reconstructed_mean, (statistic(frame_no-1).Y.whole_frame.residue_MSE/2)^0.5);
        prop_clip_conc_factor_theoretical(frame_no) = clipping_factor(statistic(frame_no).Y.whole_frame.reconstructed_mean, (statistic(frame_no-1).Y.whole_frame.concealment_error_MSE/2)^0.5);
        prop_clip_both_factor_theoretical(frame_no) = clipping_factor(statistic(frame_no).Y.whole_frame.reconstructed_mean, (statistic(frame_no-1).Y.whole_frame.both_error_MSE/2)^0.5);
    end
end
h = figure; hold on;
plot(prop_clip_resi_factor, 'b');
plot(prop_clip_conc_factor, 'b--');
plot(prop_clip_both_factor, 'b-.');
plot(prop_clip_resi_factor_theoretical, 'r');
plot(prop_clip_conc_factor_theoretical, 'r--');
plot(prop_clip_both_factor_theoretical, 'r-.');
legend('prop_clip_resi_factor', 'prop_clip_conc_factor', 'prop_clip_both_factor', 'Location', 'North');
xlabel('frame index');
ylabel('propagation factor');
title('Propagation factor for different variables');
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_mean', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_prop_factor', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)   %To protect GUI by not using close all





%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function plot_mean(statistic)
%plot mean
global folder_video
global video_name;
global channel_index    %initialized in the main function
global loop_counter;

frame_number = length(statistic);

for frame_no = 1: frame_number
    mean_MV_x(frame_no) = statistic(frame_no).MV.whole_frame.x_mean;
    mean_MV_y(frame_no) = statistic(frame_no).MV.whole_frame.y_mean;
    mean_MV_length(frame_no) = mean(statistic(frame_no).MV.whole_frame.length);
    
    mean_resi_Y(frame_no) = statistic(frame_no).Y.whole_frame.residue_mean;
    mean_resi_clip_Y(frame_no) = statistic(frame_no).Y.whole_frame.residue_clip_mean;
    mean_resi_prop_clip_Y(frame_no) = statistic(frame_no).Y.whole_frame.prop_clip_resi_mean;

    mean_conc_Y(frame_no) = statistic(frame_no).Y.whole_frame.concealment_error_mean;
    mean_conc_clip_Y(frame_no) = statistic(frame_no).Y.whole_frame.concealment_error_clip_mean;
    mean_conc_prop_clip_Y(frame_no) = statistic(frame_no).Y.whole_frame.prop_clip_conc_mean;

    mean_both_Y(frame_no) = statistic(frame_no).Y.whole_frame.both_error_mean;
    mean_both_prop_clip_Y(frame_no) = statistic(frame_no).Y.whole_frame.prop_clip_both_mean;

    mean_reconstructed_Y(frame_no) = statistic(frame_no).Y.whole_frame.reconstructed_mean;
end
h = figure; hold on;
plot(mean_MV_length, 'k');
plot(mean_MV_x, 'k--');
plot(mean_MV_y, 'k-.');

%plot(mean_reconstructed_Y - 128, 'y');

plot(mean_resi_Y, 'b');
plot(mean_resi_clip_Y, 'b--');
plot(mean_resi_prop_clip_Y, 'b-.');
plot(mean_conc_Y, 'g');
plot(mean_conc_clip_Y, 'g--');
plot(mean_conc_prop_clip_Y, 'g-.');
plot(mean_both_Y, 'r');
legend('k: motion vector, b: residue, g: concealment error, r: both error', 'Location', 'North');
xlabel('frame index');
ylabel('mean');
title('Mean for different variables');
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_mean', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_mean', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)   %To protect GUI by not using close all




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function plot_MSE(statistic)
%plot MSE
global folder_video
global video_name;
global channel_index    %initialized in the main function
global loop_counter;

frame_number = length(statistic);

for frame_no = 1: frame_number
    var_MV_x(frame_no) = statistic(frame_no).MV.whole_frame.x_var;
    var_MV_y(frame_no) = statistic(frame_no).MV.whole_frame.y_var;
    
    MSE_resi_Y(frame_no) = statistic(frame_no).Y.whole_frame.residue_MSE;
    MSE_resi_clip_Y(frame_no) = statistic(frame_no).Y.whole_frame.residue_clip_MSE;
    MSE_resi_prop_clip_Y(frame_no) = statistic(frame_no).Y.whole_frame.prop_clip_resi_MSE;

    MSE_conc_Y(frame_no) = statistic(frame_no).Y.whole_frame.concealment_error_MSE;
    MSE_conc_clip_Y(frame_no) = statistic(frame_no).Y.whole_frame.concealment_error_clip_MSE;
    MSE_conc_prop_clip_Y(frame_no) = statistic(frame_no).Y.whole_frame.prop_clip_conc_MSE;

    MSE_both_Y(frame_no) = statistic(frame_no).Y.whole_frame.both_error_MSE;
    MSE_both_prop_clip_Y(frame_no) = statistic(frame_no).Y.whole_frame.prop_clip_both_MSE;

    var_reconstructed_Y(frame_no) = statistic(frame_no).Y.whole_frame.reconstructed_var;
end
h = figure; hold on;
plot(var_MV_x, 'k');
plot(var_MV_y, 'k--');

% plot(var_reconstructed_Y, 'y');

plot(MSE_resi_Y, 'b');
plot(MSE_resi_clip_Y, 'b--');
plot(MSE_resi_prop_clip_Y, 'b-.');
plot(MSE_conc_Y, 'g');
plot(MSE_conc_clip_Y, 'g--');
plot(MSE_conc_prop_clip_Y, 'g-.');
plot(MSE_both_Y, 'r');
legend('k: motion vector, b: residue, g: concealment error, r: both error', 'Location', 'North');
xlabel('frame index');
ylabel('MSE');
title('MSE for different variables');
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_MSE', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_MSE', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)   %To protect GUI by not using close all




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function plot_MSE_recon(statistic)
%plot MSE
global folder_video
global video_name;
global channel_index    %initialized in the main function
global loop_counter;

frame_number = length(statistic);

for frame_no = 1: frame_number
    var_pred_Y(frame_no) = statistic(frame_no).Y.whole_frame.predicted_var;
    var_recon_Y(frame_no) = statistic(frame_no).Y.whole_frame.reconstructed_var;
end
h = figure; hold on;

plot(var_pred_Y, 'b');
plot(var_recon_Y, 'b:');
legend('predicted pixel value', 'reconstructed pixel value', 'Location', 'North');
xlabel('frame index');
ylabel('var');
title('var for different variables');
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_MSE', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_var_pred_recon', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)   %To protect GUI by not using close all





%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function plot_corr_coef(statistic)
%plot correlation coefficient
global folder_video
global video_name;
global channel_index    %initialized in the main function
global loop_counter;

frame_number = length(statistic);

for frame_no = 1: frame_number
    rho_MV_x_MV_y(frame_no) = statistic(frame_no).MV.whole_frame.rho_x_y;
    rho_MV_resi_Y(frame_no) = statistic(frame_no).Y.whole_frame.rho_MV_resi;
    rho_MV_conc_Y(frame_no) = statistic(frame_no).Y.whole_frame.rho_MV_conc;

    rho_Y_crcc(frame_no) = statistic(frame_no).Y.whole_frame.rho_curr_resi_curr_conc;
    rho_Y_crlr(frame_no) = statistic(frame_no).Y.whole_frame.rho_curr_resi_last_resi;
    rho_Y_crlc(frame_no) = statistic(frame_no).Y.whole_frame.rho_curr_resi_last_conc;
    rho_Y_cclr(frame_no) = statistic(frame_no).Y.whole_frame.rho_curr_conc_last_resi;
    rho_Y_cclc(frame_no) = statistic(frame_no).Y.whole_frame.rho_curr_conc_last_conc;

    rho_Y_crlr_align(frame_no) = statistic(frame_no).Y.whole_frame.rho_crlr_align;
    rho_Y_crlc_align(frame_no) = statistic(frame_no).Y.whole_frame.rho_crlc_align;
    rho_Y_cclr_align(frame_no) = statistic(frame_no).Y.whole_frame.rho_cclr_align;
    rho_Y_cclc_align(frame_no) = statistic(frame_no).Y.whole_frame.rho_cclc_align;
    
    rho_Y_resi_pred(frame_no) = statistic(frame_no).Y.whole_frame.rho_resi_pred;
    rho_Y_resi_recon(frame_no) = statistic(frame_no).Y.whole_frame.rho_resi_recon;
    rho_Y_resi_pred_estimate(frame_no) = -0.5*(statistic(frame_no).Y.whole_frame.residue_MSE/statistic(frame_no).Y.whole_frame.predicted_var)^.5;
    rho_Y_resi_recon_estimate(frame_no) = 0.5*(statistic(frame_no).Y.whole_frame.residue_MSE/statistic(frame_no).Y.whole_frame.reconstructed_var)^.5;

    rho_Y_curr_conc_pred(frame_no) = statistic(frame_no).Y.whole_frame.rho_curr_conc_pred;
    rho_Y_curr_conc_last_recon(frame_no) = statistic(frame_no).Y.whole_frame.rho_curr_conc_last_recon;
    rho_Y_curr_conc_pred_estimate(frame_no) = 0.5*(statistic(frame_no).Y.whole_frame.concealment_error_MSE/statistic(frame_no).Y.whole_frame.predicted_var)^.5;
    if frame_no == 1
        rho_Y_curr_conc_last_recon_estimate(frame_no) = 0;
    else
        rho_Y_curr_conc_last_recon_estimate(frame_no) = -0.5*(statistic(frame_no).Y.whole_frame.concealment_error_MSE/statistic(frame_no-1).Y.whole_frame.reconstructed_var)^.5;
    end
    
end
h = figure; hold on;
%plot(rho_MV_x_MV_y, 'k');
% plot(rho_MV_resi_Y, 'y:');
% plot(rho_MV_conc_Y, 'y--');

plot(rho_Y_crcc, 'y');
plot(rho_Y_crlr, 'g');
plot(rho_Y_crlr_align, 'g--');    %note that the first residue is reconstructed frame
plot(rho_Y_crlc, 'r');
plot(rho_Y_crlc_align, 'r--');
plot(rho_Y_cclr, 'c');
plot(rho_Y_cclr_align, 'c--');    %note that the first residue is reconstructed frame
plot(rho_Y_cclc, 'm');
plot(rho_Y_cclc_align, 'm--');

plot(rho_Y_resi_pred, 'b');
plot(rho_Y_resi_pred_estimate, 'b--');
plot(rho_Y_resi_recon, 'b-.');
plot(rho_Y_resi_recon_estimate, 'b:');

plot(rho_Y_curr_conc_pred, 'k');
plot(rho_Y_curr_conc_pred_estimate, 'k--');
plot(rho_Y_curr_conc_last_recon, 'k-.');
plot(rho_Y_curr_conc_last_recon_estimate, 'k:');

legend('b: crcc, g: crlr, r: crlc, c: cclr, m: cclc', 'Location', 'North');
xlabel('frame index');
ylabel('rho');
title('Correlation coefficients for different variable pairs');
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_rho', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_rho', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)   %To protect GUI by not using close all





%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function histogram_MV_length(statistic, disp_BS_for_each_frame)

global folder_video
global video_name;
global channel_index    %initialized in the main function
global loop_counter;

frame_number = length(statistic);

if(disp_BS_for_each_frame)
    for frame_no = 1: frame_number
        %motion vector
        h = figure; hist(statistic(frame_no).MV.whole_frame.length, 100);
        title(sprintf('%dth frame MV length histogram, total number: %d', frame_no, length(statistic(frame_no).MV.whole_frame.length) ));
        print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
        close(h)  %for saving memory
    end
end
    
buf_MV_length_all_frame = [];
for frame_no = 1: frame_number
    buf_MV_length_all_frame = [buf_MV_length_all_frame; statistic(frame_no).MV.whole_frame.length];
end

%motion vector
h = figure; hist(buf_MV_length_all_frame, 100);
title(sprintf('all frame MV histogram, total number: %d', length(buf_MV_length_all_frame)  ));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_histogram_MV_length', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function histogram_resi(statistic, disp_BS_for_each_frame)

global folder_video
global video_name;
global channel_index    %initialized in the main function
global loop_counter;

frame_number = length(statistic);

if(disp_BS_for_each_frame)
    %motion vector
    for frame_no = 1: frame_number
        %residue data
        h = figure; hist(statistic(frame_no).Y.whole_frame.residue, 100);
        title(sprintf('%dth frame residue data Y histogram, total number: %d', frame_no, length(statistic(frame_no).Y.whole_frame.residue) ));
        print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
        close(h)  %for saving memory
    end
end
    
buf_resi_Y_all_frame = [];
for frame_no = 1: frame_number
    buf_resi_Y_all_frame = [buf_resi_Y_all_frame; statistic(frame_no).Y.whole_frame.residue];
end

%residue data
h = figure; hist(buf_resi_Y_all_frame, 100);
title(sprintf('all frame residue data Y histogram, total number: %d', length(buf_resi_Y_all_frame) ));
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_hist_whole_resi', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_histogram_resi', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function histogram_resi_clip(statistic, disp_BS_for_each_frame)

global folder_video
global video_name;
global channel_index    %initialized in the main function
global loop_counter;

frame_number = length(statistic);

if(disp_BS_for_each_frame)
    %motion vector
    for frame_no = 1: frame_number
        %residue data
        h = figure; hist(statistic(frame_no).Y.whole_frame.residue_clip, 100);
        title(sprintf('%dth frame clipped residue data Y histogram, total number: %d', frame_no, length(statistic(frame_no).Y.whole_frame.residue_clip) ));
        print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
        close(h)  %for saving memory
    end
end
    
buf_resi_Y_all_frame = [];
for frame_no = 1: frame_number
    buf_resi_Y_all_frame = [buf_resi_Y_all_frame; statistic(frame_no).Y.whole_frame.residue_clip];
end

%residue data
h = figure; hist(buf_resi_Y_all_frame, 100);
title(sprintf('all frame clipped residue data Y histogram, total number: %d', length(buf_resi_Y_all_frame) ));
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_hist_whole_resi', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_histogram_resi_clipped', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function histogram_resi_prop_clip(statistic, disp_BS_for_each_frame)

global folder_video
global video_name;
global channel_index    %initialized in the main function
global loop_counter;

frame_number = length(statistic);

if(disp_BS_for_each_frame)
    %motion vector
    for frame_no = 1: frame_number
        %residue data
        h = figure; hist(statistic(frame_no).Y.whole_frame.prop_clip_resi, 100);
        title(sprintf('%dth frame clipped propagated residue data Y histogram, total number: %d', frame_no, length(statistic(frame_no).Y.whole_frame.prop_clip_resi) ));
        print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
        close(h)  %for saving memory
    end
end
    
buf_resi_Y_all_frame = [];
for frame_no = 1: frame_number
    buf_resi_Y_all_frame = [buf_resi_Y_all_frame; statistic(frame_no).Y.whole_frame.prop_clip_resi];
end

%residue data
h = figure; hist(buf_resi_Y_all_frame, 100);
title(sprintf('all frame clipped propagated residue data Y histogram, total number: %d', length(buf_resi_Y_all_frame) ));
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_hist_whole_resi', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_histogram_resi_prop_clipped', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function histogram_conc(statistic, disp_BS_for_each_frame)

global folder_video
global video_name;
global channel_index    %initialized in the main function
global loop_counter;

frame_number = length(statistic);

if(disp_BS_for_each_frame)
    %motion vector
    for frame_no = 1: frame_number
        %concealment error
        h = figure; hist(statistic(frame_no).Y.whole_frame.concealment_error, 100);
        title(sprintf('%dth frame concealment error Y histogram, total number: %d', frame_no, length(statistic(frame_no).Y.whole_frame.concealment_error) ));
        print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
        close(h)  %for saving memory
    end
end
    
buf_conc_Y_all_frame = [];
for frame_no = 1: frame_number
    buf_conc_Y_all_frame = [buf_conc_Y_all_frame; statistic(frame_no).Y.whole_frame.concealment_error];
end

%concealment error
h = figure; hist(buf_conc_Y_all_frame, 100);
title(sprintf('all frame concealment error Y histogram, total number: %d', length(buf_conc_Y_all_frame) ));
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_hist_whole_conc', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_histogram_conc', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory
    


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function histogram_conc_clip(statistic, disp_BS_for_each_frame)

global folder_video
global video_name;
global channel_index    %initialized in the main function
global loop_counter;

frame_number = length(statistic);

if(disp_BS_for_each_frame)
    %motion vector
    for frame_no = 1: frame_number
        %concealment error
        h = figure; hist(statistic(frame_no).Y.whole_frame.concealment_error_clip, 100);
        title(sprintf('%dth frame clipped concealment error Y histogram, total number: %d', frame_no, length(statistic(frame_no).Y.whole_frame.concealment_error_clip) ));
        print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
        close(h)  %for saving memory
    end
end
    
buf_conc_Y_all_frame = [];
for frame_no = 1: frame_number
    buf_conc_Y_all_frame = [buf_conc_Y_all_frame; statistic(frame_no).Y.whole_frame.concealment_error];
end

%concealment error
h = figure; hist(buf_conc_Y_all_frame, 100);
title(sprintf('all frame clipped concealment error Y histogram, total number: %d', length(buf_conc_Y_all_frame) ));
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_hist_whole_conc', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_histogram_conc_clipped', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory
    



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function histogram_conc_prop_clip(statistic, disp_BS_for_each_frame)

global folder_video
global video_name;
global channel_index    %initialized in the main function
global loop_counter;

frame_number = length(statistic);

if(disp_BS_for_each_frame)
    %motion vector
    for frame_no = 1: frame_number
        %concealment error
        h = figure; hist(statistic(frame_no).Y.whole_frame.prop_clip_conc, 100);
        title(sprintf('%dth frame clipped propagated concealment error Y histogram, total number: %d', frame_no, length(statistic(frame_no).Y.whole_frame.prop_clip_conc) ));
        print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
        close(h)  %for saving memory
    end
end
    
buf_conc_Y_all_frame = [];
for frame_no = 1: frame_number
    buf_conc_Y_all_frame = [buf_conc_Y_all_frame; statistic(frame_no).Y.whole_frame.prop_clip_conc];
end

%concealment error
h = figure; hist(buf_conc_Y_all_frame, 100);
title(sprintf('all frame clipped propagated concealment error Y histogram, total number: %d', length(buf_conc_Y_all_frame) ));
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_hist_whole_conc', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_histogram_conc_prop_clipped', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory
    


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function histogram_both(statistic, disp_BS_for_each_frame)

global folder_video
global video_name;
global channel_index    %initialized in the main function
global loop_counter;

frame_number = length(statistic);

if(disp_BS_for_each_frame)
    %motion vector
    for frame_no = 1: frame_number
        %concealment error
        h = figure; hist(statistic(frame_no).Y.whole_frame.both_error, 100);
        title(sprintf('%dth frame both error Y histogram, total number: %d', frame_no, length(statistic(frame_no).Y.whole_frame.both_error) ));
        print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
        close(h)  %for saving memory
    end
end
    
buf_conc_Y_all_frame = [];
for frame_no = 1: frame_number
    buf_conc_Y_all_frame = [buf_conc_Y_all_frame; statistic(frame_no).Y.whole_frame.both_error];
end

%concealment error
h = figure; hist(buf_conc_Y_all_frame, 100);
title(sprintf('all frame both error Y histogram, total number: %d', length(buf_conc_Y_all_frame) ));
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_hist_whole_conc', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_histogram_both', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory
    

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function histogram_both_prop_clip(statistic, disp_BS_for_each_frame)

global folder_video
global video_name;
global channel_index    %initialized in the main function
global loop_counter;

frame_number = length(statistic);

if(disp_BS_for_each_frame)
    %motion vector
    for frame_no = 1: frame_number
        %concealment error
        h = figure; hist(statistic(frame_no).Y.whole_frame.prop_clip_both, 100);
        title(sprintf('%dth frame clipped propagated both error Y histogram, total number: %d', frame_no, length(statistic(frame_no).Y.whole_frame.prop_clip_both) ));
        print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
        close(h)  %for saving memory
    end
end
    
buf_conc_Y_all_frame = [];
for frame_no = 1: frame_number
    buf_conc_Y_all_frame = [buf_conc_Y_all_frame; statistic(frame_no).Y.whole_frame.prop_clip_both];
end

%concealment error
h = figure; hist(buf_conc_Y_all_frame, 100);
title(sprintf('all frame clipped propagated both error Y histogram, total number: %d', length(buf_conc_Y_all_frame) ));
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_hist_whole_conc', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_histogram_both_prop_clipped', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory
    




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function histogram_delta_Nr_Nm_Nq(statistic, disp_BS_for_each_frame)

global folder_video
global video_name;
global channel_index    %initialized in the main function
global loop_counter;

frame_number = length(statistic);

% if(disp_BS_for_each_frame)
%     %motion vector
%     for frame_no = 1: frame_number
%         %residue data
%         delta_Nr_Nm_Nq = statistic(frame_no).Y.whole_frame.residue - statistic(frame_no).Y.whole_frame.residue_clip;
%         %delta_Nr_Nm_Nq = statistic(frame_no).Y.whole_frame.delta_Nr_Nm_Nq;
%         h = figure; hist(delta_Nr_Nm_Nq, 100);
%         title(sprintf('%dth frame delta_Nr_Nm_Nq Y histogram, total number: %d', frame_no, length(delta_Nr_Nm_Nq) ));
%         print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
%         close(h)  %for saving memory
%     end
% end
    
buf_resi_Y_all_frame = [];
for frame_no = 1: frame_number
    delta_Nr_Nm_Nq = statistic(frame_no).Y.whole_frame.residue - statistic(frame_no).Y.whole_frame.residue_clip;
    if(disp_BS_for_each_frame)
        %residue data
        h = figure; hist(delta_Nr_Nm_Nq, 100);
        title(sprintf('%dth frame delta_Nr_Nm_Nq Y histogram, total number: %d', frame_no, length(delta_Nr_Nm_Nq) ));
        print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
        close(h)  %for saving memory
    end

    buf_resi_Y_all_frame = [buf_resi_Y_all_frame; delta_Nr_Nm_Nq];
end

%residue data
h = figure; hist(buf_resi_Y_all_frame, 100);
title(sprintf('all frame delta_Nr_Nm_Nq Y histogram, total number: %d', length(buf_resi_Y_all_frame) ));
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_hist_whole_resi', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_histogram_delta_Nr_Nm_Nq', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function histogram_delta_Nr_m_Nq(statistic, disp_BS_for_each_frame)

global folder_video
global video_name;
global channel_index    %initialized in the main function
global loop_counter;

frame_number = length(statistic);

% if(disp_BS_for_each_frame)
%     %motion vector
%     for frame_no = 1: frame_number
%         %concealment error
%         delta_Nr_m_Nq = statistic(frame_no).Y.whole_frame.concealment_error_clip - statistic(frame_no).Y.whole_frame.concealment_error;
%         %delta_Nr_m_Nq = statistic(frame_no).Y.whole_frame.delta_Nr_m_Nq;
%         h = figure; hist(delta_Nr_m_Nq, 100);
%         title(sprintf('%dth frame delta_Nr_m_Nq Y histogram, total number: %d', frame_no, length(delta_Nr_m_Nq) ));
%         print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
%         close(h)  %for saving memory
%     end
% end
%     
buf_conc_Y_all_frame = [];
for frame_no = 1: frame_number
    delta_Nr_m_Nq = statistic(frame_no).Y.whole_frame.concealment_error_clip - statistic(frame_no).Y.whole_frame.concealment_error;
    if(disp_BS_for_each_frame)
        h = figure; hist(delta_Nr_m_Nq, 100);
        title(sprintf('%dth frame delta_Nr_m_Nq Y histogram, total number: %d', frame_no, length(delta_Nr_m_Nq) ));
        print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
        close(h)  %for saving memory
    end
    
    buf_conc_Y_all_frame = [buf_conc_Y_all_frame; delta_Nr_m_Nq];
end

%concealment error
h = figure; hist(buf_conc_Y_all_frame, 100);
title(sprintf('all frame delta_Nr_m_Nq Y histogram, total number: %d', length(buf_conc_Y_all_frame) ));
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_hist_whole_conc', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_histogram_delta_Nr_m_Nq', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function histogram_delta_Nr_Nm_qResi(statistic, para_image, disp_BS_for_each_frame)

global folder_video
global video_name;
global channel_index    %initialized in the main function
global loop_counter;

global block_size; %the minimum block for one motion vector

image_width = para_image.width;
image_height = para_image.height;

block_number_row = image_width/block_size;
block_number_col = image_height/block_size;


frame_number = length(statistic);

% if(disp_BS_for_each_frame)
%     %motion vector
%     for frame_no = 1: frame_number
%         MV(1, :, :) = reshape(statistic(frame_no).MV.whole_frame.x, block_number_row, block_number_col);
%         MV(2, :, :) = reshape(statistic(frame_no).MV.whole_frame.y, block_number_row, block_number_col);
%         %residue data
%         %delta_Nr_Nm_qResi = statistic(frame_no).Y.whole_frame.delta_Nr_Nm_qResi;
%         if frame_no == 1
%             delta_Nr_Nm_qResi = zeros(length(statistic(frame_no).Y.whole_frame.prop_clip_resi), 1);
%         else
%             delta_Nr_Nm_qResi = statistic(frame_no).Y.whole_frame.prop_clip_resi - reference_align(statistic(frame_no-1).Y.whole_frame.residue_clip, MV, image_width, image_height);
%         end
%         h = figure; hist(delta_Nr_Nm_qResi, 100);
%         title(sprintf('%dth frame delta_Nr_Nm_qResi Y histogram, total number: %d', frame_no, length(delta_Nr_Nm_qResi) ));
%         print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
%         close(h)  %for saving memory
%     end
% end
    
buf_resi_Y_all_frame = [];
for frame_no = 1: frame_number
    MV(1, :, :) = reshape(statistic(frame_no).MV.whole_frame.x, block_number_row, block_number_col);
    MV(2, :, :) = reshape(statistic(frame_no).MV.whole_frame.y, block_number_row, block_number_col);
    %residue data
    %delta_Nr_Nm_qResi = statistic(frame_no).Y.whole_frame.delta_Nr_Nm_qResi;
    if frame_no == 1
        delta_Nr_Nm_qResi = zeros(length(statistic(frame_no).Y.whole_frame.prop_clip_resi), 1);
    else
        delta_Nr_Nm_qResi = statistic(frame_no).Y.whole_frame.prop_clip_resi - reference_align(statistic(frame_no-1).Y.whole_frame.residue_clip, MV, image_width, image_height);
        if(disp_BS_for_each_frame)
            h = figure; hist(delta_Nr_Nm_qResi, 100);
            title(sprintf('%dth frame delta_Nr_Nm_qResi Y histogram, total number: %d', frame_no, length(delta_Nr_Nm_qResi) ));
            print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
            close(h)  %for saving memory
        end
        buf_resi_Y_all_frame = [buf_resi_Y_all_frame; delta_Nr_Nm_qResi];
    end
    
end

%residue data
h = figure; hist(buf_resi_Y_all_frame, 100);
title(sprintf('all frame delta_Nr_Nm_qResi Y histogram, total number: %d', length(buf_resi_Y_all_frame) ));
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_hist_whole_resi', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_histogram_delta_Nr_Nm_qResi', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function histogram_delta_Nr_m_qResi(statistic, disp_BS_for_each_frame)

global folder_video
global video_name;
global channel_index    %initialized in the main function
global loop_counter;

frame_number = length(statistic);

% if(disp_BS_for_each_frame)
%     %motion vector
%     for frame_no = 1: frame_number
%         %residue data
%         %delta_Nr_m_qResi = statistic(frame_no).Y.whole_frame.delta_Nr_m_qResi;
%         if frame_no == 1
%             delta_Nr_m_qResi = zeros(length(statistic(frame_no).Y.whole_frame.predicted), 1);
%         else
%             delta_Nr_m_qResi = (statistic(frame_no-1).Y.whole_frame.predicted + statistic.Y.whole_frame.residue) - clip_vector(statistic(frame_no-1).Y.whole_frame.predicted + statistic.Y.whole_frame.residue, 'resi_delta_tt');
%         end
%         h = figure; hist(delta_Nr_m_qResi, 100);
%         title(sprintf('%dth frame delta_Nr_m_qResi Y histogram, total number: %d', frame_no, length(delta_Nr_m_qResi) ));
%         print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
%         close(h)  %for saving memory
%     end
% end
    
buf_resi_Y_all_frame = [];
for frame_no = 1: frame_number
    if frame_no == 1
        delta_Nr_m_qResi = zeros(length(statistic(frame_no).Y.whole_frame.predicted), 1);
    else
        delta_Nr_m_qResi = (statistic(frame_no-1).Y.whole_frame.predicted + statistic(frame_no).Y.whole_frame.residue) ...
            - clip_vector(statistic(frame_no-1).Y.whole_frame.predicted + statistic(frame_no).Y.whole_frame.residue, 'resi_delta_tt');
        if(disp_BS_for_each_frame)
            h = figure; hist(delta_Nr_m_qResi, 100);
            title(sprintf('%dth frame delta_Nr_m_qResi Y histogram, total number: %d', frame_no, length(delta_Nr_m_qResi) ));
            print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
            close(h)  %for saving memory
        end
        buf_resi_Y_all_frame = [buf_resi_Y_all_frame; delta_Nr_m_qResi];
    end
end

%residue data
h = figure; hist(buf_resi_Y_all_frame, 100);
title(sprintf('all frame delta_Nr_m_qResi Y histogram, total number: %d', length(buf_resi_Y_all_frame) ));
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_hist_whole_resi', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_histogram_delta_Nr_m_qResi', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function histogram_delta_Nr_Nm_qConc(statistic, para_image, disp_BS_for_each_frame)

global folder_video
global video_name;
global channel_index    %initialized in the main function
global loop_counter;

global block_size; %the minimum block for one motion vector

image_width = para_image.width;
image_height = para_image.height;

block_number_row = image_width/block_size;
block_number_col = image_height/block_size;

frame_number = length(statistic);
  
% if(disp_BS_for_each_frame)
%     %motion vector
%     for frame_no = 1: frame_number
%         MV(1, :, :) = reshape(statistic(frame_no).MV.whole_frame.x, block_number_row, block_number_col);
%         MV(2, :, :) = reshape(statistic(frame_no).MV.whole_frame.y, block_number_row, block_number_col);
%         %concealment error
%         %delta_Nr_Nm_qConc = statistic(frame_no).Y.whole_frame.delta_Nr_Nm_qConc;
%         if frame_no == 1
%             delta_Nr_Nm_qConc = zeros(length(statistic(frame_no).Y.whole_frame.prop_clip_conc), 1);
%         else
%             delta_Nr_Nm_qConc = statistic.Y.whole_frame.prop_clip_conc - reference_align(statistic(frame_no-1).Y.whole_frame.concealment_error_clip, MV, image_width, image_height);
%         end
%         h = figure; hist(delta_Nr_Nm_qConc, 100);
%         title(sprintf('%dth frame delta_Nr_Nm_qConc Y histogram, total number: %d', frame_no, length(delta_Nr_Nm_qConc) ));
%         print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
%         close(h)  %for saving memory
%     end
% end
    
buf_conc_Y_all_frame = [];
for frame_no = 1: frame_number
    MV(1, :, :) = reshape(statistic(frame_no).MV.whole_frame.x, block_number_row, block_number_col);
    MV(2, :, :) = reshape(statistic(frame_no).MV.whole_frame.y, block_number_row, block_number_col);
    %concealment error
    %delta_Nr_Nm_qConc = statistic(frame_no).Y.whole_frame.delta_Nr_Nm_qConc;
    if frame_no == 1
        delta_Nr_Nm_qConc = zeros(length(statistic(frame_no).Y.whole_frame.prop_clip_conc), 1);
    else
        delta_Nr_Nm_qConc = statistic(frame_no).Y.whole_frame.prop_clip_conc - reference_align(statistic(frame_no-1).Y.whole_frame.concealment_error_clip, MV, image_width, image_height);
        if(disp_BS_for_each_frame)
            h = figure; hist(delta_Nr_Nm_qConc, 100);
            title(sprintf('%dth frame delta_Nr_Nm_qConc Y histogram, total number: %d', frame_no, length(delta_Nr_Nm_qConc) ));
            print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
            close(h)  %for saving memory
        end
        buf_conc_Y_all_frame = [buf_conc_Y_all_frame; delta_Nr_Nm_qConc];
    end
end

%concealment error
h = figure; hist(buf_conc_Y_all_frame, 100);
title(sprintf('all frame delta_Nr_Nm_qConc Y histogram, total number: %d', length(buf_conc_Y_all_frame) ));
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_hist_whole_conc', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_histogram_delta_Nr_Nm_qConc', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function histogram_delta_Nr_m_qConc(statistic, disp_BS_for_each_frame)

global folder_video
global video_name;
global channel_index    %initialized in the main function
global loop_counter;

frame_number = length(statistic);

% if(disp_BS_for_each_frame)
%     %motion vector
%     for frame_no = 1: frame_number
%         %concealment error
%         %delta_Nr_m_qConc = statistic(frame_no).Y.whole_frame.delta_Nr_m_qConc;
%         if frame_no == 1
%             delta_Nr_m_qConc = zeros(length(statistic(frame_no).Y.whole_frame.reconstructed), 1);
%         else
%             delta_Nr_m_qConc = (statistic(frame_no-1).Y.whole_frame.reconstructed - statistic(frame_no-1).Y.whole_frame.concealment_error_clip + statistic.Y.whole_frame.residue) - clip_vector(statistic(frame_no-1).Y.whole_frame.reconstructed - statistic(frame_no-1).Y.whole_frame.concealment_error_clip + statistic.Y.whole_frame.residue, 'conc_delta_tt');
%         end
%         h = figure; hist(delta_Nr_m_qConc, 100);
%         title(sprintf('%dth frame delta_Nr_m_qConc Y histogram, total number: %d', frame_no, length(delta_Nr_m_qConc) ));
%         print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
%         close(h)  %for saving memory
%     end
% end
    
buf_conc_Y_all_frame = [];
for frame_no = 1: frame_number
    if frame_no == 1
        delta_Nr_m_qConc = zeros(length(statistic(frame_no).Y.whole_frame.reconstructed), 1);
    else
        delta_Nr_m_qConc = (statistic(frame_no-1).Y.whole_frame.reconstructed - statistic(frame_no-1).Y.whole_frame.concealment_error_clip + statistic(frame_no).Y.whole_frame.residue) ...
            - clip_vector(statistic(frame_no-1).Y.whole_frame.reconstructed - statistic(frame_no-1).Y.whole_frame.concealment_error_clip + statistic(frame_no).Y.whole_frame.residue, 'conc_delta_tt');
        if(disp_BS_for_each_frame)
            h = figure; hist(delta_Nr_m_qConc, 100);
            title(sprintf('%dth frame delta_Nr_m_qConc Y histogram, total number: %d', frame_no, length(delta_Nr_m_qConc) ));
            print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
            close(h)  %for saving memory
        end
        buf_conc_Y_all_frame = [buf_conc_Y_all_frame; delta_Nr_m_qConc];
    end
end

%concealment error
h = figure; hist(buf_conc_Y_all_frame, 100);
title(sprintf('all frame delta_Nr_m_qConc Y histogram, total number: %d', length(buf_conc_Y_all_frame) ));
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_hist_whole_conc', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_histogram_delta_Nr_m_qConc', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function histogram_delta_Nr_Nm_pBoth(statistic, para_image, disp_BS_for_each_frame)

global folder_video
global video_name;
global channel_index    %initialized in the main function
global loop_counter;

global block_size; %the minimum block for one motion vector

image_width = para_image.width;
image_height = para_image.height;

block_number_row = image_width/block_size;
block_number_col = image_height/block_size;

frame_number = length(statistic);

% if(disp_BS_for_each_frame)
%     %motion vector
%     for frame_no = 1: frame_number
%         MV(1, :, :) = reshape(statistic(frame_no).MV.whole_frame.x, block_number_row, block_number_col);
%         MV(2, :, :) = reshape(statistic(frame_no).MV.whole_frame.y, block_number_row, block_number_col);
%         %both error
%         %delta_Nr_Nm_pBoth = statistic(frame_no).Y.whole_frame.delta_Nr_Nm_pBoth;
%         if frame_no == 1
%             delta_Nr_Nm_pBoth = zeros(length(statistic(frame_no).Y.whole_frame.prop_clip_both), 1);
%         else
%             delta_Nr_Nm_pBoth = statistic.Y.whole_frame.prop_clip_both - reference_align(statistic(frame_no-1).Y.whole_frame.both_error, MV, image_width, image_height);;
%         end
%         h = figure; hist(delta_Nr_Nm_pBoth, 100);
%         title(sprintf('%dth frame delta_Nr_Nm_pBoth Y histogram, total number: %d', frame_no, length(delta_Nr_Nm_pBoth) ));
%         print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
%         close(h)  %for saving memory
%     end
% end
    
buf_conc_Y_all_frame = [];
for frame_no = 1: frame_number
    MV(1, :, :) = reshape(statistic(frame_no).MV.whole_frame.x, block_number_row, block_number_col);
    MV(2, :, :) = reshape(statistic(frame_no).MV.whole_frame.y, block_number_row, block_number_col);
    %both error
    %delta_Nr_Nm_pBoth = statistic(frame_no).Y.whole_frame.delta_Nr_Nm_pBoth;
    if frame_no == 1
        delta_Nr_Nm_pBoth = zeros(length(statistic(frame_no).Y.whole_frame.prop_clip_both), 1);
    else
        delta_Nr_Nm_pBoth = statistic(frame_no).Y.whole_frame.prop_clip_both - reference_align(statistic(frame_no-1).Y.whole_frame.both_error, MV, image_width, image_height);;
        if(disp_BS_for_each_frame)
            h = figure; hist(delta_Nr_Nm_pBoth, 100);
            title(sprintf('%dth frame delta_Nr_Nm_pBoth Y histogram, total number: %d', frame_no, length(delta_Nr_Nm_pBoth) ));
            print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
            close(h)  %for saving memory
        end
        buf_conc_Y_all_frame = [buf_conc_Y_all_frame; delta_Nr_Nm_pBoth];
    end
end

%concealment error
h = figure; hist(buf_conc_Y_all_frame, 100);
title(sprintf('all frame delta_Nr_Nm_pBoth Y histogram, total number: %d', length(buf_conc_Y_all_frame) ));
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_hist_whole_conc', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_histogram_delta_Nr_Nm_pBoth', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory
    


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function histogram_delta_Nr_m_pBoth(statistic, disp_BS_for_each_frame)

global folder_video
global video_name;
global channel_index    %initialized in the main function
global loop_counter;

frame_number = length(statistic);

% if(disp_BS_for_each_frame)
%     %motion vector
%     for frame_no = 1: frame_number
%         %both error
%         %delta_Nr_m_pBoth = statistic(frame_no).Y.whole_frame.delta_Nr_m_pBoth;
%         if frame_no == 1
%             delta_Nr_m_pBoth = zeros(length(statistic(frame_no).Y.whole_frame.reconstructed), 1);
%         else
%             delta_Nr_m_pBoth = (statistic(frame_no-1).Y.whole_frame.reconstructed - statistic.Y.whole_frame.residue_clip - statistic(frame_no-1).Y.whole_frame.concealment_error + statistic.Y.whole_frame.residue) - clip_vector(statistic(frame_no-1).Y.whole_frame.reconstructed - statistic.Y.whole_frame.residue_clip - statistic(frame_no-1).Y.whole_frame.concealment_error + statistic.Y.whole_frame.residue, 'both_delta_tt');
%         end
%         h = figure; hist(delta_Nr_m_pBoth, 100);
%         title(sprintf('%dth frame delta_Nr_m_pBoth Y histogram, total number: %d', frame_no, length(delta_Nr_m_pBoth) ));
%         print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
%         close(h)  %for saving memory
%     end
% end
%     
buf_conc_Y_all_frame = [];
for frame_no = 1: frame_number
        if frame_no == 1
            delta_Nr_m_pBoth = zeros(length(statistic(frame_no).Y.whole_frame.reconstructed), 1);
        else
            delta_Nr_m_pBoth = (statistic(frame_no-1).Y.whole_frame.reconstructed - statistic(frame_no).Y.whole_frame.residue_clip - statistic(frame_no-1).Y.whole_frame.concealment_error + statistic(frame_no).Y.whole_frame.residue) ...
                - clip_vector(statistic(frame_no-1).Y.whole_frame.reconstructed - statistic(frame_no).Y.whole_frame.residue_clip - statistic(frame_no-1).Y.whole_frame.concealment_error + statistic(frame_no).Y.whole_frame.residue, 'both_delta_tt');
            if(disp_BS_for_each_frame)
                h = figure; hist(delta_Nr_m_pBoth, 100);
                title(sprintf('%dth frame delta_Nr_m_pBoth Y histogram, total number: %d', frame_no, length(delta_Nr_m_pBoth) ));
                print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
                close(h)  %for saving memory
            end
            buf_conc_Y_all_frame = [buf_conc_Y_all_frame; delta_Nr_m_pBoth];
        end
end

%concealment error
h = figure; hist(buf_conc_Y_all_frame, 100);
title(sprintf('all frame delta_Nr_m_pBoth Y histogram, total number: %d', length(buf_conc_Y_all_frame) ));
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_hist_whole_conc', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_histogram_delta_Nr_m_pBoth', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory
    


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function histogram_delta_Nr_m_pBoth_lastminusfirst(statistic, disp_BS_for_each_frame)

global folder_video
global video_name;
global channel_index    %initialized in the main function
global loop_counter;

frame_number = length(statistic);
  
delta_Nr_m_pBoth_lastminusfirst = statistic(2).Y.whole_frame.reconstructed + statistic(frame_number).Y.whole_frame.residue ...
    - clip_vector(statistic(2).Y.whole_frame.reconstructed + statistic(frame_number).Y.whole_frame.residue, 'delta_Nr_m_pBoth_lastminusfirst');

%concealment error
h = figure; hist(delta_Nr_m_pBoth_lastminusfirst, 100);
title(sprintf('last minus first delta_Nr_m_pBoth_lastminusfirst Y histogram, total number: %d', length(delta_Nr_m_pBoth_lastminusfirst) ));
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_hist_whole_conc', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_histogram_delta_Nr_m_pBoth_lastminusfirst', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory
    



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function histogram_recon(statistic, disp_BS_for_each_frame)

global folder_video
global video_name;
global channel_index    %initialized in the main function
global loop_counter;

frame_number = length(statistic);

if(disp_BS_for_each_frame)
    %motion vector
    for frame_no = 1: frame_number
        %reconstructed pixel value
        h = figure; hist(statistic(frame_no).Y.whole_frame.reconstructed, 100);
        title(sprintf('%dth frame rexonstructed value Y histogram, total number: %d', frame_no, length(statistic(frame_no).Y.whole_frame.reconstructed) ));
        print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
        close(h)  %for saving memory
    end
end
    
buf_recon_Y_all_frame = [];

buf_conc_Y_all_frame = [];
for frame_no = 1: frame_number
    buf_recon_Y_all_frame = [buf_recon_Y_all_frame; statistic(frame_no).Y.whole_frame.reconstructed];
end

%reconstructed pixel value
h = figure; hist(buf_recon_Y_all_frame, 100);
title(sprintf('all frame reconstructed value Y histogram, total number: %d', length(buf_recon_Y_all_frame) ));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_histogram_recon', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function CC_temporal_resi_conc(statistic)

global folder_video
global video_name   %initialized in the main function
global channel_index    %initialized in the main function
global loop_counter %initialized in the main function

frame_number = length(statistic);

for frame_no = 1: frame_number
    buf_resi_Y(:, frame_no) = statistic(frame_no).Y.whole_frame.residue;    
    buf_conc_Y(:, frame_no) = statistic(frame_no).Y.whole_frame.concealment_error;
end

buf_all_Y =[buf_resi_Y, buf_conc_Y];
R_all = corrcoef(buf_all_Y);
R_resi = R_all(1:frame_number, 1:frame_number);
h = figure; meshc(R_resi);
xlabel('frame index'); ylabel('frame index'); zlabel('correlation coefficient');
title('correlation between residue data of different frames');
%%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_R_resi_resi', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_R_resi_resi_temporal', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory

R_conc = R_all(frame_number+1:2*frame_number, frame_number+1:2*frame_number);
h = figure; meshc(R_conc);
xlabel('frame index'); ylabel('frame index'); zlabel('correlation coefficient');
title('correlation between concealment error of different frames');
%%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_R_conc_conc', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_R_conc_conc_temporal', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory

R_resi_conc = R_all(1:frame_number, frame_number+1:2*frame_number);
h = figure; meshc(R_resi_conc);
xlabel('concealment error frame no.'); ylabel('residue data frame no.'); zlabel('correlation coefficient');   %matlab seems plot row as xlabel
title('correlation between residue data and concealment error of different frames');
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_R_resi_conc', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_R_resi_conc_temporal', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory

h = figure; meshc(R_all);
title('cross correlation between both errors over time domain');
%%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_R_all', folder_video, video_name, channel_index, loop_counter));
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory






%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function CC_temporal_align_resi_conc(statistic, para_image)

global folder_video
global video_name   %initialized in the main function
global channel_index    %initialized in the main function
global loop_counter %initialized in the main function

global block_size; %the minimum block for one motion vector

image_width = para_image.width;
image_height = para_image.height;

block_number_row = image_width/block_size;
block_number_col = image_height/block_size;

frame_number = length(statistic);

buf_resi_Y(:, frame_number) = statistic(frame_number).Y.whole_frame.residue;    
buf_conc_Y(:, frame_number) = statistic(frame_number).Y.whole_frame.concealment_error;
if(frame_number > 1)
    for frame_no = 1 : frame_number - 1
        buf_resi_Y_temp = statistic(frame_no).Y.whole_frame.residue;
        buf_conc_Y_temp = statistic(frame_no).Y.whole_frame.concealment_error;
        for index_align = frame_no : frame_number - 1
            MV(1, :, :) = reshape(statistic(index_align+1).MV.whole_frame.x, block_number_row, block_number_col);
            MV(2, :, :) = reshape(statistic(index_align+1).MV.whole_frame.y, block_number_row, block_number_col);
            buf_resi_Y_temp = reference_align(buf_resi_Y_temp, MV, image_width, image_height);
            buf_conc_Y_temp = reference_align(buf_conc_Y_temp, MV, image_width, image_height);
        end
        buf_resi_Y(:, frame_no) = buf_resi_Y_temp;
        buf_conc_Y(:, frame_no) = buf_conc_Y_temp;
    end
end

buf_all_Y =[buf_resi_Y, buf_conc_Y];
R_all = corrcoef(buf_all_Y);
R_resi = R_all(1:frame_number, 1:frame_number);
h = figure; meshc(R_resi);
xlabel('frame index'); ylabel('frame index'); zlabel('correlation coefficient');
title('correlation between aligned residue data of different frames');
%%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_R_resi_resi', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_R_resi_resi_temporal_align', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory

R_conc = R_all(frame_number+1:2*frame_number, frame_number+1:2*frame_number);
h = figure; meshc(R_conc);
xlabel('frame index'); ylabel('frame index'); zlabel('correlation coefficient');
title('correlation between aligned concealment error of different frames');
%%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_R_conc_conc', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_R_conc_conc_temporal_align', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory

R_resi_conc = R_all(1:frame_number, frame_number+1:2*frame_number);
h = figure; meshc(R_resi_conc);
xlabel('concealment error frame no.'); ylabel('residue data frame no.'); zlabel('correlation coefficient');   %matlab seems plot row as xlabel
title('correlation between aligned residue data and concealment error of different frames');
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_R_resi_conc', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_R_resi_conc_temporal_align', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory

h = figure; meshc(R_all);
title('cross correlation between aligned both errors over time domain');
%%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_R_all', folder_video, video_name, channel_index, loop_counter));
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory







%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function CC_temporal_align_test_resi_conc(statistic, para_image)

global folder_video
global video_name   %initialized in the main function
global channel_index    %initialized in the main function
global loop_counter %initialized in the main function

global block_size; %the minimum block for one motion vector

image_width = para_image.width;
image_height = para_image.height;

block_number_row = image_width/block_size;
block_number_col = image_height/block_size;

frame_number = length(statistic);

buf_resi_Y(:, frame_number) = statistic(frame_number).Y.whole_frame.residue;    
buf_conc_Y(:, frame_number) = statistic(frame_number).Y.whole_frame.concealment_error;

if(frame_number > 1)
    buf_resi_Y(:, frame_number-1) = statistic(frame_number-1).Y.whole_frame.residue;    
    buf_conc_Y(:, frame_number-1) = statistic(frame_number-1).Y.whole_frame.concealment_error;
end

if(frame_number > 2)
    for frame_no = 1 : frame_number - 2
        buf_resi_Y_temp = statistic(frame_no).Y.whole_frame.residue;
        buf_conc_Y_temp = statistic(frame_no).Y.whole_frame.concealment_error;
        for index_align = frame_no : frame_number - 2
            MV(1, :, :) = reshape(statistic(index_align+1).MV.whole_frame.x, block_number_row, block_number_col);
            MV(2, :, :) = reshape(statistic(index_align+1).MV.whole_frame.y, block_number_row, block_number_col);
            buf_resi_Y_temp = reference_align(buf_resi_Y_temp, MV, image_width, image_height);
            buf_conc_Y_temp = reference_align(buf_conc_Y_temp, MV, image_width, image_height);
        end
        buf_resi_Y(:, frame_no) = buf_resi_Y_temp;
        buf_conc_Y(:, frame_no) = buf_conc_Y_temp;
    end
end

buf_all_Y =[buf_resi_Y, buf_conc_Y];
R_all = corrcoef(buf_all_Y);
R_resi = R_all(1:frame_number, 1:frame_number);
h = figure; meshc(R_resi);
xlabel('frame index'); ylabel('frame index'); zlabel('correlation coefficient');
title('test correlation between aligned residue data of different frames');
%%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_R_resi_resi', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_R_resi_resi_temporal_align_test', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory

R_conc = R_all(frame_number+1:2*frame_number, frame_number+1:2*frame_number);
h = figure; meshc(R_conc);
xlabel('frame index'); ylabel('frame index'); zlabel('correlation coefficient');
title('test correlation between aligned concealment error of different frames');
%%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_R_conc_conc', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_R_conc_conc_temporal_align_test', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory

R_resi_conc = R_all(1:frame_number, frame_number+1:2*frame_number);
h = figure; meshc(R_resi_conc);
xlabel('concealment error frame no.'); ylabel('residue data frame no.'); zlabel('correlation coefficient');   %matlab seems plot row as xlabel
title('test correlation between aligned residue data and concealment error of different frames');
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_R_resi_conc', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_R_resi_conc_temporal_align_test', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function CC_spatial_resi_conc(statistic, para_image, disp_CC_for_each_frame)

global folder_video
global video_name   %initialized in the main function
global channel_index    %initialized in the main function
global loop_counter %initialized in the main function

global MB_size

image_width = para_image.width;
image_height = para_image.height;
MB_number_row = image_width/MB_size;
MB_number_col = image_height/MB_size;

frame_number = length(statistic);

buf_resi_Y_MB_all_frame = [];
buf_conc_Y_MB_all_frame = [];
for frame_no = 1 : frame_number
    buf_resi_Y_MB_one_frame = [];
    buf_conc_Y_MB_one_frame = [];
    buf_resi_Y = reshape(statistic(frame_no).Y.whole_frame.residue, image_width, image_height);
    buf_conc_Y = reshape(statistic(frame_no).Y.whole_frame.concealment_error, image_width, image_height);
    for MB_no_col = 1 : MB_number_col
        for MB_no_row = 1 : MB_number_row
            pos_row = (MB_no_row-1) * MB_size + 1;
            pos_col = (MB_no_col-1) * MB_size + 1;
            buf_resi_Y_MB = buf_resi_Y(pos_row : pos_row+MB_size-1, pos_col : pos_col+MB_size-1);
            buf_resi_Y_MB_one_frame = [buf_resi_Y_MB_one_frame; reshape(buf_resi_Y_MB, 1, MB_size*MB_size)];
            buf_conc_Y_MB = buf_conc_Y(pos_row : pos_row+MB_size-1, pos_col : pos_col+MB_size-1);
            buf_conc_Y_MB_one_frame = [buf_conc_Y_MB_one_frame; reshape(buf_conc_Y_MB, 1, MB_size*MB_size)];
        end
    end
    if(disp_CC_for_each_frame)
        buf_all_Y =[buf_resi_Y_MB_one_frame, buf_conc_Y_MB_one_frame];
        R_all = corrcoef(buf_all_Y);
        R_resi = R_all(1:MB_size*MB_size, 1:MB_size*MB_size);
        h = figure; mesh(R_resi);
        xlabel('pixel index in one MB'); ylabel('pixel index in one MB'); zlabel('correlation coefficient');
        title(sprintf('correlation between residue data of different pixels in one MB of %dth frames', frame_no));
        print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
        close(h)  %for saving memory

        R_conc = R_all(MB_size*MB_size+1:2*MB_size*MB_size, MB_size*MB_size+1:2*MB_size*MB_size);
        h = figure; mesh(R_conc);
        xlabel('pixel index in one MB'); ylabel('pixel index in one MB'); zlabel('correlation coefficient');
        title(sprintf('correlation between concealment error of different pixels in one MB of %dth frames', frame_no));
        print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
        close(h)  %for saving memory

        R_resi_conc = R_all(1:MB_size*MB_size, MB_size*MB_size+1:2*MB_size*MB_size);
        h = figure; mesh(R_resi_conc);
        xlabel('concealment error pixel index'); ylabel('residue data pixel index'); zlabel('correlation coefficient');   %matlab seems plot row as xlabel
        title(sprintf('correlation between residue data and concealment error of different pixels in one MB of %dth frames', frame_no));
        print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
        close(h)  %for saving memory

        h = figure; mesh(R_all);
        title(sprintf('correlation between both errors over image domain in one MB of %dth frames', frame_no));
        print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
        close(h)  %for saving memory
    end
    buf_resi_Y_MB_all_frame = [buf_resi_Y_MB_all_frame; buf_resi_Y_MB_one_frame];
    buf_conc_Y_MB_all_frame = [buf_conc_Y_MB_all_frame; buf_conc_Y_MB_one_frame];
end

buf_all_Y =[buf_resi_Y_MB_all_frame, buf_conc_Y_MB_all_frame];
R_all = corrcoef(buf_all_Y);
R_resi = R_all(1:MB_size*MB_size, 1:MB_size*MB_size);
h = figure; meshc(R_resi);
xlabel('pixel index in one MB'); ylabel('pixel index in one MB'); zlabel('correlation coefficient');
title('correlation between residue data of different pixels in one MB');
%%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_R_resi_resi', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_R_resi_resi_spatial', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory

R_conc = R_all(MB_size*MB_size+1:2*MB_size*MB_size, MB_size*MB_size+1:2*MB_size*MB_size);
h = figure; meshc(R_conc);
xlabel('pixel index in one MB'); ylabel('pixel index in one MB'); zlabel('correlation coefficient');
title('correlation between concealment error of different pixels in one MB');
%%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_R_conc_conc', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_R_conc_conc_spatial', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory

R_resi_conc = R_all(1:MB_size*MB_size, MB_size*MB_size+1:2*MB_size*MB_size);
h = figure; meshc(R_resi_conc);
xlabel('concealment error pixel index'); ylabel('residue data pixel index'); zlabel('correlation coefficient');   %matlab seems plot row as xlabel
title('correlation between residue data and concealment error of different pixels in one MB');
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_R_resi_conc', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_R_resi_conc_spatial', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory

h = figure; meshc(R_all);
title('cross correlation between both errors over image domain in one MB');
%%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_R_all', folder_video, video_name, channel_index, loop_counter));
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory








%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function JP_MV_x_MV_y(statistic, disp_JP_for_each_frame)

global folder_video
global video_name   %initialized in the main function
global channel_index    %initialized in the main function
global loop_counter %initialized in the main function

pdf_row_number_all_frame = 20;    %row means the first dimension, compatiable to image row in width
pdf_col_number_all_frame = 20;    %col means the second dimension, compatiable to image row in height
pdf_grid_all_frame = [pdf_row_number_all_frame, pdf_col_number_all_frame];

frame_number = length(statistic);

if(disp_JP_for_each_frame)
    pdf_row_number = 10;    %row means the first dimension, compatiable to image row in width
    pdf_col_number = 10;    %col means the second dimension, compatiable to image row in height
    pdf_grid = [pdf_row_number, pdf_col_number];
    for frame_no = 1 : frame_number
        h = figure('Visible', 'on'); hist3([statistic(frame_no).MV.whole_frame.x, statistic(frame_no).MV.whole_frame.y], pdf_grid);
        xlabel('MV_x'); ylabel('MV_y'); zlabel('MV number');   %matlab seems plot row as xlabel
        title(sprintf('unnormalized joint pdf of %dth frames', frame_no));
        print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
        close(h)  %for saving memory
    end
end

buf_MV_x_all_frame = [];
buf_MV_y_all_frame = [];
for frame_no = 1: frame_number
    buf_MV_x_all_frame = [buf_MV_x_all_frame; statistic(frame_no).MV.whole_frame.x];
    buf_MV_y_all_frame = [buf_MV_y_all_frame; statistic(frame_no).MV.whole_frame.y];
end
h = figure; hist3([buf_MV_x_all_frame, buf_MV_y_all_frame], pdf_grid_all_frame);
xlabel('MV_x'); ylabel('MV_y'); zlabel('MV number');   %matlab seems plot row as xlabel
title('unnormalized joint pdf of all frames');
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_joint_pdf_MV_x_MV_y', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function JP_resi_conc(statistic, disp_JP_for_each_frame)

global folder_video
global video_name   %initialized in the main function
global channel_index    %initialized in the main function
global loop_counter %initialized in the main function

pdf_row_number_all_frame = 100;    %row means the first dimension, compatiable to image row in width
pdf_col_number_all_frame = 100;    %col means the second dimension, compatiable to image row in height
pdf_grid_all_frame = [pdf_row_number_all_frame, pdf_col_number_all_frame];

frame_number = length(statistic);

if(disp_JP_for_each_frame)
    pdf_row_number = 20;    %row means the first dimension, compatiable to image row in width
    pdf_col_number = 10;    %col means the second dimension, compatiable to image row in height
    pdf_grid = [pdf_row_number, pdf_col_number];
    for frame_no = 1 : frame_number
        h = figure('Visible', 'on'); hist3([statistic(frame_no).Y.whole_frame.residue, statistic(frame_no).Y.whole_frame.concealment_error], pdf_grid);
        xlabel('residue data value'); ylabel('concealment error value'); zlabel('pixel number');   %matlab seems plot row as xlabel
        title(sprintf('unnormalized joint pdf of %dth frames', frame_no));
        print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
        close(h)  %for saving memory
    end
end

buf_resi_Y_all_frame = [];
buf_conc_Y_all_frame = [];
for frame_no = 1: frame_number
    buf_resi_Y_all_frame = [buf_resi_Y_all_frame; statistic(frame_no).Y.whole_frame.residue];
    buf_conc_Y_all_frame = [buf_conc_Y_all_frame; statistic(frame_no).Y.whole_frame.concealment_error];
end

%to plot the joint pdf of residue data and concealment error
h = figure; hist3([buf_resi_Y_all_frame, buf_conc_Y_all_frame], pdf_grid_all_frame);
xlabel('residue data value'); ylabel('concealment error value'); zlabel('pixel number');   %matlab seems plot row as xlabel
title('unnormalized joint pdf of all frames');
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_joint_pdf_resi_conc', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_joint_pdf_resi_conc', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function JP_resi_pred(statistic, disp_JP_for_each_frame)

global folder_video
global video_name   %initialized in the main function
global channel_index    %initialized in the main function
global loop_counter %initialized in the main function

pdf_row_number_all_frame = 100;    %row means the first dimension, compatiable to image row in width
pdf_col_number_all_frame = 100;    %col means the second dimension, compatiable to image row in height
pdf_grid_all_frame = [pdf_row_number_all_frame, pdf_col_number_all_frame];

frame_number = length(statistic);

if(disp_JP_for_each_frame)
    pdf_row_number = 20;    %row means the first dimension, compatiable to image row in width
    pdf_col_number = 10;    %col means the second dimension, compatiable to image row in height
    pdf_grid = [pdf_row_number, pdf_col_number];
    for frame_no = 1 : frame_number
        h = figure('Visible', 'on'); hist3([statistic(frame_no).Y.whole_frame.residue, statistic(frame_no).Y.whole_frame.predicted], pdf_grid);
        xlabel('residue data value'); ylabel('predicted pixel value'); zlabel('pixel number');   %matlab seems plot row as xlabel
        title(sprintf('unnormalized joint pdf of %dth frames', frame_no));
        print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
        close(h)  %for saving memory
    end
end

buf_resi_Y_all_frame = [];
buf_pred_Y_all_frame = [];
for frame_no = 1: frame_number
    buf_resi_Y_all_frame = [buf_resi_Y_all_frame; statistic(frame_no).Y.whole_frame.residue];
    buf_pred_Y_all_frame = [buf_pred_Y_all_frame; statistic(frame_no).Y.whole_frame.predicted];
end

%to plot the joint pdf of residue data and predicted pixel value
h = figure; hist3([buf_resi_Y_all_frame, buf_pred_Y_all_frame], pdf_grid_all_frame);
xlabel('residue data value'); ylabel('predicted pixel value'); zlabel('pixel number');   %matlab seems plot row as xlabel
title('unnormalized joint pdf of all frames');
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_joint_pdf_resi_pred', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_joint_pdf_resi_pred', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory

%plot joint pdf with log
[joint_pdf, position] = hist3([buf_resi_Y_all_frame, buf_pred_Y_all_frame], pdf_grid_all_frame);
axis_x = position{1};
axis_y = position{2};
joint_pdf_log = log10(joint_pdf);
h = figure; meshc(axis_y, axis_x, joint_pdf_log);
xlabel('residue data value'); ylabel('predicted pixel value'); zlabel('pixel number by log');   %matlab seems plot row as xlabel
title('unnormalized joint pdf by log of all frames');
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_joint_pdf_resi_pred_log', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_joint_pdf_resi_pred_log', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function JP_resi_recon(statistic, disp_JP_for_each_frame)

global folder_video
global video_name   %initialized in the main function
global channel_index    %initialized in the main function
global loop_counter %initialized in the main function

pdf_row_number_all_frame = 100;    %row means the first dimension, compatiable to image row in width
pdf_col_number_all_frame = 100;    %col means the second dimension, compatiable to image row in height
pdf_grid_all_frame = [pdf_row_number_all_frame, pdf_col_number_all_frame];

frame_number = length(statistic);

if(disp_JP_for_each_frame)
    pdf_row_number = 20;    %row means the first dimension, compatiable to image row in width
    pdf_col_number = 10;    %col means the second dimension, compatiable to image row in height
    pdf_grid = [pdf_row_number, pdf_col_number];
    for frame_no = 1 : frame_number
        h = figure('Visible', 'on'); hist3([statistic(frame_no).Y.whole_frame.residue, statistic(frame_no).Y.whole_frame.reconstructed], pdf_grid);
        xlabel('residue data value'); ylabel('reconstructed pixel value'); zlabel('pixel number');   %matlab seems plot row as xlabel
        title(sprintf('unnormalized joint pdf of %dth frames', frame_no));
        print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
        close(h)  %for saving memory
    end
end

buf_resi_Y_all_frame = [];
buf_recon_Y_all_frame = [];
for frame_no = 1: frame_number
    buf_resi_Y_all_frame = [buf_resi_Y_all_frame; statistic(frame_no).Y.whole_frame.residue];
    buf_recon_Y_all_frame = [buf_recon_Y_all_frame; statistic(frame_no).Y.whole_frame.reconstructed];
end

%to plot the joint pdf of residue data and reconstructed pixel value
h = figure; hist3([buf_resi_Y_all_frame, buf_recon_Y_all_frame], pdf_grid_all_frame);
xlabel('residue data value'); ylabel('reconstructed pixel value'); zlabel('pixel number');   %matlab seems plot row as xlabel
title('unnormalized joint pdf of all frames');
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_joint_pdf_resi_recon', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_joint_pdf_resi_recon', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory

%plot joint pdf with log
[joint_pdf, position] = hist3([buf_resi_Y_all_frame, buf_recon_Y_all_frame], pdf_grid_all_frame);
axis_x = position{1};
axis_y = position{2};
joint_pdf_log = log10(joint_pdf);
h = figure; meshc(axis_y, axis_x, joint_pdf_log);
xlabel('residue data value'); ylabel('reconstructed pixel value'); zlabel('pixel number by log');   %matlab seems plot row as xlabel
title('unnormalized joint pdf by log of all frames');
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_joint_pdf_resi_recon_log', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_joint_pdf_resi_recon_log', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory









%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function CP_resi_conc(statistic, disp_CP_for_each_frame)

global folder_video
global video_name   %initialized in the main function
global channel_index    %initialized in the main function
global loop_counter %initialized in the main function

pdf_row_number_all_frame = 100;    %row means the first dimension, compatiable to image row in width
pdf_col_number_all_frame = 100;    %col means the second dimension, compatiable to image row in height
pdf_grid_all_frame = [pdf_row_number_all_frame, pdf_col_number_all_frame];

frame_number = length(statistic);

if(disp_CP_for_each_frame)
    pdf_row_number = 20;    %row means the first dimension, compatiable to image row in width
    pdf_col_number = 10;    %col means the second dimension, compatiable to image row in height
    pdf_grid = [pdf_row_number, pdf_col_number];
    for frame_no = 1 : frame_number
        %condition on residue data
        [joint_pdf, position] = hist3([statistic(frame_no).Y.whole_frame.residue, statistic(frame_no).Y.whole_frame.concealment_error], pdf_grid);
        axis_x = position{1};
        axis_y = position{2};

        marginal_pdf_on_resi = sum(joint_pdf, 2);
        conditional_pdf_on_resi = joint_pdf./kron(marginal_pdf_on_resi, ones(1, pdf_col_number));
        h = figure('Visible', 'on'); meshc(axis_y, axis_x, conditional_pdf_on_resi);
        xlabel('concealment error value'); ylabel('residue data value'); zlabel('conditional pdf');   %matlab seems plot row as xlabel
        title(sprintf('condition on residue data of %dth frame', frame_no));
        print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
        close(h)  %for saving memory

        %condition on concealment error
        marginal_pdf_on_conc = sum(joint_pdf, 1);
        conditional_pdf_on_conc = joint_pdf./kron(marginal_pdf_on_conc, ones(pdf_row_number, 1));
        h = figure('Visible', 'on'); meshc(axis_y, axis_x, conditional_pdf_on_conc);
        xlabel('concealment error value'); ylabel('residue data value'); zlabel('conditional pdf');   %matlab seems plot row as xlabel
        title(sprintf('condition on concealment error of %dth frame', frame_no));
        print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
        close(h)  %for saving memory
    end
end

buf_resi_Y_all_frame = [];
buf_conc_Y_all_frame = [];
for frame_no = 1: frame_number
    buf_resi_Y_all_frame = [buf_resi_Y_all_frame; statistic(frame_no).Y.whole_frame.residue];
    buf_conc_Y_all_frame = [buf_conc_Y_all_frame; statistic(frame_no).Y.whole_frame.concealment_error];
end

%to plot the conditional pdf of residue data and concealment error
%condition on residue data
[joint_pdf, position] = hist3([buf_resi_Y_all_frame, buf_conc_Y_all_frame], pdf_grid_all_frame);
axis_x = position{1};
axis_y = position{2};

marginal_pdf_on_resi = sum(joint_pdf, 2);
conditional_pdf_on_resi = joint_pdf./kron(marginal_pdf_on_resi, ones(1, pdf_col_number_all_frame));
h = figure; meshc(axis_y, axis_x, conditional_pdf_on_resi);
xlabel('concealment error value'); ylabel('residue data value'); zlabel('conditional pdf');   %matlab seems plot row as xlabel
title('condition on residue data of all frames');
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_condi_conc_pdf_on_resi', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_condi_conc_pdf_on_resi', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory


%condition on concealment error
marginal_pdf_on_conc = sum(joint_pdf, 1);
conditional_pdf_on_conc = joint_pdf./kron(marginal_pdf_on_conc, ones(pdf_row_number_all_frame, 1));
h = figure; meshc(axis_y, axis_x, conditional_pdf_on_conc);
xlabel('concealment error value'); ylabel('residue data value'); zlabel('conditional pdf');   %matlab seems plot row as xlabel
title('condition on concealment error of all frames');
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_condi_resi_pdf_on_conc', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_condi_resi_pdf_on_conc', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function CP_resi_pred(statistic, disp_CP_for_each_frame)

global folder_video
global video_name   %initialized in the main function
global channel_index    %initialized in the main function
global loop_counter %initialized in the main function

pdf_row_number_all_frame = 100;    %row means the first dimension, compatiable to image row in width
pdf_col_number_all_frame = 100;    %col means the second dimension, compatiable to image row in height
pdf_grid_all_frame = [pdf_row_number_all_frame, pdf_col_number_all_frame];

frame_number = length(statistic);

if(disp_CP_for_each_frame)
    pdf_row_number = 20;    %row means the first dimension, compatiable to image row in width
    pdf_col_number = 10;    %col means the second dimension, compatiable to image row in height
    pdf_grid = [pdf_row_number, pdf_col_number];
    for frame_no = 1 : frame_number
        %condition on residue data
        [joint_pdf, position] = hist3([statistic(frame_no).Y.whole_frame.residue, statistic(frame_no).Y.whole_frame.predicted], pdf_grid);
        axis_x = position{1};
        axis_y = position{2};

        marginal_pdf_on_resi = sum(joint_pdf, 2);
        conditional_pdf_on_resi = joint_pdf./kron(marginal_pdf_on_resi, ones(1, pdf_col_number));
        h = figure('Visible', 'on'); meshc(axis_y, axis_x, conditional_pdf_on_resi);
        xlabel('predicted pixel value'); ylabel('residue data value'); zlabel('conditional pdf');   %matlab seems plot row as xlabel
        title(sprintf('condition on residue data of %dth frame', frame_no));
        print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
        close(h)  %for saving memory

        %condition on predicted pixel value
        marginal_pdf_on_pred = sum(joint_pdf, 1);
        conditional_pdf_on_pred = joint_pdf./kron(marginal_pdf_on_pred, ones(pdf_row_number, 1));
        h = figure('Visible', 'on'); meshc(axis_y, axis_x, conditional_pdf_on_pred);
        xlabel('predicted pixel value'); ylabel('residue data value'); zlabel('conditional pdf');   %matlab seems plot row as xlabel
        title(sprintf('condition on predicted pixel value of %dth frame', frame_no));
        print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
        close(h)  %for saving memory

        conditional_pdf_on_pred_log = log10(conditional_pdf_on_pred);
        h = figure('Visible', 'on'); meshc(axis_y, axis_x, conditional_pdf_on_pred_log);
        xlabel('predicted pixel value'); ylabel('residue data value'); zlabel('conditional pdf by log');   %matlab seems plot row as xlabel
        title(sprintf('condition on predicted pixel value of %dth frame', frame_no));
        print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
        close(h)  %for saving memory
    end
end

buf_resi_Y_all_frame = [];
buf_pred_Y_all_frame = [];
for frame_no = 1: frame_number
    buf_resi_Y_all_frame = [buf_resi_Y_all_frame; statistic(frame_no).Y.whole_frame.residue];
    buf_pred_Y_all_frame = [buf_pred_Y_all_frame; statistic(frame_no).Y.whole_frame.predicted];
end

%to plot the conditional pdf of residue data and predicted pixel value
%condition on residue data
[joint_pdf, position] = hist3([buf_resi_Y_all_frame, buf_pred_Y_all_frame], pdf_grid_all_frame);
axis_x = position{1};
axis_y = position{2};

marginal_pdf_on_resi = sum(joint_pdf, 2);
conditional_pdf_on_resi = joint_pdf./kron(marginal_pdf_on_resi, ones(1, pdf_col_number_all_frame));
h = figure; meshc(axis_y, axis_x, conditional_pdf_on_resi);
xlabel('predicted pixel value'); ylabel('residue data value'); zlabel('conditional pdf');   %matlab seems plot row as xlabel
title('condition on residue data of all frames');
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_condi_pred_pdf_on_resi', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_condi_pred_pdf_on_resi', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory

%condition on predicted pixel value
marginal_pdf_on_pred = sum(joint_pdf, 1);
conditional_pdf_on_pred = joint_pdf./kron(marginal_pdf_on_pred, ones(pdf_row_number_all_frame, 1));
h = figure; meshc(axis_y, axis_x, conditional_pdf_on_pred);
xlabel('predicted pixel value'); ylabel('residue data value'); zlabel('conditional pdf');   %matlab seems plot row as xlabel
title('condition on predicted pixel value of all frames');
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_condi_resi_pdf_on_pred', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_condi_resi_pdf_on_pred', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory

conditional_pdf_on_pred_log = log10(conditional_pdf_on_pred);
h = figure; meshc(axis_y, axis_x, conditional_pdf_on_pred_log);
xlabel('predicted pixel value'); ylabel('residue data value'); zlabel('conditional pdf by log');   %matlab seems plot row as xlabel
title('condition on predicted pixel value by log of all frames');
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_condi_resi_pdf_on_pred_log', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_condi_resi_pdf_on_pred_log', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function CP_resi_recon(statistic, disp_CP_for_each_frame)

global folder_video
global video_name   %initialized in the main function
global channel_index    %initialized in the main function
global loop_counter %initialized in the main function

pdf_row_number_all_frame = 100;    %row means the first dimension, compatiable to image row in width
pdf_col_number_all_frame = 100;    %col means the second dimension, compatiable to image row in height
pdf_grid_all_frame = [pdf_row_number_all_frame, pdf_col_number_all_frame];

frame_number = length(statistic);

if(disp_CP_for_each_frame)
    pdf_row_number = 20;    %row means the first dimension, compatiable to image row in width
    pdf_col_number = 10;    %col means the second dimension, compatiable to image row in height
    pdf_grid = [pdf_row_number, pdf_col_number];
    for frame_no = 1 : frame_number
        %condition on residue data
        [joint_pdf, position] = hist3([statistic(frame_no).Y.whole_frame.residue, statistic(frame_no).Y.whole_frame.reconstructed], pdf_grid);
        axis_x = position{1};
        axis_y = position{2};
        marginal_pdf_on_resi = sum(joint_pdf, 2);
        conditional_pdf_on_resi = joint_pdf./kron(marginal_pdf_on_resi, ones(1, pdf_col_number));
        h = figure('Visible', 'on'); meshc(axis_y, axis_x, conditional_pdf_on_resi);
        xlabel('reconstructed pixel value'); ylabel('residue data value'); zlabel('conditional pdf');   %matlab seems plot row as xlabel
        title(sprintf('condition on residue data of %dth frame', frame_no));
        print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
        close(h)  %for saving memory

        %condition on reconstructed pixel value
        marginal_pdf_on_recon = sum(joint_pdf, 1);
        conditional_pdf_on_recon = joint_pdf./kron(marginal_pdf_on_recon, ones(pdf_row_number, 1));
        h = figure('Visible', 'on'); meshc(axis_y, axis_x, conditional_pdf_on_recon);
        xlabel('reconstructed pixel value'); ylabel('residue data value'); zlabel('conditional pdf');   %matlab seems plot row as xlabel
        title(sprintf('condition on reconstructed pixel value of %dth frame', frame_no));
        print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
        close(h)  %for saving memory

        conditional_pdf_on_recon_log = log10(conditional_pdf_on_recon);
        h = figure('Visible', 'on'); meshc(axis_y, axis_x, conditional_pdf_on_recon_log);
        xlabel('predicted pixel value'); ylabel('residue data value'); zlabel('conditional pdf by log');   %matlab seems plot row as xlabel
        title(sprintf('condition on predicted pixel value of %dth frame', frame_no));
        print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
        close(h)  %for saving memory
    end
end

buf_resi_Y_all_frame = [];
buf_recon_Y_all_frame = [];
for frame_no = 1: frame_number
    buf_resi_Y_all_frame = [buf_resi_Y_all_frame; statistic(frame_no).Y.whole_frame.residue];
    buf_recon_Y_all_frame = [buf_recon_Y_all_frame; statistic(frame_no).Y.whole_frame.reconstructed];
end

%to plot the conditional pdf of residue data and reconstructed error
%condition on residue data
[joint_pdf, position] = hist3([buf_resi_Y_all_frame, buf_recon_Y_all_frame], pdf_grid_all_frame);
axis_x = position{1};
axis_y = position{2};

marginal_pdf_on_resi = sum(joint_pdf, 2);
conditional_pdf_on_resi = joint_pdf./kron(marginal_pdf_on_resi, ones(1, pdf_col_number_all_frame));
h = figure; meshc(axis_y, axis_x, conditional_pdf_on_resi);
xlabel('reconstructed pixel value'); ylabel('residue data value'); zlabel('conditional pdf');   %matlab seems plot row as xlabel
title('condition on residue data of all frames');
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_condi_recon_pdf_on_resi', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_condi_recon_pdf_on_resi', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory

%condition on reconstructed error
marginal_pdf_on_recon = sum(joint_pdf, 1);
conditional_pdf_on_recon = joint_pdf./kron(marginal_pdf_on_recon, ones(pdf_row_number_all_frame, 1));
h = figure; meshc(axis_y, axis_x, conditional_pdf_on_recon);
xlabel('reconstructed pixel value'); ylabel('residue data value'); zlabel('conditional pdf');   %matlab seems plot row as xlabel
title('condition on reconstructed pixel value of all frames');
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_condi_resi_pdf_on_recon', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_condi_resi_pdf_on_recon', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory

conditional_pdf_on_recon_log = log10(conditional_pdf_on_recon);
h = figure; meshc(axis_y, axis_x, conditional_pdf_on_recon_log);
xlabel('reconstructed pixel value'); ylabel('residue data value'); zlabel('conditional pdf by log');   %matlab seems plot row as xlabel
title('condition on reconstructed pixel value by log of all frames');
%print(h, '-depsc', sprintf('%s\\%s_channel_%d_loop_%d_condi_resi_pdf_on_recon_log', folder_video, video_name, channel_index, loop_counter));
saveas(h, sprintf('%s\\%s_channel_%d_loop_%d_condi_resi_pdf_on_recon_log', folder_video, video_name, channel_index, loop_counter), 'fig');
print(h, '-dpsc', '-append', sprintf('%s\\%s_channel_%d_loop_%d_assumption_verify', folder_video, video_name, channel_index, loop_counter));
close(h)  %for saving memory
