%--------------------------------------------------------------------------
%this function implements different distortion
%prediction algorithms, which support both test channel and random channel
%
%Chen Zhifeng
%UFID 12181197
%2008-07-17
%zhifeng@ecel.ufl.edu
%--------------------------------------------------------------------------
function distortion = algorithm_implement(statistic, statistic_last, frame_no, distortion_last, para_image, para_chan, alg_method, input)
%there are two options for feedback, 32 options for correlation_option(5 correlation coefficients)
%please refer to algorithms.xls for more information
global f_debug;
global block_size

image_width = para_image.width;
image_height = para_image.height;

pixel_per_frame = image_width * image_height;

switch para_chan.channel_type
    case 'R'
        PER_A = para_chan.input_DPA;
        PER_B = para_chan.input_DPB;
        PER_C = para_chan.input_DPC;
    case 'D'
        PER_A = 0;
        PER_B = 0;
        PER_C = 0;
    otherwise
        output_message('Warning: unknown channel type');
end

%suppose packet lost between residue data packets and motion vector packets are independent
LossRateAA = PER_A * PER_A;
LossRateAC = PER_A * PER_C;
LossRateCC = PER_C * PER_C;

%we need to get the five correlation coefficients bit mask from the
%correlation_option
bit_mask_rho_crcc = mod(input, 2);
bit_mask_rho_crlr = mod(floor(input/2), 2);
bit_mask_rho_crlc = mod(floor(input/4), 2);
bit_mask_rho_cclr = mod(floor(input/8), 2);
bit_mask_rho_cclc = mod(floor(input/16), 2);


switch alg_method
    case 0  %old method
        distortion.Y.residue = statistic.Y.whole_frame.residue_MSE * PER_C;
        distortion.Y.concealment_error = statistic.Y.whole_frame.concealment_error_MSE * PER_A;
        error_prop_factor = 1;

        distortion.Y.prop = distortion_last.Y.estimated * error_prop_factor;

%         adjust_crcc = 2* statistic.Y.whole_frame.rho_curr_resi_curr_conc * (statistic.Y.whole_frame.residue_MSE * statistic.Y.whole_frame.concealment_error_MSE)^.5 * LossRateAC;
%         adjust_crlr = 2* statistic.Y.whole_frame.rho_curr_resi_last_resi * (statistic.Y.whole_frame.residue_MSE * statistic_last.Y.whole_frame.residue_MSE)^.5 * LossRateCC;
%         adjust_crlc = 2* statistic.Y.whole_frame.rho_curr_resi_last_conc * (statistic.Y.whole_frame.residue_MSE * statistic_last.Y.whole_frame.concealment_error_MSE)^.5 * LossRateAC;
%         adjust_cclr = 2* statistic.Y.whole_frame.rho_curr_conc_last_resi * (statistic.Y.whole_frame.concealment_error_MSE * statistic_last.Y.whole_frame.residue_MSE)^.5 * LossRateAC;
%         adjust_cclc = 2* statistic.Y.whole_frame.rho_curr_conc_last_conc * (statistic.Y.whole_frame.concealment_error_MSE * statistic_last.Y.whole_frame.concealment_error_MSE)^.5 * LossRateAA;
% 
%         %here should not be used, that is, should be set to 0
%         distortion.Y.adjusted = adjust_crcc*bit_mask_rho_crcc + adjust_crlr*bit_mask_rho_crlr + adjust_crlc*bit_mask_rho_crlc + adjust_cclr*bit_mask_rho_cclr + adjust_cclc*bit_mask_rho_cclc;
        
        adjust_crcc = 2* statistic.Y.whole_frame.rho_curr_resi_curr_conc * (statistic.Y.whole_frame.residue_MSE * statistic.Y.whole_frame.concealment_error_MSE)^.5 * PER_A;
        adjust_cclr = 2* statistic.Y.whole_frame.rho_curr_conc_last_resi * (statistic.Y.whole_frame.concealment_error_MSE * statistic_last.Y.whole_frame.residue_MSE)^.5 * PER_A;
        adjust_cclc = 2* statistic.Y.whole_frame.rho_curr_conc_last_conc * (statistic.Y.whole_frame.concealment_error_MSE * statistic_last.Y.whole_frame.concealment_error_MSE)^.5 * LossRateAA;

        %here is the actual adjusted value
        distortion.Y.adjusted = adjust_crcc*bit_mask_rho_crcc + adjust_cclr*bit_mask_rho_cclr + adjust_cclc*bit_mask_rho_cclc;
        
        distortion.Y.estimated = distortion.Y.residue + distortion.Y.concealment_error + distortion.Y.prop + distortion.Y.adjusted; 
        
    case 1  %recursively adjusted
        distortion.Y.residue = statistic.Y.whole_frame.residue_MSE * PER_C;
        distortion.Y.concealment_error = statistic.Y.whole_frame.concealment_error_MSE * PER_A;
        error_prop_factor = 1;

        distortion.Y.prop = distortion_last.Y.estimated * error_prop_factor;
        distortion.Y.adjusted = distortion_last.Y.adjusted - 2*LossRateAA*statistic_last.Y.whole_frame.residue_MSE;
        distortion.Y.estimated = distortion.Y.residue + distortion.Y.concealment_error + distortion.Y.prop + distortion.Y.adjusted; 
    case 2  %assume correlation only between the consecutive parameters
        distortion.Y.residue = statistic.Y.whole_frame.residue_MSE * PER_C;
        distortion.Y.concealment_error = statistic.Y.whole_frame.concealment_error_MSE * PER_A;
        error_prop_factor = 1;

        distortion.Y.prop = distortion_last.Y.estimated * error_prop_factor;

        adjust_crlr = 2* statistic.Y.whole_frame.rho_curr_resi_last_resi * (statistic.Y.whole_frame.residue_MSE * statistic_last.Y.whole_frame.residue_MSE)^.5 * PER_C;
        adjust_cclc = 2* statistic.Y.whole_frame.rho_curr_conc_last_conc * (statistic.Y.whole_frame.concealment_error_MSE * statistic_last.Y.whole_frame.concealment_error_MSE)^.5 * PER_A;

        %here is the actual adjusted value
        distortion.Y.adjusted = adjust_crlr + adjust_cclc;
        
        distortion.Y.estimated = distortion.Y.residue + distortion.Y.concealment_error + distortion.Y.prop + distortion.Y.adjusted; 
        
    case 3
        
        distortion.Y.residue = statistic.Y.whole_frame.residue_MSE * PER_C;
        distortion.Y.concealment_error = statistic.Y.whole_frame.concealment_error_MSE * PER_A;
        error_prop_factor = 1;

        distortion.Y.prop = distortion_last.Y.estimated * error_prop_factor;

        adjust_cclr = 2* statistic.Y.whole_frame.rho_curr_conc_last_resi * (statistic.Y.whole_frame.concealment_error_MSE * statistic_last.Y.whole_frame.residue_MSE)^.5 * PER_A;
        LossRateA_acc = PER_A * (1-(1-PER_A)^(frame_no-2));
        adjust_cclc = 2* statistic.Y.whole_frame.rho_curr_conc_last_conc * (statistic.Y.whole_frame.concealment_error_MSE * statistic_last.Y.whole_frame.concealment_error_MSE)^.5 * LossRateA_acc;

        %here is the actual adjusted value
        distortion.Y.adjusted = adjust_cclr + adjust_cclc;
        
        distortion.Y.estimated = distortion.Y.residue + distortion.Y.concealment_error + distortion.Y.prop + distortion.Y.adjusted; 
        
    case 99
        
        distortion.Y.residue = statistic.Y.whole_frame.residue_MSE * PER_C;
        distortion.Y.concealment_error = statistic.Y.whole_frame.concealment_error_MSE * PER_A;
        error_prop_factor = 1;

        distortion.Y.prop = distortion_last.Y.estimated * error_prop_factor;

        LossRateA_acc = 1-(1-PER_A)^(frame_no-2);
        adjust_crlr_align = 2* statistic.Y.whole_frame.rho_crlr_align * (statistic.Y.whole_frame.residue_MSE * statistic_last.Y.whole_frame.residue_MSE)^.5 * LossRateA_acc * PER_C;
        adjust_crlc_align = 2* statistic.Y.whole_frame.rho_crlc_align * (statistic.Y.whole_frame.residue_MSE * statistic_last.Y.whole_frame.concealment_error_MSE)^.5 * LossRateA_acc * PER_C;
        adjust_curr_conc_last_recon = 2* statistic.Y.whole_frame.rho_curr_conc_last_recon * (statistic.Y.whole_frame.concealment_error_MSE * statistic_last.Y.whole_frame.reconstructed_var)^.5 * LossRateA_acc * PER_A;

        %here is the actual adjusted value
        distortion.Y.adjusted = adjust_crlr_align + adjust_crlc_align + adjust_curr_conc_last_recon;
        
        distortion.Y.estimated = distortion.Y.residue + distortion.Y.concealment_error + distortion.Y.prop + distortion.Y.adjusted; 

    case 4
        
        distortion.Y.residue = statistic.Y.whole_frame.residue_MSE * PER_C;
        distortion.Y.concealment_error = statistic.Y.whole_frame.concealment_error_MSE * PER_A;
        error_prop_factor = 1;

        distortion.Y.prop = distortion_last.Y.estimated * error_prop_factor;

        adjust_crlr_align = 2* statistic.Y.whole_frame.rho_crlr_align * (statistic.Y.whole_frame.residue_MSE * statistic_last.Y.whole_frame.residue_MSE)^.5 * PER_C;
        adjust_crlc_align = 2* statistic.Y.whole_frame.rho_crlc_align * (statistic.Y.whole_frame.residue_MSE * statistic_last.Y.whole_frame.concealment_error_MSE)^.5 * PER_C;
        LossRateA_acc = 1-(1-PER_A)^(frame_no-2);
        adjust_cclr = 2* statistic.Y.whole_frame.rho_curr_conc_last_resi * (statistic.Y.whole_frame.concealment_error_MSE * statistic_last.Y.whole_frame.residue_MSE)^.5 * LossRateA_acc * PER_A;
        adjust_cclc = 2* statistic.Y.whole_frame.rho_curr_conc_last_conc * (statistic.Y.whole_frame.concealment_error_MSE * statistic_last.Y.whole_frame.concealment_error_MSE)^.5 * LossRateA_acc * PER_A;

        %here is the actual adjusted value
        distortion.Y.adjusted = adjust_crlr_align + adjust_crlc_align + adjust_cclr + adjust_cclc;
        
        distortion.Y.estimated = distortion.Y.residue + distortion.Y.concealment_error + distortion.Y.prop + distortion.Y.adjusted; 

    case 5
        
        distortion.Y.residue = statistic.Y.whole_frame.residue_MSE * PER_C;
        distortion.Y.concealment_error = statistic.Y.whole_frame.concealment_error_MSE * PER_A;
        error_prop_factor = 1;

        distortion.Y.prop = distortion_last.Y.estimated * error_prop_factor;

        LossRateA_acc = 1-(1-PER_A)^(frame_no-2);
        adjust_curr_resi_curr_conc = 2*statistic.Y.whole_frame.rho_curr_resi_curr_conc * (statistic.Y.whole_frame.residue_MSE*statistic.Y.whole_frame.concealment_error_MSE)^.5 * LossRateA_acc * PER_A;;
        adjust_curr_conc_last_recon = 2* statistic.Y.whole_frame.rho_curr_conc_last_recon * (statistic.Y.whole_frame.concealment_error_MSE * statistic_last.Y.whole_frame.reconstructed_var)^.5 * LossRateA_acc * PER_A;

        %here is the actual adjusted value
        distortion.Y.adjusted = adjust_curr_conc_last_recon + adjust_curr_resi_curr_conc;
        
        distortion.Y.estimated = distortion.Y.residue + distortion.Y.concealment_error + distortion.Y.prop + distortion.Y.adjusted; 
        

    case 6
        
        distortion.Y.residue = statistic.Y.whole_frame.residue_MSE * PER_C;
        distortion.Y.concealment_error = statistic.Y.whole_frame.concealment_error_MSE * PER_A;
        error_prop_factor = 1;

        distortion.Y.prop = distortion_last.Y.estimated * error_prop_factor;

        LossRateA_acc = 1-(1-PER_A)^(frame_no-2);   %frame_no-1-IDR
        adjust_resi_pred = 2* statistic.Y.whole_frame.rho_resi_pred * (statistic.Y.whole_frame.residue_MSE * statistic_last.Y.whole_frame.predicted_var)^.5 * LossRateA_acc * PER_C;
        adjust_curr_conc_last_recon = 2* statistic.Y.whole_frame.rho_curr_conc_last_recon * (statistic.Y.whole_frame.concealment_error_MSE * statistic_last.Y.whole_frame.reconstructed_var)^.5 * LossRateA_acc * PER_A;

        %here is the actual adjusted value
        distortion.Y.adjusted = adjust_resi_pred + adjust_curr_conc_last_recon;
        
        distortion.Y.estimated = distortion.Y.residue + distortion.Y.concealment_error + distortion.Y.prop + distortion.Y.adjusted; 

    case 7
        
        distortion.Y.residue = statistic.Y.whole_frame.residue_MSE * PER_C;
        distortion.Y.concealment_error = statistic.Y.whole_frame.concealment_error_MSE * PER_A;
        error_prop_factor = 1;

        distortion.Y.prop = distortion_last.Y.estimated * error_prop_factor;

        LossRateA_acc = 1-(1-PER_A)^(frame_no-2);   %frame_no-1-IDR
        if mean(statistic.MV.whole_frame.length) > block_size/2
            adjust_resi_pred = 2* statistic.Y.whole_frame.rho_resi_pred * (statistic.Y.whole_frame.residue_MSE * statistic_last.Y.whole_frame.predicted_var)^.5 * LossRateA_acc * PER_C;
        else
            adjust_resi_pred = 0;
        end
        adjust_curr_conc_last_recon = 2* statistic.Y.whole_frame.rho_curr_conc_last_recon * (statistic.Y.whole_frame.concealment_error_MSE * statistic_last.Y.whole_frame.reconstructed_var)^.5 * LossRateA_acc * PER_A;

        %here is the actual adjusted value
        distortion.Y.adjusted = adjust_resi_pred + adjust_curr_conc_last_recon;
        
        distortion.Y.estimated = distortion.Y.residue + distortion.Y.concealment_error + distortion.Y.prop + distortion.Y.adjusted; 

    case 8
        
        distortion.Y.residue = statistic.Y.whole_frame.residue_MSE * PER_C;
        distortion.Y.concealment_error = statistic.Y.whole_frame.concealment_error_MSE * PER_A;
        error_prop_factor = 1;

        distortion.Y.prop = distortion_last.Y.estimated * error_prop_factor;

        adjust_crlr = 2* statistic.Y.whole_frame.rho_crlr_align * (statistic.Y.whole_frame.residue_MSE * statistic_last.Y.whole_frame.residue_MSE)^.5 * PER_C;
        LossRateA_acc = 1-(1-PER_A)^(frame_no-2);   %frame_no-1-IDR
        adjust_curr_conc_last_recon = 2* statistic.Y.whole_frame.rho_curr_conc_last_recon * (statistic.Y.whole_frame.concealment_error_MSE * statistic_last.Y.whole_frame.reconstructed_var)^.5 * LossRateA_acc * PER_A;

        %here is the actual adjusted value
        distortion.Y.adjusted = adjust_crlr + adjust_curr_conc_last_recon;
        
        distortion.Y.estimated = distortion.Y.residue + distortion.Y.concealment_error + distortion.Y.prop + distortion.Y.adjusted; 

    case 9
        
        distortion.Y.residue = statistic.Y.whole_frame.residue_MSE * PER_C;
        distortion.Y.concealment_error = statistic.Y.whole_frame.concealment_error_MSE * PER_A;
        error_prop_factor = 1;

        distortion.Y.prop = distortion_last.Y.estimated * error_prop_factor;

        adjust_crlr = 2* statistic.Y.whole_frame.rho_crlr_align * (statistic.Y.whole_frame.residue_MSE * statistic_last.Y.whole_frame.residue_MSE)^.5 * PER_C;
        adjust_crlc = 2* statistic.Y.whole_frame.rho_crlc_align * (statistic.Y.whole_frame.residue_MSE * statistic_last.Y.whole_frame.concealment_error_MSE)^.5 * PER_C;
        LossRateA_acc = 1-(1-PER_A)^(frame_no-2);   %frame_no-1-IDR
        adjust_curr_conc_last_recon = 2* statistic.Y.whole_frame.rho_curr_conc_last_recon * (statistic.Y.whole_frame.concealment_error_MSE * statistic_last.Y.whole_frame.reconstructed_var)^.5 * LossRateA_acc * PER_A;

        %here is the actual adjusted value
        distortion.Y.adjusted = adjust_crlr + adjust_crlc + adjust_curr_conc_last_recon;
        
        distortion.Y.estimated = distortion.Y.residue + distortion.Y.concealment_error + distortion.Y.prop + distortion.Y.adjusted; 
    case 10
        
        distortion.Y.residue = statistic.Y.whole_frame.residue_MSE * PER_C;
        distortion.Y.concealment_error = statistic.Y.whole_frame.concealment_error_MSE * PER_A;
        if (PER_C == 0 & PER_A > 0)
            error_prop_factor = statistic.Y.whole_frame.prop_clip_conc_factor;
        elseif (PER_C > 0 & PER_A == 0)
            error_prop_factor = statistic.Y.whole_frame.prop_clip_resi_factor;
        elseif (PER_C > 0 & PER_A > 0)
            error_prop_factor = statistic.Y.whole_frame.prop_clip_both_factor;
        else
            error_prop_factor = 1;
        end
        
        %error_prop_factor = statistic.Y.whole_frame.prop_clip_both_factor;

        distortion.Y.prop = distortion_last.Y.estimated * error_prop_factor;

        LossRateA_acc = 1-(1-PER_A)^(frame_no-2);   %frame_no-1-IDR
        adjust_curr_conc_last_recon = 2* statistic.Y.whole_frame.rho_curr_conc_last_recon * (statistic.Y.whole_frame.concealment_error_MSE * statistic_last.Y.whole_frame.reconstructed_var)^.5 * LossRateA_acc * PER_A;

        %here is the actual adjusted value
        distortion.Y.adjusted = 0;
        
        distortion.Y.estimated = distortion.Y.residue + distortion.Y.concealment_error + distortion.Y.prop + distortion.Y.adjusted; 

    case 11
        
        distortion.Y.residue = statistic.Y.whole_frame.residue_MSE * PER_C;
        distortion.Y.concealment_error = statistic.Y.whole_frame.concealment_error_MSE * PER_A;

        probability_error_accumulated = 0;
        error_prop_factor = PER_C*(1-PER_A)*statistic.Y.whole_frame.prop_clip_resi_factor + PER_A*(1-PER_C)*statistic.Y.whole_frame.prop_clip_conc_factor + (PER_A*PER_C + probability_error_accumulated)* statistic.Y.whole_frame.prop_clip_both_factor + (1-PER_A)*(1-PER_C)-probability_error_accumulated;

        distortion.Y.prop = distortion_last.Y.estimated * error_prop_factor;

        LossRateA_acc = 1-(1-PER_A)^(frame_no-2);   %frame_no-1-IDR
        adjust_curr_conc_last_recon = 2* statistic.Y.whole_frame.rho_curr_conc_last_recon * (statistic.Y.whole_frame.concealment_error_MSE * statistic_last.Y.whole_frame.reconstructed_var)^.5 * LossRateA_acc * PER_A;

        %here is the actual adjusted value
        distortion.Y.adjusted = adjust_curr_conc_last_recon;
        
        distortion.Y.estimated = distortion.Y.residue + distortion.Y.concealment_error + distortion.Y.prop + distortion.Y.adjusted; 

        
    case 12
        
        distortion.Y.residue = statistic.Y.whole_frame.residue_MSE * PER_C;
        distortion.Y.concealment_error = statistic.Y.whole_frame.concealment_error_MSE * PER_A;
        
        probability_error_accumulated = 1-((1-PER_A)*(1-PER_C))^(frame_no-2);
        error_prop_factor = PER_C*(1-PER_A)*statistic.Y.whole_frame.prop_clip_resi_factor + PER_A*(1-PER_C)*statistic.Y.whole_frame.prop_clip_conc_factor + (PER_A*PER_C + probability_error_accumulated)* statistic.Y.whole_frame.prop_clip_both_factor + (1-PER_A)*(1-PER_C)-probability_error_accumulated;

        distortion.Y.prop = distortion_last.Y.estimated * error_prop_factor;

        LossRateA_acc = 1-(1-PER_A)^(frame_no-2);   %frame_no-1-IDR
        adjust_curr_resi_curr_conc = 2*statistic.Y.whole_frame.rho_curr_resi_curr_conc * (statistic.Y.whole_frame.residue_MSE*statistic.Y.whole_frame.concealment_error_MSE)^.5 * LossRateA_acc * PER_A;
        adjust_curr_conc_last_recon = 2* statistic.Y.whole_frame.rho_curr_conc_last_recon * (statistic.Y.whole_frame.concealment_error_MSE * statistic_last.Y.whole_frame.reconstructed_var)^.5 * LossRateA_acc * PER_A;

        %here is the actual adjusted value
        distortion.Y.adjusted = adjust_curr_conc_last_recon + adjust_curr_resi_curr_conc;
        
        distortion.Y.estimated = distortion.Y.residue + distortion.Y.concealment_error + distortion.Y.prop + distortion.Y.adjusted; 

    case 13 %use residue data variance over accumulated reconstructed difference, with MV correlation
        
        distortion.Y.residue = statistic.Y.whole_frame.residue_MSE * PER_C;
        distortion.Y.concealment_error = statistic.Y.whole_frame.concealment_error_MSE * PER_A;
        
        scaler_resi = (distortion_last.Y.estimated / statistic.Y.whole_frame.residue_MSE)^0.5;
        scaler_both = (distortion_last.Y.estimated / statistic.Y.whole_frame.both_error_MSE)^0.5;

        distortion.Y.prop = PER_C * distortion_last.Y.estimated ...
            + (1-PER_C)*PER_A*sum((statistic.Y.whole_frame.reconstructed-statistic.Y.whole_frame.concealment_error_clip-clip_vector(statistic.Y.whole_frame.reconstructed-statistic.Y.whole_frame.concealment_error_clip+scaler_resi*statistic.Y.whole_frame.residue, 'Phi_function')).^2)/pixel_per_frame...
            + (1-PER_C)*(1-PER_A)*sum((statistic.Y.whole_frame.reconstructed-clip_vector(statistic.Y.whole_frame.reconstructed+scaler_resi*statistic.Y.whole_frame.both_error, 'Phi_function')).^2)/pixel_per_frame;

        LossRateA_acc = 1-(1-PER_A)^(frame_no-2);   %frame_no-1-IDR
        adjust_curr_conc_last_recon = 2* statistic.Y.whole_frame.rho_curr_conc_last_recon * (statistic.Y.whole_frame.concealment_error_MSE * statistic_last.Y.whole_frame.reconstructed_var)^.5 * LossRateA_acc * PER_A;

        %here is the actual adjusted value
        distortion.Y.adjusted = adjust_curr_conc_last_recon;
        
        distortion.Y.estimated = distortion.Y.residue + distortion.Y.concealment_error + distortion.Y.prop + distortion.Y.adjusted; 

    case 14 %use residue data variance over accumulated reconstructed difference, without MV correlation
        
        distortion.Y.residue = statistic.Y.whole_frame.residue_MSE * PER_C;
        distortion.Y.concealment_error = statistic.Y.whole_frame.concealment_error_MSE * PER_A;
        
        scaler_resi = (distortion_last.Y.estimated / statistic.Y.whole_frame.residue_MSE)^0.5;
        scaler_both = (distortion_last.Y.estimated / statistic.Y.whole_frame.both_error_MSE)^0.5;

        distortion.Y.prop = PER_C * distortion_last.Y.estimated ...
            + (1-PER_C)*PER_A*sum((statistic.Y.whole_frame.reconstructed-statistic.Y.whole_frame.concealment_error_clip-clip_vector(statistic.Y.whole_frame.reconstructed-statistic.Y.whole_frame.concealment_error_clip+scaler_resi*statistic.Y.whole_frame.residue, 'Phi_function')).^2)/pixel_per_frame...
            + (1-PER_C)*(1-PER_A)*sum((statistic.Y.whole_frame.reconstructed-clip_vector(statistic.Y.whole_frame.reconstructed+scaler_resi*statistic.Y.whole_frame.both_error, 'Phi_function')).^2)/pixel_per_frame;

        LossRateA_acc = 1-(1-PER_A)^(frame_no-2);   %frame_no-1-IDR
        adjust_curr_conc_last_recon = 2* statistic.Y.whole_frame.rho_curr_conc_last_recon * (statistic.Y.whole_frame.concealment_error_MSE * statistic_last.Y.whole_frame.reconstructed_var)^.5 * LossRateA_acc * PER_A;

        %here is the actual adjusted value
        distortion.Y.adjusted = 0;
        
        distortion.Y.estimated = distortion.Y.residue + distortion.Y.concealment_error + distortion.Y.prop + distortion.Y.adjusted; 

    case 15
        
        distortion.Y.residue = statistic.Y.whole_frame.residue_MSE * PER_C;
        distortion.Y.concealment_error = statistic.Y.whole_frame.concealment_error_MSE * PER_A;
        
        error_prop_factor = PER_C*statistic.Y.whole_frame.prop_clip_resi_factor + PER_A*statistic.Y.whole_frame.prop_clip_conc_factor + (1-PER_C-PER_A);
        distortion.Y.prop = (PER_C + (1-PER_C)*error_prop_factor)*distortion_last.Y.estimated;

        LossRateA_acc = 1-(1-PER_A)^(frame_no-2);   %frame_no-1-IDR
        adjust_curr_resi_curr_conc = 2 * statistic.Y.whole_frame.rho_curr_resi_curr_conc * (statistic.Y.whole_frame.residue_MSE*statistic.Y.whole_frame.concealment_error_MSE)^.5 * LossRateA_acc * PER_A;
        adjust_curr_conc_last_recon = 2* statistic.Y.whole_frame.rho_curr_conc_last_recon * (statistic.Y.whole_frame.concealment_error_MSE * statistic_last.Y.whole_frame.reconstructed_var)^.5 * LossRateA_acc * PER_A;

        %here is the actual adjusted value
        distortion.Y.adjusted = adjust_curr_conc_last_recon + adjust_curr_resi_curr_conc;
        
        distortion.Y.estimated = distortion.Y.residue + distortion.Y.concealment_error + distortion.Y.prop + distortion.Y.adjusted; 

        
    case 16
        
        distortion.Y.residue = statistic.Y.whole_frame.residue_MSE * PER_C;
        distortion.Y.concealment_error = statistic.Y.whole_frame.concealment_error_MSE * PER_A;
        
        error_prop_factor = PER_C*statistic.Y.whole_frame.prop_clip_resi_factor + PER_A*statistic.Y.whole_frame.prop_clip_conc_factor + (1-PER_C-PER_A);
        distortion.Y.prop = (PER_C + (1-PER_C)*error_prop_factor)*distortion_last.Y.estimated;

        LossRateA_acc = 1-(1-PER_A)^(frame_no-2);   %frame_no-1-IDR
        adjust_curr_resi_curr_conc = 2 * statistic.Y.whole_frame.rho_curr_resi_curr_conc * (statistic.Y.whole_frame.residue_MSE*statistic.Y.whole_frame.concealment_error_MSE)^.5 * LossRateA_acc * PER_A;
        adjust_curr_conc_last_recon = 2* statistic.Y.whole_frame.rho_curr_conc_last_recon * (statistic.Y.whole_frame.concealment_error_MSE * statistic_last.Y.whole_frame.reconstructed_var)^.5 * LossRateA_acc * PER_A;

        %here is the actual adjusted value
        if mean(statistic.MV.whole_frame.length) > block_size/2
            distortion.Y.adjusted = adjust_curr_conc_last_recon + adjust_curr_resi_curr_conc;
        else
            distortion.Y.adjusted = 0;
        end
        
        distortion.Y.estimated = distortion.Y.residue + distortion.Y.concealment_error + distortion.Y.prop + distortion.Y.adjusted; 


        
    case 17
        
        distortion.Y.residue = statistic.Y.whole_frame.residue_MSE * PER_C;
        distortion.Y.concealment_error = statistic.Y.whole_frame.concealment_error_MSE * PER_A;
        
        %error_prop_factor = PER_C*statistic.Y.whole_frame.prop_clip_resi_factor + PER_A*statistic.Y.whole_frame.prop_clip_conc_factor + 1-PER_C-PER_A;
        distortion.Y.prop = PER_C*distortion_last.Y.estimated + (1-PER_C)*(distortion_last.Y.residue*statistic.Y.whole_frame.prop_clip_resi_factor + distortion_last.Y.concealment_error * statistic.Y.whole_frame.prop_clip_conc_factor + (distortion_last.Y.estimated-distortion_last.Y.residue-distortion_last.Y.concealment_error));

        LossRateA_acc = 1-(1-PER_A)^(frame_no-2);   %frame_no-1-IDR
        adjust_curr_resi_curr_conc = 2 * statistic.Y.whole_frame.rho_curr_resi_curr_conc * (statistic.Y.whole_frame.residue_MSE*statistic.Y.whole_frame.concealment_error_MSE)^.5 * LossRateA_acc * PER_A;
        adjust_curr_conc_last_recon = 2* statistic.Y.whole_frame.rho_curr_conc_last_recon * (statistic.Y.whole_frame.concealment_error_MSE * statistic_last.Y.whole_frame.reconstructed_var)^.5 * LossRateA_acc * PER_A;

        %here is the actual adjusted value
        distortion.Y.adjusted = adjust_curr_conc_last_recon + adjust_curr_resi_curr_conc;
        
        distortion.Y.estimated = distortion.Y.residue + distortion.Y.concealment_error + distortion.Y.prop + distortion.Y.adjusted; 

    case 18
        
        distortion.Y.residue = statistic.Y.whole_frame.residue_MSE * PER_C;
        distortion.Y.concealment_error = statistic.Y.whole_frame.concealment_error_MSE * PER_A;
        
        %error_prop_factor = PER_C*statistic.Y.whole_frame.prop_clip_resi_factor + PER_A*statistic.Y.whole_frame.prop_clip_conc_factor + 1-PER_C-PER_A;
        distortion.Y.prop = PER_C*distortion_last.Y.estimated + (1-PER_C)*(distortion_last.Y.residue*statistic.Y.whole_frame.prop_clip_resi_factor + distortion_last.Y.concealment_error * statistic.Y.whole_frame.prop_clip_conc_factor + (distortion_last.Y.estimated-distortion_last.Y.residue-distortion_last.Y.concealment_error));

        LossRateA_acc = 1-(1-PER_A)^(frame_no-2);   %frame_no-1-IDR
        adjust_curr_resi_curr_conc = 2 * statistic.Y.whole_frame.rho_curr_resi_curr_conc * (statistic.Y.whole_frame.residue_MSE*statistic.Y.whole_frame.concealment_error_MSE)^.5 * LossRateA_acc * PER_A;
        adjust_curr_conc_last_recon = 2* statistic.Y.whole_frame.rho_curr_conc_last_recon * (statistic.Y.whole_frame.concealment_error_MSE * statistic_last.Y.whole_frame.reconstructed_var)^.5 * LossRateA_acc * PER_A;


        %here is the actual adjusted value
        if mean(statistic.MV.whole_frame.length) > block_size/2
            distortion.Y.adjusted = adjust_curr_conc_last_recon + adjust_curr_resi_curr_conc;
        else
            distortion.Y.adjusted = 0;
        end
        
        distortion.Y.estimated = distortion.Y.residue + distortion.Y.concealment_error + distortion.Y.prop + distortion.Y.adjusted; 

        
         
    case 19
        
        distortion.Y.residue = statistic.Y.whole_frame.residue_MSE * PER_C;
        distortion.Y.concealment_error = statistic.Y.whole_frame.concealment_error_MSE * PER_A;
        
        %error_prop_factor = PER_C*statistic.Y.whole_frame.prop_clip_resi_factor + PER_A*statistic.Y.whole_frame.prop_clip_conc_factor + 1-PER_C-PER_A;
        distortion.Y.prop = PER_C*distortion_last.Y.estimated + (1-PER_C)*(distortion_last.Y.residue*statistic.Y.whole_frame.prop_clip_resi_factor + distortion_last.Y.concealment_error * statistic.Y.whole_frame.prop_clip_conc_factor + (distortion_last.Y.estimated-distortion_last.Y.residue-distortion_last.Y.concealment_error)*(statistic.Y.whole_frame.prop_clip_both_factor)^(1/(frame_no-2)));

        LossRateA_acc = 1-(1-PER_A)^((frame_no-1)/2);   %frame_no-1-IDR
        adjust_curr_resi_curr_conc = 2 * statistic.Y.whole_frame.rho_curr_resi_curr_conc * (statistic.Y.whole_frame.residue_MSE*statistic.Y.whole_frame.concealment_error_MSE)^.5 * LossRateA_acc * PER_A;
        adjust_curr_conc_last_recon = 2* statistic.Y.whole_frame.rho_curr_conc_last_recon * (statistic.Y.whole_frame.concealment_error_MSE * statistic_last.Y.whole_frame.reconstructed_var)^.5 * LossRateA_acc * PER_A;

        %here is the actual adjusted value
        distortion.Y.adjusted = adjust_curr_conc_last_recon + adjust_curr_resi_curr_conc;
        
        distortion.Y.estimated = distortion.Y.residue + distortion.Y.concealment_error + distortion.Y.prop + distortion.Y.adjusted; 

    case 20
        
        distortion.Y.residue = statistic.Y.whole_frame.residue_MSE * PER_C;
        distortion.Y.concealment_error = statistic.Y.whole_frame.concealment_error_MSE * PER_A;
        
        %error_prop_factor = PER_C*statistic.Y.whole_frame.prop_clip_resi_factor + PER_A*statistic.Y.whole_frame.prop_clip_conc_factor + 1-PER_C-PER_A;
        distortion.Y.prop = PER_C*distortion_last.Y.estimated + (1-PER_C)*(distortion_last.Y.residue*statistic.Y.whole_frame.prop_clip_resi_factor + distortion_last.Y.concealment_error * statistic.Y.whole_frame.prop_clip_conc_factor + (distortion_last.Y.estimated-distortion_last.Y.residue-distortion_last.Y.concealment_error)*(statistic.Y.whole_frame.prop_clip_resi_factor)^(2/(frame_no-1)));

        LossRateA_acc = 1-(1-PER_A)^((frame_no-2));   %frame_no-1-IDR
        %adjust_curr_resi_curr_conc = 2 * statistic.Y.whole_frame.rho_curr_resi_curr_conc * (statistic.Y.whole_frame.residue_MSE*statistic.Y.whole_frame.concealment_error_MSE)^.5 * LossRateA_acc * PER_A;
        adjust_curr_conc_last_recon = 2* statistic.Y.whole_frame.rho_curr_conc_last_recon * (statistic.Y.whole_frame.concealment_error_MSE * statistic_last.Y.whole_frame.reconstructed_var)^.5 * LossRateA_acc * PER_A;


        %here is the actual adjusted value
        if mean(statistic.MV.whole_frame.length) > block_size/2
            distortion.Y.adjusted = adjust_curr_conc_last_recon;
        else
            distortion.Y.adjusted = 0;
        end
        
        distortion.Y.estimated = distortion.Y.residue + distortion.Y.concealment_error + distortion.Y.prop + distortion.Y.adjusted; 

        
    case 21
        
        distortion.Y.residue = statistic.Y.whole_frame.residue_MSE * PER_C;
        distortion.Y.concealment_error = statistic.Y.whole_frame.concealment_error_MSE * PER_A;
        
        %error_prop_factor = PER_C*statistic.Y.whole_frame.prop_clip_resi_factor + PER_A*statistic.Y.whole_frame.prop_clip_conc_factor + 1-PER_C-PER_A;
        distortion.Y.prop = PER_C*distortion_last.Y.estimated + (1-PER_C)*(distortion_last.Y.residue*statistic.Y.whole_frame.prop_clip_resi_factor + distortion_last.Y.concealment_error * statistic.Y.whole_frame.prop_clip_conc_factor + (distortion_last.Y.estimated-distortion_last.Y.residue-distortion_last.Y.concealment_error)*(statistic.Y.whole_frame.prop_clip_resi_factor)^(2/(frame_no-1)));

        LossRateA_acc = 1-(1-PER_A)^((frame_no-2));   %frame_no-1-IDR
%         adjust_curr_resi_curr_conc = 2 * statistic.Y.whole_frame.rho_curr_resi_curr_conc * (statistic.Y.whole_frame.residue_MSE*statistic.Y.whole_frame.concealment_error_MSE)^.5 * LossRateA_acc * PER_A;
        adjust_curr_conc_last_recon = 2* statistic.Y.whole_frame.rho_curr_conc_last_recon * (statistic.Y.whole_frame.concealment_error_MSE * statistic_last.Y.whole_frame.reconstructed_var)^.5 * LossRateA_acc * PER_A;


        %here is the actual adjusted value
        if mean(statistic.MV.whole_frame.length) > block_size/(pi^.5)
            distortion.Y.adjusted = adjust_curr_conc_last_recon;
        else
            distortion.Y.adjusted = 0;
        end
        
        distortion.Y.estimated = distortion.Y.residue + distortion.Y.concealment_error + distortion.Y.prop + distortion.Y.adjusted; 

    case 22
        
        distortion.Y.residue = statistic.Y.whole_frame.residue_MSE * PER_C;
        distortion.Y.concealment_error = statistic.Y.whole_frame.concealment_error_MSE * PER_A;
        
        %error_prop_factor = PER_C*statistic.Y.whole_frame.prop_clip_resi_factor + PER_A*statistic.Y.whole_frame.prop_clip_conc_factor + 1-PER_C-PER_A;
        distortion.Y.prop = PER_C*distortion_last.Y.estimated + (1-PER_C)*(distortion_last.Y.residue*statistic.Y.whole_frame.prop_clip_resi_factor + distortion_last.Y.concealment_error * statistic.Y.whole_frame.prop_clip_conc_factor + (distortion_last.Y.estimated-distortion_last.Y.residue-distortion_last.Y.concealment_error)*(statistic.Y.whole_frame.prop_clip_resi_factor)^(2/(frame_no-1)));

        LossRateA_acc = 1-(1-PER_A)^((frame_no-2));   %frame_no-1-IDR
%         adjust_curr_resi_curr_conc = 2 * statistic.Y.whole_frame.rho_curr_resi_curr_conc * (statistic.Y.whole_frame.residue_MSE*statistic.Y.whole_frame.concealment_error_MSE)^.5 * LossRateA_acc * PER_A;
        adjust_curr_conc_last_recon = 2* statistic.Y.whole_frame.rho_curr_conc_last_recon * (statistic.Y.whole_frame.concealment_error_MSE * statistic_last.Y.whole_frame.reconstructed_var)^.5 * LossRateA_acc * PER_A;


        %here is the actual adjusted value
        if mean(statistic.MV.whole_frame.length) > block_size/(2^0.5)
            distortion.Y.adjusted = adjust_curr_conc_last_recon;
        else
            distortion.Y.adjusted = 0;
        end
        
        distortion.Y.estimated = distortion.Y.residue + distortion.Y.concealment_error + distortion.Y.prop + distortion.Y.adjusted; 


    case 23
        if frame_no <= 2
            prop_clip_factor_theoretical = 0;
        else
            prop_clip_factor_theoretical = clipping_factor(statistic.Y.whole_frame.reconstructed_mean, (distortion_last.Y.estimated/2)^0.5);
        end

        distortion.Y.residue = statistic.Y.whole_frame.residue_MSE * PER_C;
        distortion.Y.concealment_error = statistic.Y.whole_frame.concealment_error_MSE * PER_A;
        
        %error_prop_factor = PER_C*statistic.Y.whole_frame.prop_clip_resi_factor + PER_A*statistic.Y.whole_frame.prop_clip_conc_factor + 1-PER_C-PER_A;
        distortion.Y.prop = prop_clip_factor_theoretical*distortion_last.Y.estimated;

        LossRateA_acc = 1-(1-PER_A)^((frame_no-2));   %frame_no-1-IDR
%         adjust_curr_resi_curr_conc = 2 * statistic.Y.whole_frame.rho_curr_resi_curr_conc * (statistic.Y.whole_frame.residue_MSE*statistic.Y.whole_frame.concealment_error_MSE)^.5 * LossRateA_acc * PER_A;
        adjust_curr_conc_last_recon = 2* statistic.Y.whole_frame.rho_curr_conc_last_recon * (statistic.Y.whole_frame.concealment_error_MSE * statistic_last.Y.whole_frame.reconstructed_var)^.5 * LossRateA_acc * PER_A;


        %here is the actual adjusted value
        if mean(statistic.MV.whole_frame.length) > block_size/2
            distortion.Y.adjusted = adjust_curr_conc_last_recon;
        else
            distortion.Y.adjusted = 0;
        end
        
        distortion.Y.estimated = distortion.Y.residue + distortion.Y.concealment_error + distortion.Y.prop + distortion.Y.adjusted; 
        
    case 24
        
        distortion.Y.residue = statistic.Y.whole_frame.residue_MSE * PER_C;
        distortion.Y.concealment_error = statistic.Y.whole_frame.concealment_error_MSE * PER_A;
        
        %error_prop_factor = PER_C*statistic.Y.whole_frame.prop_clip_resi_factor + PER_A*statistic.Y.whole_frame.prop_clip_conc_factor + 1-PER_C-PER_A;
        distortion.Y.prop = PER_C*distortion_last.Y.estimated + (1-PER_C)*(distortion_last.Y.residue*statistic.Y.whole_frame.prop_clip_resi_factor + distortion_last.Y.concealment_error * statistic.Y.whole_frame.prop_clip_conc_factor + (distortion_last.Y.estimated-distortion_last.Y.residue-distortion_last.Y.concealment_error)*(statistic.Y.whole_frame.prop_clip_resi_factor)^(2/(frame_no-1)));

        LossRateA_acc = 1-(1-PER_A)^((frame_no-1)/2)+PER_C;   %frame_no-1-IDR
%         adjust_curr_resi_curr_conc = 2 * statistic.Y.whole_frame.rho_curr_resi_curr_conc * (statistic.Y.whole_frame.residue_MSE*statistic.Y.whole_frame.concealment_error_MSE)^.5 * LossRateA_acc * PER_A;
        adjust_curr_conc_last_recon = 2* statistic.Y.whole_frame.rho_curr_conc_last_recon * (statistic.Y.whole_frame.concealment_error_MSE * statistic_last.Y.whole_frame.reconstructed_var)^.5 * LossRateA_acc * PER_A;


        %here is the actual adjusted value
        if mean(statistic.MV.whole_frame.length) > block_size/2
            distortion.Y.adjusted = adjust_curr_conc_last_recon;
        else
            distortion.Y.adjusted = 0;
        end
        
        distortion.Y.estimated = distortion.Y.residue + distortion.Y.concealment_error + distortion.Y.prop + distortion.Y.adjusted; 
        
    case 25
        
        if frame_no <= 2
            prop_clip_factor_theoretical = 0;
        else
            prop_clip_factor_theoretical = clipping_factor(statistic.Y.whole_frame.reconstructed_mean, (distortion_last.Y.estimated/2)^0.5);
        end

        distortion.Y.residue = statistic.Y.whole_frame.residue_MSE * PER_C;
        distortion.Y.concealment_error = statistic.Y.whole_frame.concealment_error_MSE * PER_A;
        
        %error_prop_factor = PER_C*statistic.Y.whole_frame.prop_clip_resi_factor + PER_A*statistic.Y.whole_frame.prop_clip_conc_factor + 1-PER_C-PER_A;
        distortion.Y.prop = prop_clip_factor_theoretical*distortion_last.Y.estimated;

        LossRateA_acc = 1-(1-PER_A)^((frame_no-2));   %frame_no-1-IDR
%         adjust_curr_resi_curr_conc = 2 * statistic.Y.whole_frame.rho_curr_resi_curr_conc * (statistic.Y.whole_frame.residue_MSE*statistic.Y.whole_frame.concealment_error_MSE)^.5 * LossRateA_acc * PER_A;
        adjust_curr_conc_last_recon = 0;


        %here is the actual adjusted value
        if mean(statistic.MV.whole_frame.length) > block_size/2
            distortion.Y.adjusted = adjust_curr_conc_last_recon;
        else
            distortion.Y.adjusted = 0;
        end
        
        distortion.Y.estimated = distortion.Y.residue + distortion.Y.concealment_error + distortion.Y.prop + distortion.Y.adjusted; 
        

    case 31
        
        distortion.Y.residue = statistic.Y.whole_frame.residue_MSE * PER_C;
        distortion.Y.concealment_error = statistic.Y.whole_frame.concealment_error_MSE * PER_A;
        
        error_prop_factor = PER_C*statistic.Y.whole_frame.prop_clip_resi_factor + PER_A*statistic.Y.whole_frame.prop_clip_conc_factor + (1-PER_C-PER_A);
        distortion.Y.prop = (PER_C + (1-PER_C)*error_prop_factor)*distortion_last.Y.estimated;

        LossRateA_acc = 1;   %frame_no-1-IDR
        adjust_curr_resi_curr_conc = 2 * statistic.Y.whole_frame.rho_curr_resi_curr_conc * (statistic.Y.whole_frame.residue_MSE*statistic.Y.whole_frame.concealment_error_MSE)^.5 * LossRateA_acc * PER_A;
        adjust_curr_conc_last_resi = 2 * statistic.Y.whole_frame.rho_curr_conc_last_resi * (statistic_last.Y.whole_frame.residue_MSE*statistic.Y.whole_frame.concealment_error_MSE)^.5 * LossRateA_acc * PER_A;
        adjust_curr_conc_last_recon = 2* statistic.Y.whole_frame.rho_curr_conc_last_conc * (statistic.Y.whole_frame.concealment_error_MSE * statistic_last.Y.whole_frame.concealment_error_MSE)^.5 * LossRateA_acc * PER_A;

        %here is the actual adjusted value
        distortion.Y.adjusted = adjust_curr_conc_last_recon + adjust_curr_conc_last_resi + adjust_curr_resi_curr_conc;
        
        distortion.Y.estimated = distortion.Y.residue + distortion.Y.concealment_error + distortion.Y.prop + distortion.Y.adjusted; 

        
    case 32
        
        distortion.Y.residue = statistic.Y.whole_frame.residue_MSE * PER_C;
        distortion.Y.concealment_error = statistic.Y.whole_frame.concealment_error_MSE * PER_A;
        
        error_prop_factor = PER_C*statistic.Y.whole_frame.prop_clip_resi_factor + PER_A*statistic.Y.whole_frame.prop_clip_conc_factor + (1-PER_C-PER_A);
        distortion.Y.prop = (PER_C + (1-PER_C)*error_prop_factor)*distortion_last.Y.estimated;

        LossRateA_acc = 1;   %frame_no-1-IDR
        adjust_curr_resi_curr_conc = 2 * statistic.Y.whole_frame.rho_curr_resi_curr_conc * (statistic.Y.whole_frame.residue_MSE*statistic.Y.whole_frame.concealment_error_MSE)^.5 * LossRateA_acc * PER_A;
        adjust_curr_conc_last_resi = 2 * statistic.Y.whole_frame.rho_curr_conc_last_resi * (statistic_last.Y.whole_frame.residue_MSE*statistic.Y.whole_frame.concealment_error_MSE)^.5 * LossRateA_acc * PER_A;
        adjust_curr_conc_last_recon = 2* statistic.Y.whole_frame.rho_curr_conc_last_conc * (statistic.Y.whole_frame.concealment_error_MSE * statistic_last.Y.whole_frame.concealment_error_MSE)^.5 * LossRateA_acc * PER_A;

        %here is the actual adjusted value
        if mean(statistic.MV.whole_frame.length) > block_size/2
            distortion.Y.adjusted = adjust_curr_conc_last_recon + adjust_curr_conc_last_resi + adjust_curr_resi_curr_conc;
        else
            distortion.Y.adjusted = 0;
        end
        
        distortion.Y.estimated = distortion.Y.residue + distortion.Y.concealment_error + distortion.Y.prop + distortion.Y.adjusted; 

    case 33
        
        distortion.Y.residue = statistic.Y.whole_frame.residue_MSE * PER_C;
        distortion.Y.concealment_error = statistic.Y.whole_frame.concealment_error_MSE * PER_A;
        
        %error_prop_factor = PER_C*statistic.Y.whole_frame.prop_clip_resi_factor + PER_A*statistic.Y.whole_frame.prop_clip_conc_factor + 1-PER_C-PER_A;
        distortion.Y.prop = PER_C*distortion_last.Y.estimated + (1-PER_C)*(distortion_last.Y.residue*statistic.Y.whole_frame.prop_clip_resi_factor + distortion_last.Y.concealment_error * statistic.Y.whole_frame.prop_clip_conc_factor + (distortion_last.Y.estimated-distortion_last.Y.residue-distortion_last.Y.concealment_error));

        LossRateA_acc = 1;   %frame_no-1-IDR
        adjust_curr_resi_curr_conc = 2 * statistic.Y.whole_frame.rho_curr_resi_curr_conc * (statistic.Y.whole_frame.residue_MSE*statistic.Y.whole_frame.concealment_error_MSE)^.5 * LossRateA_acc * PER_A;
        adjust_curr_conc_last_resi = 2 * statistic.Y.whole_frame.rho_curr_conc_last_resi * (statistic_last.Y.whole_frame.residue_MSE*statistic.Y.whole_frame.concealment_error_MSE)^.5 * LossRateA_acc * PER_A;
        adjust_curr_conc_last_recon = 2* statistic.Y.whole_frame.rho_curr_conc_last_conc * (statistic.Y.whole_frame.concealment_error_MSE * statistic_last.Y.whole_frame.concealment_error_MSE)^.5 * LossRateA_acc * PER_A;


        %here is the actual adjusted value
        if mean(statistic.MV.whole_frame.length) > block_size/2
            distortion.Y.adjusted = adjust_curr_conc_last_recon + adjust_curr_conc_last_resi + adjust_curr_resi_curr_conc;
        else
            distortion.Y.adjusted = 0;
        end
        
        distortion.Y.estimated = distortion.Y.residue + distortion.Y.concealment_error + distortion.Y.prop + distortion.Y.adjusted; 

        
        
    case 34
        
        distortion.Y.residue = statistic.Y.whole_frame.residue_MSE * PER_C;
        distortion.Y.concealment_error = statistic.Y.whole_frame.concealment_error_MSE * PER_A;
        
        %error_prop_factor = PER_C*statistic.Y.whole_frame.prop_clip_resi_factor + PER_A*statistic.Y.whole_frame.prop_clip_conc_factor + 1-PER_C-PER_A;
        distortion.Y.prop = PER_C*distortion_last.Y.estimated + (1-PER_C)*(distortion_last.Y.residue*statistic.Y.whole_frame.prop_clip_resi_factor + distortion_last.Y.concealment_error * statistic.Y.whole_frame.prop_clip_conc_factor + (distortion_last.Y.estimated-distortion_last.Y.residue-distortion_last.Y.concealment_error));

        LossRateA_acc = 1;   %frame_no-1-IDR
        adjust_curr_resi_curr_conc = 2 * statistic.Y.whole_frame.rho_curr_resi_curr_conc * (statistic.Y.whole_frame.residue_MSE*statistic.Y.whole_frame.concealment_error_MSE)^.5 * LossRateA_acc * PER_A;
        adjust_curr_conc_last_resi = 2 * statistic.Y.whole_frame.rho_curr_conc_last_resi * (statistic_last.Y.whole_frame.residue_MSE*statistic.Y.whole_frame.concealment_error_MSE)^.5 * LossRateA_acc * PER_A;
        adjust_curr_conc_last_recon = 2* statistic.Y.whole_frame.rho_curr_conc_last_conc * (statistic.Y.whole_frame.concealment_error_MSE * statistic_last.Y.whole_frame.concealment_error_MSE)^.5 * LossRateA_acc * PER_A;

        %here is the actual adjusted value
        distortion.Y.adjusted = adjust_curr_conc_last_recon + adjust_curr_conc_last_resi + adjust_curr_resi_curr_conc;
        
        distortion.Y.estimated = distortion.Y.residue + distortion.Y.concealment_error + distortion.Y.prop + distortion.Y.adjusted; 
        
    case 50 %Dani's model
        block_number_row = image_width/block_size;
        block_number_col = image_height/block_size;
        MV_one_frame_x = reshape(statistic.MV.whole_frame.x, block_number_row, block_number_col);
        MV_one_frame_y = reshape(statistic.MV.whole_frame.y, block_number_row, block_number_col);
        MV_flag = zeros(image_width, image_height);
        for block_no_col = 1: block_number_col
            for block_no_row = 1: block_number_row
                MV_x = MV_one_frame_x(block_no_row, block_no_col);
                MV_y = MV_one_frame_y(block_no_row, block_no_col);
                pos_row = (block_no_row-1) * block_size + 1;
                pos_col = (block_no_col-1) * block_size + 1;
                pos_row_last = pos_row + MV_x;
                pos_col_last = pos_col + MV_y;
                if (pos_row_last<1 | pos_row_last>image_width |pos_col_last<1 | pos_col_last>image_height)
                    output_message(sprintf('Warning: out of bound in Dani model: block at x=%dth, y=%dth; MV is x=%d, y=%d',pos_row, pos_col, MV_x, MV_y));
                else
                    MV_flag(pos_row_last:pos_row_last+block_size-1, pos_col_last:pos_col_last+block_size-1) = 1;
                end
            end
        end
        MRR = sum(sum(MV_flag))/(image_width * image_height)
        k0 = 0.91;
        k1 = -0.86;
        error_prop_factor = k0/MRR + k1
 
        distortion.Y.residue = statistic.Y.whole_frame.residue_MSE * PER_C;
        distortion.Y.concealment_error = statistic.Y.whole_frame.concealment_error_MSE * PER_A;
        
        distortion.Y.prop = exp(-error_prop_factor) * distortion_last.Y.estimated;
        distortion.Y.adjusted = 0;

        distortion.Y.estimated = distortion.Y.residue + distortion.Y.concealment_error + distortion.Y.prop + distortion.Y.adjusted; 

    case 51 %Stuhlmuller's model
        distortion.Y.residue = statistic.Y.whole_frame.residue_MSE * PER_C;
        distortion.Y.concealment_error = statistic.Y.whole_frame.concealment_error_MSE * PER_A;
        
        error_prop_factor = 1;
        distortion.Y.prop = error_prop_factor * distortion_last.Y.estimated;
        distortion.Y.adjusted = 0;

        distortion.Y.estimated = distortion.Y.residue + distortion.Y.concealment_error + distortion.Y.prop + distortion.Y.adjusted; 

        
    otherwise   %for test
        output_message('Error: algorithm is not set properly');
end

