%--------------------------------------------------------------------------
%this function is to produce the Video Distortion Analysis Tool (VDAT) GUI.
%
%Chen Zhifeng
%UFID 12181197
%2008-07-17
%zhifeng@ecel.ufl.edu
%--------------------------------------------------------------------------

function varargout = VDAT(varargin)
% VDAT M-file for VDAT.fig
%      VDAT, by itself, creates a new VDAT or raises the existing
%      singleton*.
%
%      H = VDAT returns the handle to a new VDAT or the handle to
%      the existing singleton*.
%
%      VDAT('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in VDAT.M with the given input arguments.
%
%      VDAT('Property','Value',...) creates a new VDAT or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before VDAT_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to VDAT_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Copyright 2002-2003 The MathWorks, Inc.

% Edit the above text to modify the response to help VDAT

% Last Modified by GUIDE v2.5 22-Oct-2008 15:56:40

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @VDAT_OpeningFcn, ...
                   'gui_OutputFcn',  @VDAT_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before VDAT is made visible.
function VDAT_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to VDAT (see VARARGIN)

global display_message  %just for the output_message function
display_message = handles.listbox_display;

%change the icon
javaFrame = get(gcf,'JavaFrame');
javaFrame.setFigureIcon(javax.swing.ImageIcon('icon.gif'));


% Choose default command line output for VDAT
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes VDAT wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = VDAT_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



% --- Executes on button press in checkbox_DC_DPA.
function checkbox_DC_DPA_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_DC_DPA (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_DC_DPA
if (get(handles.checkbox_DC_DPA,'Value') == get(handles.checkbox_DC_DPA,'Max'))
    set(handles.edit_DC_DPA, 'Enable', 'on'); % then checkbox is checked-take approriate action
else
    set(handles.edit_DC_DPA, 'Enable', 'off'); % then checkbox is checked-take approriate action
    set(handles.edit_DC_DPA, 'string', '0'); % then checkbox is checked-take approriate action
end


% --- Executes on button press in checkbox_DC_DPB.
function checkbox_DC_DPB_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_DC_DPB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_DC_DPB
if (get(handles.checkbox_DC_DPB,'Value') == get(handles.checkbox_DC_DPB,'Max'))
    set(handles.edit_DC_DPB, 'Enable', 'on'); % then checkbox is checked-take approriate action
else
    set(handles.edit_DC_DPB, 'Enable', 'off'); % then checkbox is checked-take approriate action
    set(handles.edit_DC_DPB, 'string', '0'); % then checkbox is checked-take approriate action
end


% --- Executes on button press in checkbox_DC_DPC.
function checkbox_DC_DPC_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_DC_DPC (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_DC_DPC
if (get(handles.checkbox_DC_DPC,'Value') == get(handles.checkbox_DC_DPC,'Max'))
    set(handles.edit_DC_DPC, 'Enable', 'on'); % then checkbox is checked-take approriate action
else
    set(handles.edit_DC_DPC, 'Enable', 'off'); % then checkbox is checked-take approriate action
    set(handles.edit_DC_DPC, 'string', '0'); % then checkbox is checked-take approriate action
end



function edit_DC_DPA_Callback(hObject, eventdata, handles)
% hObject    handle to edit_DC_DPA (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_DC_DPA as text
%        str2double(get(hObject,'String')) returns contents of edit_DC_DPA as a double
DPA_slice = str2num(get(hObject,'String'));
 
%checks to see if input is empty. if so, default input1_editText to zero
if (isempty(DPA_slice) | ~isreal(DPA_slice))
     set(hObject,'String','0')
     output_message('Input should be a sequence of real number');
end
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function edit_DC_DPA_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_DC_DPA (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end





function edit_DC_DPC_Callback(hObject, eventdata, handles)
% hObject    handle to edit_DC_DPC (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_DC_DPC as text
%        str2double(get(hObject,'String')) returns contents of edit_DC_DPC as a double
DPC_slice = str2num(get(hObject,'String'));
 
%checks to see if input is empty. if so, default input1_editText to zero
if (isempty(DPC_slice) | ~isreal(DPC_slice))
     set(hObject,'String','0')
     output_message('Input should be a sequence of real number');
end
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function edit_DC_DPC_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_DC_DPC (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end




function edit_DC_DPB_Callback(hObject, eventdata, handles)
% hObject    handle to edit_DC_DPB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_DC_DPB as text
%        str2double(get(hObject,'String')) returns contents of edit_DC_DPB as a double
DPB_slice = str2num(get(hObject,'String'));
 
%checks to see if input is empty. if so, default input1_editText to zero
if (isempty(DPB_slice) | ~isreal(DPB_slice))
     set(hObject,'String','0')
     output_message('Input should be a sequence of real number');
end
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function edit_DC_DPB_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_DC_DPB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on button press in radiobutton_deterministic.
function radiobutton_deterministic_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton_deterministic (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobutton_deterministic






% --- Executes on button press in checkbox_RC_DPA.
function checkbox_RC_DPA_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_RC_DPA (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_RC_DPA
if (get(handles.checkbox_RC_DPA,'Value') == get(handles.checkbox_RC_DPA,'Max'))
    set(handles.edit_RC_DPA, 'Enable', 'on'); % then checkbox is checked-take approriate action
else
    set(handles.edit_RC_DPA, 'Enable', 'off'); % then checkbox is checked-take approriate action
    set(handles.edit_RC_DPA, 'string', '0'); % then checkbox is checked-take approriate action
end


% --- Executes on button press in checkbox_RC_DPB.
function checkbox_RC_DPB_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_RC_DPB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_RC_DPB
if (get(handles.checkbox_RC_DPB,'Value') == get(handles.checkbox_RC_DPB,'Max'))
    set(handles.edit_RC_DPB, 'Enable', 'on'); % then checkbox is checked-take approriate action
else
    set(handles.edit_RC_DPB, 'Enable', 'off'); % then checkbox is checked-take approriate action
    set(handles.edit_RC_DPB, 'string', '0'); % then checkbox is checked-take approriate action
end


% --- Executes on button press in checkbox_RC_DPC.
function checkbox_RC_DPC_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_RC_DPC (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_RC_DPC
if (get(handles.checkbox_RC_DPC,'Value') == get(handles.checkbox_RC_DPC,'Max'))
    set(handles.edit_RC_DPC, 'Enable', 'on'); % then checkbox is checked-take approriate action
else
    set(handles.edit_RC_DPC, 'Enable', 'off'); % then checkbox is checked-take approriate action
    set(handles.edit_RC_DPC, 'string', '0'); % then checkbox is checked-take approriate action
end



function edit_RC_DPA_Callback(hObject, eventdata, handles)
% hObject    handle to edit_RC_DPA (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_RC_DPA as text
%        str2double(get(hObject,'String')) returns contents of edit_RC_DPA as a double
DPA_PER = str2num(get(hObject,'String'));
 
%checks to see if input is empty. if so, default input1_editText to zero
if (isempty(DPA_PER) | ~isreal(DPA_PER))
     set(hObject,'String','0')
     output_message('Input should be a real number');
end
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function edit_RC_DPA_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_RC_DPA (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


function edit_RC_DPB_Callback(hObject, eventdata, handles)
% hObject    handle to edit_RC_DPB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_RC_DPB as text
%        str2double(get(hObject,'String')) returns contents of edit_RC_DPB as a double
DPB_PER = str2num(get(hObject,'String'));
 
%checks to see if input is empty. if so, default input1_editText to zero
if (isempty(DPB_PER) | ~isreal(DPB_PER))
     set(hObject,'String','0')
     output_message('Input should be a real number');
end
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function edit_RC_DPB_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_RC_DPB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end




function edit_RC_DPC_Callback(hObject, eventdata, handles)
% hObject    handle to edit_RC_DPC (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_RC_DPC as text
%        str2double(get(hObject,'String')) returns contents of edit_RC_DPC as a double
DPC_PER = str2num(get(hObject,'String'));
 
%checks to see if input is empty. if so, default input1_editText to zero
if (isempty(DPC_PER) | ~isreal(DPC_PER))
     set(hObject,'String','0')
     output_message('Input should be a real number');
end
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function edit_RC_DPC_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_RC_DPC (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



% --- Executes on button press in pushbutton_add.
function pushbutton_add_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_add (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
contents = get(handles.listbox_video,'String');
if(length(contents))
    last_open_file = contents{end};
    pos_backslash = findstr(last_open_file, '\');
    directory_name = last_open_file(1 : pos_backslash(end) - 1);
else
    directory_name = '..\bin';

end
current_directory = cd;
cd(directory_name);
[filename, pathname] = uigetfile( ...
    {'*.*'}, ...  %'*.yuv','YUV video (*.yuv)'
    'Select the YUV file');
cd (current_directory)


% If "Cancel" is selected then return
if isequal([filename,pathname],[0,0])
    return
% Otherwise construct the fullfilename and Check and load the file
else
    file_with_path = fullfile(pathname,filename);
    contents = get(handles.listbox_video,'String');
    set(handles.listbox_video,'String', [contents; {file_with_path}] );
    set(handles.listbox_video, 'Value', length(contents)+1);
end
guidata(hObject,handles);

[image_width, image_height, resolution, format_error] = get_resolution(filename);
image_width_set = str2num(get(handles.edit_image_width,'String'));
image_height_set = str2num(get(handles.edit_image_height,'String'));

if (format_error)
    output_message('Warning: video format can not be recognized! It is better to name the video with the resolution, for example, foreman_cif.yuv');
elseif (image_width_set ~= image_width | image_height_set ~= image_height)
    output_message(sprintf('Warning: selected format is %s, parameters setting are: image_width = %d, image_height = %d', resolution, image_width_set, image_height_set ));
end


% --- Executes on selection change in listbox_video.
function listbox_video_Callback(hObject, eventdata, handles)
% hObject    handle to listbox_video (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns listbox_video contents as cell array
%        contents{get(hObject,'Value')} returns selected item from listbox_video

% --- Executes during object creation, after setting all properties.
function listbox_video_CreateFcn(hObject, eventdata, handles)
% hObject    handle to listbox_video (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on button press in pushbutton_remove.
function pushbutton_remove_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_remove (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

index_curr = get(handles.listbox_video, 'Value');
contents = get(handles.listbox_video,'String');
if index_curr == length(contents)
    set(handles.listbox_video, 'Value', index_curr - 1);
    set(handles.listbox_video, 'String', contents(1 : index_curr - 1));
else
    %set(handles.listbox_video, 'Value', index_curr + 1);
    set(handles.listbox_video, 'String', [contents(1 : index_curr - 1); contents(index_curr + 1 : end)]);
end
guidata(hObject,handles);




% --- Executes on button press in pushbutton_store.
function pushbutton_store_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_store (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

current_directory = cd;
pos_backslash = findstr(current_directory,'\');
directory_name = uigetdir(current_directory(1 : pos_backslash(end) - 1));
% If "Cancel" is selected then return
if isequal(directory_name,0)
    return
% Otherwise construct the fullfilename and Check and load the file
else
    contents = get(handles.popupmenu_store,'String');
    set(handles.popupmenu_store,'String', [contents; {directory_name}] );
    set(handles.popupmenu_store, 'Value', length(contents)+1);
end
guidata(hObject,handles);

% --- Executes on selection change in listbox_store.
function listbox_store_Callback(hObject, eventdata, handles)
% hObject    handle to listbox_store (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns listbox_store contents as cell array
%        contents{get(hObject,'Value')} returns selected item from listbox_store


% --- Executes during object creation, after setting all properties.
function listbox_store_CreateFcn(hObject, eventdata, handles)
% hObject    handle to listbox_store (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


function edit_image_width_Callback(hObject, eventdata, handles)
% hObject    handle to edit_image_width (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_image_width as text
%        str2double(get(hObject,'String')) returns contents of edit_image_width as a double
image_width = str2num(get(hObject,'String'));
 
%checks to see if input is empty. if so, default input1_editText to zero
if (isempty(image_width) | ~isreal(image_width))
     set(hObject,'String','0')
     output_message('Input should be a real number');
end
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function edit_image_width_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_image_width (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit_image_height_Callback(hObject, eventdata, handles)
% hObject    handle to edit_image_height (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_image_height as text
%        str2double(get(hObject,'String')) returns contents of edit_image_height as a double
image_height = str2num(get(hObject,'String'));
 
%checks to see if input is empty. if so, default input1_editText to zero
if (isempty(image_height) | ~isreal(image_height))
     set(hObject,'String','0')
     output_message('Input should be a real number');
end
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function edit_image_height_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_image_height (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit_MB_per_slice_Callback(hObject, eventdata, handles)
% hObject    handle to edit_MB_per_slice (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_MB_per_slice as text
%        str2double(get(hObject,'String')) returns contents of edit_MB_per_slice as a double
MB_per_slice = str2num(get(hObject,'String'));
 
%checks to see if input is empty. if so, default input1_editText to zero
if (isempty(MB_per_slice) | ~isreal(MB_per_slice))
     set(hObject,'String','0')
     output_message('Input should be a real number');
end
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function edit_MB_per_slice_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_MB_per_slice (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end





function edit_frame_number_Callback(hObject, eventdata, handles)
% hObject    handle to edit_frame_number (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_frame_number as text
%        str2double(get(hObject,'String')) returns contents of edit_frame_number as a double
frame_number = str2num(get(hObject,'String'));
 
%checks to see if input is empty. if so, default input1_editText to zero
if (isempty(frame_number) | ~isreal(frame_number))
     set(hObject,'String','0')
     output_message('Input should be a real number');
end
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function edit_frame_number_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_frame_number (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit_frame_offset_Callback(hObject, eventdata, handles)
% hObject    handle to edit_frame_offset (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_frame_offset as text
%        str2double(get(hObject,'String')) returns contents of edit_frame_offset as a double
frame_offset = str2num(get(hObject,'String'));
 
%checks to see if input is empty. if so, default input1_editText to zero
if (isempty(frame_offset) | ~isreal(frame_offset))
     set(hObject,'String','0')
     output_message('Input should be a real number');
end
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function edit_frame_offset_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_frame_offset (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end





function edit_subsampling_Callback(hObject, eventdata, handles)
% hObject    handle to edit_subsampling (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_subsampling as text
%        str2double(get(hObject,'String')) returns contents of edit_subsampling as a double
subsampling = get(hObject,'String');
switch subsampling
    case '4:2:0'
    otherwise
        set(hObject,'String','4:2:0')
        output_message('Unknown subsampling format! Currently support 4:2:0');
end

guidata(hObject, handles);



% --- Executes during object creation, after setting all properties.
function edit_subsampling_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_subsampling (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end




function edit_subpel_ME_Callback(hObject, eventdata, handles)
% hObject    handle to edit_subpel_ME (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_subpel_ME as text
%        str2double(get(hObject,'String')) returns contents of edit_subpel_ME as a double
subpel_ME = str2num(get(hObject,'String'));
switch subpel_ME
    case 1
    otherwise
        set(hObject,'String','1')
        output_message('Unknown subpel motion estimation format! Currently support integer ME');
end
 
guidata(hObject, handles);



% --- Executes during object creation, after setting all properties.
function edit_subpel_ME_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_subpel_ME (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit_FMO_type_Callback(hObject, eventdata, handles)
% hObject    handle to edit_FMO_type (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_FMO_type as text
%        str2double(get(hObject,'String')) returns contents of edit_FMO_type as a double
FMO_type = str2num(get(hObject,'String'));
switch FMO_type
    case 0
    otherwise
        set(hObject,'String','0')
        output_message('Unknown FMO type! Currently support FMO type 0');
end
 
guidata(hObject, handles);



% --- Executes during object creation, after setting all properties.
function edit_FMO_type_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_FMO_type (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



% --- Executes on button press in checkbox_alg1.
function checkbox_alg1_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_alg1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_alg1
if (get(handles.checkbox_alg1,'Value') == get(handles.checkbox_alg1,'Max'))
    set(handles.edit_alg1, 'Enable', 'on'); % then checkbox is checked-take approriate action
else
    set(handles.edit_alg1, 'Enable', 'off'); % then checkbox is checked-take approriate action
    set(handles.edit_alg1, 'string', '0'); % then checkbox is checked-take approriate action
end



% --- Executes on button press in checkbox_alg2.
function checkbox_alg2_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_alg2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_alg2
if (get(handles.checkbox_alg2,'Value') == get(handles.checkbox_alg2,'Max'))
    set(handles.edit_alg2, 'Enable', 'on'); % then checkbox is checked-take approriate action
else
    set(handles.edit_alg2, 'Enable', 'off'); % then checkbox is checked-take approriate action
    set(handles.edit_alg2, 'string', '0'); % then checkbox is checked-take approriate action
end



% --- Executes on button press in checkbox_alg3.
function checkbox_alg3_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_alg3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_alg3
if (get(handles.checkbox_alg3,'Value') == get(handles.checkbox_alg3,'Max'))
    set(handles.edit_alg3, 'Enable', 'on'); % then checkbox is checked-take approriate action
else
    set(handles.edit_alg3, 'Enable', 'off'); % then checkbox is checked-take approriate action
    set(handles.edit_alg3, 'string', '0'); % then checkbox is checked-take approriate action
end



% --- Executes on button press in checkbox_alg4.
function checkbox_alg4_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_alg4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_alg4
if (get(handles.checkbox_alg4,'Value') == get(handles.checkbox_alg4,'Max'))
    set(handles.edit_alg4, 'Enable', 'on'); % then checkbox is checked-take approriate action
else
    set(handles.edit_alg4, 'Enable', 'off'); % then checkbox is checked-take approriate action
    set(handles.edit_alg4, 'string', '0'); % then checkbox is checked-take approriate action
end



% --- Executes on button press in checkbox_alg5.
function checkbox_alg5_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_alg5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_alg5
if (get(handles.checkbox_alg5,'Value') == get(handles.checkbox_alg5,'Max'))
    set(handles.edit_alg5, 'Enable', 'on'); % then checkbox is checked-take approriate action
else
    set(handles.edit_alg5, 'Enable', 'off'); % then checkbox is checked-take approriate action
    set(handles.edit_alg5, 'string', '0'); % then checkbox is checked-take approriate action
end



% --- Executes on button press in checkbox_alg6.
function checkbox_alg6_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_alg6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_alg6
if (get(handles.checkbox_alg6,'Value') == get(handles.checkbox_alg6,'Max'))
    set(handles.edit_alg6, 'Enable', 'on'); % then checkbox is checked-take approriate action
else
    set(handles.edit_alg6, 'Enable', 'off'); % then checkbox is checked-take approriate action
    set(handles.edit_alg6, 'string', '0'); % then checkbox is checked-take approriate action
end




function edit_alg1_Callback(hObject, eventdata, handles)
% hObject    handle to edit_alg1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_alg1 as text
%        str2double(get(hObject,'String')) returns contents of edit_alg1 as a double
para_alg1 = str2num(get(hObject,'String'));
 
%checks to see if input is empty. if so, default input1_editText to zero
if (isempty(para_alg1) | ~isreal(para_alg1))
     set(hObject,'String','0')
     output_message('Input should be a sequence of real number');
end
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function edit_alg1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_alg1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit_alg2_Callback(hObject, eventdata, handles)
% hObject    handle to edit_alg2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_alg2 as text
%        str2double(get(hObject,'String')) returns contents of edit_alg2 as a double
para_alg2 = str2num(get(hObject,'String'));
 
%checks to see if input is empty. if so, default input1_editText to zero
if (isempty(para_alg2) | ~isreal(para_alg2))
     set(hObject,'String','0')
     output_message('Input should be a sequence of real number');
end
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function edit_alg2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_alg2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit_alg3_Callback(hObject, eventdata, handles)
% hObject    handle to edit_alg3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_alg3 as text
%        str2double(get(hObject,'String')) returns contents of edit_alg3 as a double
para_alg3 = str2num(get(hObject,'String'));
 
%checks to see if input is empty. if so, default input1_editText to zero
if (isempty(para_alg3) | ~isreal(para_alg3))
     set(hObject,'String','0')
     output_message('Input should be a sequence of real number');
end
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function edit_alg3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_alg3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit_alg4_Callback(hObject, eventdata, handles)
% hObject    handle to edit_alg4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_alg4 as text
%        str2double(get(hObject,'String')) returns contents of edit_alg4 as a double
para_alg4 = str2num(get(hObject,'String'));
 
%checks to see if input is empty. if so, default input1_editText to zero
if (isempty(para_alg4) | ~isreal(para_alg4))
     set(hObject,'String','0')
     output_message('Input should be a sequence of real number');
end
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function edit_alg4_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_alg4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit_alg5_Callback(hObject, eventdata, handles)
% hObject    handle to edit_alg5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_alg5 as text
%        str2double(get(hObject,'String')) returns contents of edit_alg5 as a double
para_alg5 = str2num(get(hObject,'String'));
 
%checks to see if input is empty. if so, default input1_editText to zero
if (isempty(para_alg5) | ~isreal(para_alg5))
     set(hObject,'String','0')
     output_message('Input should be a sequence of real number');
end
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function edit_alg5_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_alg5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit_alg6_Callback(hObject, eventdata, handles)
% hObject    handle to edit_alg6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_alg6 as text
%        str2double(get(hObject,'String')) returns contents of edit_alg6 as a double
para_alg6 = str2num(get(hObject,'String'));
 
%checks to see if input is empty. if so, default input1_editText to zero
if (isempty(para_alg6) | ~isreal(para_alg6))
     set(hObject,'String','0')
     output_message('Input should be a sequence of real number');
end
guidata(hObject, handles);



% --- Executes during object creation, after setting all properties.
function edit_alg6_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_alg6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end




% --- Executes on button press in checkbox_BS.
function checkbox_BS_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_BS (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_BS
if (get(handles.checkbox_BS,'Value') == get(handles.checkbox_BS,'Max'))
    set(handles.checkbox_BS_per_frame, 'Enable', 'on'); % then checkbox is checked-take approriate action
else
    set(handles.checkbox_BS_per_frame, 'Enable', 'off'); % checkbox is not checked-take approriate action
end
guidata(hObject, handles);

% --- Executes on button press in checkbox_BS_per_frame.
function checkbox_BS_per_frame_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_BS_per_frame (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_BS_per_frame



% --- Executes on button press in checkbox_CC.
function checkbox_CC_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_CC (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_CC
if (get(handles.checkbox_CC,'Value') == get(handles.checkbox_CC,'Max'))
    set(handles.checkbox_CC_per_frame, 'Enable', 'on'); % then checkbox is checked-take approriate action
else
    set(handles.checkbox_CC_per_frame, 'Enable', 'off'); % checkbox is not checked-take approriate action
end
guidata(hObject, handles);


% --- Executes on button press in checkbox_CC_per_frame.
function checkbox_CC_per_frame_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_CC_per_frame (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_CC_per_frame


% --- Executes on button press in checkbox_JP.
function checkbox_JP_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_JP (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_JP
if (get(handles.checkbox_JP,'Value') == get(handles.checkbox_JP,'Max'))
    set(handles.checkbox_JP_per_frame, 'Enable', 'on'); % then checkbox is checked-take approriate action
else
    set(handles.checkbox_JP_per_frame, 'Enable', 'off'); % checkbox is not checked-take approriate action
end
guidata(hObject, handles);


% --- Executes on button press in checkbox_JP_per_frame.
function checkbox_JP_per_frame_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_JP_per_frame (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_JP_per_frame


% --- Executes on button press in checkbox_CP.
function checkbox_CP_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_CP (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_CP
if (get(handles.checkbox_CP,'Value') == get(handles.checkbox_CP,'Max'))
    set(handles.checkbox_CP_per_frame, 'Enable', 'on'); % then checkbox is checked-take approriate action
else
    set(handles.checkbox_CP_per_frame, 'Enable', 'off'); % checkbox is not checked-take approriate action
end
guidata(hObject, handles);


% --- Executes on button press in checkbox_CP_per_frame.
function checkbox_CP_per_frame_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_CP_per_frame (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_CP_per_frame




function edit_loop_number_Callback(hObject, eventdata, handles)
% hObject    handle to edit_loop_number (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_loop_number as text
%        str2double(get(hObject,'String')) returns contents of edit_loop_number as a double
loop_number = str2num(get(hObject,'String'));
 
%checks to see if input is empty. if so, default input1_editText to zero
if (isempty(loop_number) | ~isreal(loop_number))
     set(hObject,'String','0')
     output_message('Input should be a real number');
end
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function edit_loop_number_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_loop_number (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



% --- Executes on button press in checkbox_temp.
function checkbox_temp_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_temp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_temp


% --- Executes on selection change in popupmenu_store.
function popupmenu_store_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu_store (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenu_store contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu_store


% --- Executes during object creation, after setting all properties.
function popupmenu_store_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu_store (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



% --- Executes on selection change in listbox_display.
function listbox_display_Callback(hObject, eventdata, handles)
% hObject    handle to listbox_display (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns listbox_display contents as cell array
%        contents{get(hObject,'Value')} returns selected item from listbox_display


% --- Executes during object creation, after setting all properties.
function listbox_display_CreateFcn(hObject, eventdata, handles)
% hObject    handle to listbox_display (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end




% --- Executes on button press in pushbutton_run.
function pushbutton_run_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_run (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%Check the input video is selected
contents = get(handles.listbox_video,'String');
if(length(contents) == 0)
    output_message('Please select the video!');
    return 
end

%Check the output folder is selected
contents = get(handles.popupmenu_store,'String');
if(length(contents) == 0)
    output_message('Please specify the folder to store!');
    return 
end

%Check the channels are produced
contents = get(handles.popupmenu_channel,'String');
if(length(contents) == 0)
    output_message('Please produce at least one channel by setting channel parameters and press New button!');
    return 
end

set(hObject,'UserData',0);
para_setting = get_para(handles);
main(para_setting, hObject);

clear para_setting


% --- Executes on button press in pushbutton_stop.
function pushbutton_stop_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_stop (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%toggle the flag variable so that the other process will stop
if(get(handles.pushbutton_run,'UserData'))
    set(handles.pushbutton_run,'UserData',0);
    set(hObject, 'String', 'stop');
    guidata(hObject, handles);
    drawnow
else
    set(handles.pushbutton_run,'UserData',1);
    set(hObject, 'String', 'resume');
    guidata(hObject, handles);
    drawnow
end


% --------------------------------------------------------------------
function uipanel_channel_para_SelectionChangeFcn(hObject, eventdata, handles)
% hObject    handle to uipanel_channel_para (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

selection = get(handles.uipanel_channel_para,'SelectedObject');
switch get(selection,'Tag')
    case 'radiobutton_deterministic'
        % code piece when radiobutton_deterministic is selected goes here
        set(handles.checkbox_DC_DPA, 'Enable', 'on'); % then checkbox is checked-take approriate action
        if (get(handles.checkbox_DC_DPA,'Value') == get(handles.checkbox_DC_DPA,'Max'))
            set(handles.edit_DC_DPA, 'Enable', 'on'); % then checkbox is checked-take approriate action
        else
            set(handles.edit_DC_DPA, 'Enable', 'off'); % then checkbox is checked-take approriate action
        end
        set(handles.checkbox_DC_DPB, 'Enable', 'on'); % then checkbox is checked-take approriate action
        if (get(handles.checkbox_DC_DPB,'Value') == get(handles.checkbox_DC_DPB,'Max'))
            set(handles.edit_DC_DPB, 'Enable', 'on'); % then checkbox is checked-take approriate action
        else
            set(handles.edit_DC_DPB, 'Enable', 'off'); % then checkbox is checked-take approriate action
        end
        set(handles.checkbox_DC_DPC, 'Enable', 'on'); % then checkbox is checked-take approriate action
        if (get(handles.checkbox_DC_DPC,'Value') == get(handles.checkbox_DC_DPC,'Max'))
            set(handles.edit_DC_DPC, 'Enable', 'on'); % then checkbox is checked-take approriate action
        else
            set(handles.edit_DC_DPC, 'Enable', 'off'); % then checkbox is checked-take approriate action
        end
        set(handles.checkbox_RC_DPA, 'Enable', 'off'); % then checkbox is checked-take approriate action
        set(handles.edit_RC_DPA, 'Enable', 'off'); % then checkbox is checked-take approriate action
        set(handles.checkbox_RC_DPB, 'Enable', 'off'); % then checkbox is checked-take approriate action
        set(handles.edit_RC_DPB, 'Enable', 'off'); % then checkbox is checked-take approriate action
        set(handles.checkbox_RC_DPC, 'Enable', 'off'); % then checkbox is checked-take approriate action
        set(handles.edit_RC_DPC, 'Enable', 'off'); % then checkbox is checked-take approriate action
    case 'radiobutton_random'
        % code piece when radiobutton_random is selected goes here
        set(handles.checkbox_RC_DPA, 'Enable', 'on'); % then checkbox is checked-take approriate action
        if (get(handles.checkbox_RC_DPA,'Value') == get(handles.checkbox_RC_DPA,'Max'))
            set(handles.edit_RC_DPA, 'Enable', 'on'); % then checkbox is checked-take approriate action
        else
            set(handles.edit_RC_DPA, 'Enable', 'off'); % then checkbox is checked-take approriate action
        end
        set(handles.checkbox_RC_DPB, 'Enable', 'on'); % then checkbox is checked-take approriate action
        if (get(handles.checkbox_RC_DPB,'Value') == get(handles.checkbox_RC_DPB,'Max'))
            set(handles.edit_RC_DPB, 'Enable', 'on'); % then checkbox is checked-take approriate action
        else
            set(handles.edit_RC_DPB, 'Enable', 'off'); % then checkbox is checked-take approriate action
        end
        set(handles.checkbox_RC_DPC, 'Enable', 'on'); % then checkbox is checked-take approriate action
        if (get(handles.checkbox_RC_DPC,'Value') == get(handles.checkbox_RC_DPC,'Max'))
            set(handles.edit_RC_DPC, 'Enable', 'on'); % then checkbox is checked-take approriate action
        else
            set(handles.edit_RC_DPC, 'Enable', 'off'); % then checkbox is checked-take approriate action
        end
        set(handles.checkbox_DC_DPA, 'Enable', 'off'); % then checkbox is checked-take approriate action
        set(handles.edit_DC_DPA, 'Enable', 'off'); % then checkbox is checked-take approriate action
        set(handles.checkbox_DC_DPB, 'Enable', 'off'); % then checkbox is checked-take approriate action
        set(handles.edit_DC_DPB, 'Enable', 'off'); % then checkbox is checked-take approriate action
        set(handles.checkbox_DC_DPC, 'Enable', 'off'); % then checkbox is checked-take approriate action
        set(handles.edit_DC_DPC, 'Enable', 'off'); % then checkbox is checked-take approriate action
end

guidata(hObject,handles);

% --- Executes during object creation, after setting all properties.
function uipanel_channel_para_CreateFcn(hObject, eventdata, handles)
% hObject    handle to uipanel_channel_para (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called





% --- Executes on button press in pushbutton_new.
function pushbutton_new_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_new (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
contents = get(handles.popupmenu_channel,'String');
set(handles.popupmenu_channel, 'Value', length(contents)+1);

selection = get(handles.uipanel_channel_para,'SelectedObject');
switch get(selection,'Tag')
    case 'radiobutton_deterministic'
        % code piece when radiobutton_deterministic is selected goes here
        current_channel = ['D; ', get(handles.edit_DC_DPA, 'String'), '; ',...
            get(handles.edit_DC_DPB, 'String'), '; ', get(handles.edit_DC_DPC, 'String')];
    case 'radiobutton_random'
        % code piece when radiobutton_random is selected goes here
        current_channel = ['R; ', get(handles.edit_RC_DPA, 'String'), '; ',...
            get(handles.edit_RC_DPB, 'String'), '; ', get(handles.edit_RC_DPC, 'String')];
end
set(handles.popupmenu_channel,'String', [contents; {current_channel}] );
guidata(hObject,handles);


% --- Executes on selection change in popupmenu_channel.
function popupmenu_channel_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu_channel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenu_channel contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu_channel


% --- Executes during object creation, after setting all properties.
function popupmenu_channel_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu_channel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end






