/*BEGIN_LEGAL 
Intel Open Source License 

Copyright (c) 2002-2011 Intel Corporation. All rights reserved.
 
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.  Redistributions
in binary form must reproduce the above copyright notice, this list of
conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.  Neither the name of
the Intel Corporation nor the names of its contributors may be used to
endorse or promote products derived from this software without
specific prior written permission.
 
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE INTEL OR
ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
END_LEGAL */
#include <stdlib.h>
#include <stdio.h>
#include <windows.h>

void Load(char * name, int expect)
{
    int val;
    
    HMODULE handle;
    int (*sym)();
    
    handle = LoadLibrary(name);
    if (handle == 0)
    {
        fprintf(stderr,"Load of %s failed\n",name);
        fflush(stderr);
        exit(1);
    }
    
    sym = (int(*)())GetProcAddress(handle, "one");
    fprintf(stderr, "Address of sym is %p\n",sym);
    fflush(stderr);
    
    if (sym == 0)
    {
        fprintf(stderr,"GetProcAddress() of %s failed\n",name);
        fflush(stderr);
        exit(1);
    }
    
    val = sym();
    if (val != expect)
    {
        fprintf(stderr, "Error: Bad value returned.\n");
        fflush(stderr);
        exit(1);
    } 
}

int main()
{
    
    Load("one.dll", 1);
    Load("two.dll", 2);

    Load("one.dll", 1);
    Load("two.dll", 2);

        
    return 0;
}

