function hd = compute_distance(c1, c2, I)
% Directing User Attention via Visual Flow on Web Designs
% Xufang Pang*, Ying Cao*, Rynson W.H. Lau and Antoni B. Chan (*Joint first authors)
% ACM Trans. on Graphics (Proc. ACM SIGGRAPH Asia 2016), Dec. 2016

P1.x = c1.polygon.x; P1.y =  c1.polygon.y;
P2.x = c2.polygon.x; P2.y =  c2.polygon.y;
hd = min_dist_between_two_polygons(P1,P2)/norm([size(I, 1) size(I, 2)], 2);
end