% Demo for paper "Visual Tracking via Locality Sensitive Histograms" 
% by Shengfeng He, Qingxiong Yang, Rynson W.H. Lau, Jiang Wang, and Ming-Hsuan Yang
% To appear in Proceedings of IEEE Conference on Computer Vision and Pattern Recognition (CVPR 2013), Portland, June, 2013.
% This MATLAB code is an unoptimized re-implementation of the proposed locality sensitive histograms and illumination invariant features.
clear all;
clc;

nbin = 32;            %number of bins
alpha = 0.15;         %parameter of LSH, [0.0,1.0]
k = 0.1;              %parameter of illumination invariant features
img1 = rgb2gray(imread('lena1_.png'));
img2 = rgb2gray(imread('lena2_.png'));
%compute LSH
hist_mtx1 = LSH(img1, alpha, nbin);
hist_mtx2 = LSH(img2, alpha, nbin);
%compute illumination invariant features
iif_img1 = IIF(img1, hist_mtx1, k, nbin);
iif_img2 = IIF(img2, hist_mtx2, k, nbin);

%
figure;
h = subplot(2, 2, 1); subimage(img1);
set(h, 'XTick', [], 'YTick', []);
h = subplot(2, 2, 2); subimage(img2);
set(h, 'XTick', [], 'YTick', []);
h = subplot(2, 2, 3); subimage(iif_img1);
set(h, 'XTick', [], 'YTick', []);
h = subplot(2, 2, 4); subimage(iif_img2);
set(h, 'XTick', [], 'YTick', []);

imwrite(iif_img1, '1.png');
imwrite(iif_img2, '2.png');