% Demo for paper "Visual Tracking via Locality Sensitive Histograms" 
% by Shengfeng He, Qingxiong Yang, Rynson W.H. Lau, Jiang Wang, and Ming-Hsuan Yang
% To appear in Proceedings of IEEE Conference on Computer Vision and Pattern Recognition (CVPR 2013), Portland, June, 2013.
% hist_mtx output a (x,y,b) matrix
function hist_mtx = LSH(img, sigma, nbin)

    color_max = 255;
    color_range = 0:color_max/nbin:color_max;
    
    alpha_x = exp(-sqrt(2)/(sigma*size(img, 1)));
    alpha_y = exp(-sqrt(2)/(sigma*size(img, 2)));

    % compute Q
    q_mtx = zeros(size(img, 1), size(img, 2), nbin);
    for i=1:nbin
        tmp_img = img;

        mask_l = find(tmp_img >= color_range(i));
        mask_u = find(tmp_img < color_range(i+1));
        mask = intersect(mask_l, mask_u);

        tmp_img(:) = 0;
        tmp_img(mask) = 1;
        q_mtx(:, :, i) = tmp_img;
    end

    % compute H and normalization factor
    hist_mtx = q_mtx;
    f_mtx = ones(size(q_mtx));

    % ------------x dimension
    % compute left part
    hist_mtx_l = hist_mtx;
    f_mtx_l = f_mtx;
    for i=2:size(hist_mtx, 2)
        hist_mtx_l(:, i, :) = hist_mtx_l(:, i, :) + alpha_x * hist_mtx_l(:, i-1, :);
        f_mtx_l(:, i, :) = f_mtx_l(:, i, :) + alpha_x * f_mtx_l(:, i-1, :);
    end
    % compute right part
    hist_mtx_r = hist_mtx;
    f_mtx_r = f_mtx;
    for i=(size(hist_mtx, 2)-1):-1:1
        hist_mtx_r(:, i, :) = hist_mtx_r(:, i, :) + alpha_x * hist_mtx_r(:, i+1, :);
        f_mtx_r(:, i, :) = f_mtx_r(:, i, :) + alpha_x * f_mtx_r(:, i+1, :);
    end
    % combine right and left parts
    hist_mtx = hist_mtx_r + hist_mtx_l - q_mtx;
    f_mtx = f_mtx_r + f_mtx_l - 1;

    % ------------y dimension 
    % compute left part
    hist_mtx_l = hist_mtx;
    f_mtx_l = f_mtx;
    for i=2:size(hist_mtx, 1)
        hist_mtx_l(i, :, :) = hist_mtx_l(i, :, :) + alpha_y * hist_mtx_l(i-1, :, :);
        f_mtx_l(i, :, :) = f_mtx_l(i, :, :) + alpha_y * f_mtx_l(i-1, :, :);
    end
    % compute right part
    hist_mtx_r = hist_mtx;
    f_mtx_r = f_mtx;
    for i=(size(hist_mtx, 1)-1):-1:1
        hist_mtx_r(i, :, :) = hist_mtx_r(i, :, :) + alpha_y * hist_mtx_r(i+1, :, :);
        f_mtx_r(i, :, :) = f_mtx_r(i, :, :) + alpha_y * f_mtx_r(i+1, :, :);
    end
    % combine right and left parts
    hist_mtx = hist_mtx_r + hist_mtx_l - q_mtx;
    f_mtx = f_mtx_r + f_mtx_l - 1;

    % normalize H using normailization factor
    hist_mtx = hist_mtx ./ f_mtx;

end