function tgvecs = util_transform_tangents( tgvecs,transmat )
% transform tangent vectors given the transformation matrix that used to
% transform points

ntg = size(tgvecs,2);
ndim = size(tgvecs,1);
pts1 = zeros(ndim,ntg);
pts2 = pts1 + tgvecs;

pts1(end+1,:) = 1;
pts2(end+1,:) = 1;
pts1 = transmat * pts1;
pts2 = transmat * pts2;
newtgvecs = pts2-pts1;
newtgvecs = newtgvecs(1:end-1,:);
newtgvecs = util_normalize_vectors(newtgvecs);

tgvecs = newtgvecs;


end

